/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core;

import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.xattr.dto.FeaturegroupXAttr;
import io.hops.hopsworks.common.featurestore.xattr.dto.FeaturestoreXAttrsConstants;
import io.hops.hopsworks.common.featurestore.xattr.dto.TrainingDatasetXAttrDTO;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.dto.ProvCoreDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvDatasetDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvTypeDTO;
import io.hops.hopsworks.common.util.HopsworksJAXBContext;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless(name="HopsFSProvenanceController")
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class HopsFSProvenanceController {
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private Settings settings;
    @EJB
    private HopsworksJAXBContext converter;

    private ProvCoreDTO getProvCoreXAttr(String path, DistributedFileSystemOps udfso) throws ProvenanceException {
        try {
            byte[] provTypeB = udfso.getXAttr(path, "provenance.core");
            if (provTypeB == null) {
                return null;
            }
            return this.converter.unmarshal(new String(provTypeB), ProvCoreDTO.class);
        }
        catch (GenericException | IOException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - get xattr - prov core - error", "hopsfs - get xattr - prov core - error", e);
        }
    }

    private void setProvCoreXAttr(String path, ProvCoreDTO provCore, DistributedFileSystemOps udfso) throws ProvenanceException {
        try {
            String provType = this.converter.marshal(provCore);
            udfso.upsertXAttr(path, "provenance.core", provType.getBytes());
        }
        catch (GenericException | IOException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - prov core - error", "hopsfs - set xattr - prov core - error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvCoreDTO getDatasetProvCore(Users user, Dataset dataset) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(dataset.getProject(), user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
        try {
            ProvCoreDTO provCoreDTO = this.getProvCoreXAttr(datasetPath, udfso);
            return provCoreDTO;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvTypeDTO getProjectProvType(Users user, Project project) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        String projectPath = Utils.getProjectPath(project.getName());
        try {
            ProvCoreDTO provCore = this.getProvCoreXAttr(projectPath, udfso);
            ProvTypeDTO provTypeDTO = provCore == null ? null : provCore.getType();
            return provTypeDTO;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProjectProvType(Users user, Project project, ProvTypeDTO provType) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            this.updateProjectProvType(project, provType, udfso);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public void updateProjectProvType(Project project, ProvTypeDTO newProvType, DistributedFileSystemOps dfso) throws ProvenanceException {
        String projectPath = Utils.getProjectPath(project.getName());
        ProvCoreDTO provCore = this.getProvCoreXAttr(projectPath, dfso);
        if (provCore != null && newProvType.equals(provCore.getType())) {
            return;
        }
        provCore = new ProvCoreDTO(newProvType, null);
        this.setProvCoreXAttr(projectPath, provCore, dfso);
        provCore = new ProvCoreDTO(newProvType, project.getInode().getId());
        for (Dataset dataset : project.getDatasetCollection()) {
            String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
            ProvCoreDTO datasetProvCore = this.getProvCoreXAttr(datasetPath, dfso);
            if (datasetProvCore != null && (datasetProvCore.getType().equals(Provenance.Type.DISABLED.dto) || datasetProvCore.getType().equals(newProvType))) continue;
            this.updateDatasetProvType(datasetPath, provCore, dfso);
        }
    }

    public void updateDatasetProvType(Dataset dataset, ProvTypeDTO newProvType, DistributedFileSystemOps dfso) throws ProvenanceException {
        ProvCoreDTO newProvCore = new ProvCoreDTO(newProvType, dataset.getProject().getInode().getId());
        String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
        ProvCoreDTO currentProvCore = this.getProvCoreXAttr(datasetPath, dfso);
        if (currentProvCore != null && currentProvCore.getType().equals(newProvType)) {
            return;
        }
        this.updateDatasetProvType(datasetPath, newProvCore, dfso);
    }

    public void newHiveDatasetProvCore(Project project, String hiveDBPath, DistributedFileSystemOps dfso) throws ProvenanceException {
        String projectPath = Utils.getProjectPath(project.getName());
        ProvCoreDTO projectProvCore = this.getProvCoreXAttr(projectPath, dfso);
        if (projectProvCore == null) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "hopsfs - hive db - set meta status error - project without prov core");
        }
        ProvCoreDTO datasetProvCore = new ProvCoreDTO(projectProvCore.getType(), project.getInode().getId());
        this.updateDatasetProvType(hiveDBPath, datasetProvCore, dfso);
    }

    private void updateDatasetProvType(String datasetPath, ProvCoreDTO provCore, DistributedFileSystemOps dfso) throws ProvenanceException {
        try {
            dfso.setMetaStatus(datasetPath, provCore.getType().getMetaStatus());
        }
        catch (IOException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - dataset set meta status error", "hopsfs - dataset set meta status error", (Throwable)e);
        }
        this.setProvCoreXAttr(datasetPath, provCore, dfso);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProvDatasetDTO> getDatasetsProvType(Users user, Project project) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        try (DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);){
            ProvDatasetDTO dsState;
            ProvCoreDTO provCore;
            String datasetPath;
            ArrayList<ProvDatasetDTO> result = new ArrayList<ProvDatasetDTO>();
            for (Dataset dataset : project.getDatasetCollection()) {
                datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
                provCore = this.getProvCoreXAttr(datasetPath, udfso);
                if (provCore == null) {
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "malformed dataset - provenance", "no provenance core xattr");
                }
                dsState = new ProvDatasetDTO(dataset.getName(), dataset.getInode().getId(), provCore.getType());
                result.add(dsState);
            }
            for (Dataset dataset : project.getDatasetSharedWithCollection()) {
                datasetPath = Utils.getFileSystemDatasetPath(dataset.getDataset(), this.settings);
                provCore = this.getProvCoreXAttr(datasetPath, udfso);
                if (provCore == null) {
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "malformed dataset - provenance", "no provenance core xattr");
                }
                dsState = new ProvDatasetDTO(dataset.getDataset().getProject().getName() + "::" + dataset.getDataset().getName(), dataset.getDataset().getInode().getId(), provCore.getType());
                result.add(dsState);
            }
            ArrayList<ProvDatasetDTO> arrayList = result;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void featuregroupAttachXAttrs(Users user, Project project, FeaturegroupDTO featuregroup) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            String path = Utils.getFeaturestorePath(project, this.settings) + "/" + Utils.getFeaturegroupName(featuregroup.getName(), featuregroup.getVersion());
            FeaturegroupXAttr.FullDTO fg = this.fromFeaturegroup(featuregroup);
            try {
                udfso.upsertXAttr(path, FeaturestoreXAttrsConstants.getFeaturestoreXAttrKey(), this.converter.marshal(fg).getBytes());
            }
            catch (GenericException | IOException e) {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - featuregroup - error", "hopsfs - set xattr - featuregroup - error", e);
            }
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trainingDatasetAttachXAttr(Users user, Project project, String path, TrainingDatasetDTO trainingDatasetDTO) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            TrainingDatasetXAttrDTO td = new TrainingDatasetXAttrDTO(trainingDatasetDTO.getFeaturestoreId(), trainingDatasetDTO.getDescription(), trainingDatasetDTO.getCreated(), trainingDatasetDTO.getCreator());
            if (trainingDatasetDTO.getFeatures() != null) {
                List<FeaturegroupXAttr.SimplifiedDTO> featuresDTO = this.fromTrainingDataset(trainingDatasetDTO);
                td.setFeatures(featuresDTO);
            }
            try {
                udfso.upsertXAttr(path, FeaturestoreXAttrsConstants.getFeaturestoreXAttrKey(), this.converter.marshal(td).getBytes());
            }
            catch (GenericException | IOException e) {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - training dataset - error", "hopsfs - set xattr - training dataset - error", e);
            }
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public ProvTypeDTO getMetaStatus(Users user, Project project, Boolean searchable) throws ProvenanceException {
        if (searchable != null && searchable.booleanValue()) {
            ProvTypeDTO projectMetaStatus = this.getProjectProvType(user, project);
            if (Inode.MetaStatus.DISABLED.equals((Object)projectMetaStatus.getMetaStatus())) {
                return Provenance.Type.META.dto;
            }
            return projectMetaStatus;
        }
        return Provenance.Type.DISABLED.dto;
    }

    private List<FeaturegroupXAttr.SimplifiedDTO> fromTrainingDataset(TrainingDatasetDTO trainingDatasetDTO) {
        LinkedList<FeaturegroupXAttr.SimplifiedDTO> result = new LinkedList<FeaturegroupXAttr.SimplifiedDTO>();
        HashMap<String, FeaturegroupXAttr.SimplifiedDTO> featuregroups = new HashMap<String, FeaturegroupXAttr.SimplifiedDTO>();
        for (FeatureDTO feature : trainingDatasetDTO.getFeatures()) {
            FeaturegroupXAttr.SimplifiedDTO featuregroup = (FeaturegroupXAttr.SimplifiedDTO)featuregroups.get(feature.getFeaturegroup());
            if (featuregroup == null) {
                featuregroup = new FeaturegroupXAttr.SimplifiedDTO(trainingDatasetDTO.getFeaturestoreId(), feature.getFeaturegroup(), feature.getVersion());
                featuregroups.put(feature.getFeaturegroup(), featuregroup);
                result.add(featuregroup);
            }
            featuregroup.addFeature(feature.getName());
        }
        return result;
    }

    private FeaturegroupXAttr.FullDTO fromFeaturegroup(FeaturegroupDTO featuregroup) {
        LinkedList<String> features = new LinkedList<String>();
        for (FeatureDTO feature : featuregroup.getFeatures()) {
            features.add(feature.getName());
        }
        return new FeaturegroupXAttr.FullDTO(featuregroup.getFeaturestoreId(), featuregroup.getDescription(), featuregroup.getCreated(), featuregroup.getCreator(), features);
    }
}

