/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.util.FormatUtils;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.Reader;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.json.Json;
import javax.json.JsonObject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;

@Stateless
public class WebCommunication {
    private static final Logger logger = Logger.getLogger(WebCommunication.class.getName());
    private static boolean DISABLE_CERTIFICATE_VALIDATION = true;
    private static String PROTOCOL = "https";
    private static int PORT = 8090;
    private static String NOT_AVAILABLE = "Not available.";
    private final ConcurrentLinkedQueue<Client> inUseClientPool = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Client> availableClientPool = new ConcurrentLinkedQueue();
    @EJB
    private Settings settings;

    @PreDestroy
    private void cleanUp() {
        for (Client client : this.availableClientPool) {
            client.close();
            client = null;
        }
        for (Client client : this.inUseClientPool) {
            client.close();
            Object var2_2 = null;
        }
    }

    public Response getWebResponse(String url, String agentPassword) {
        try {
            Response response = this.getWebResource(url, agentPassword);
            return response;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String serviceOp(String operation, String hostAddress, String agentPassword, String group, String service) throws GenericException {
        String url = this.createUrl(operation, hostAddress, group, service);
        return this.fetchContent(url, agentPassword);
    }

    @Asynchronous
    public Future<String> asyncServiceOp(String operation, String hostAddress, String agentPassword, String group, String service) throws GenericException {
        String url = this.createUrl(operation, hostAddress, group, service);
        return new AsyncResult((Object)this.fetchContent(url, agentPassword));
    }

    public String getConfig(String hostAddress, String agentPassword, String group, String service) throws GenericException {
        String url = this.createUrl("config", hostAddress, group, service);
        return this.fetchContent(url, agentPassword);
    }

    public String executeRun(String hostAddress, String agentPassword, String group, String service, String command, String[] params) throws Exception {
        return this.execute("execute/run", hostAddress, agentPassword, group, service, command, params);
    }

    public String executeStart(String hostAddress, String agentPassword, String group, String service, String command, String[] params) throws Exception {
        return this.execute("execute/start", hostAddress, agentPassword, group, service, command, params);
    }

    public String executeContinue(String hostAddress, String agentPassword, String group, String service, String command, String[] params) throws Exception {
        return this.execute("execute/continue", hostAddress, agentPassword, group, service, command, params);
    }

    private String execute(String path, String hostAddress, String agentPassword, String group, String service, String command, String[] params) throws Exception {
        String url = this.createUrl(path, hostAddress, group, service, command);
        String optionsAndParams = "";
        for (String param : params) {
            optionsAndParams = optionsAndParams + (optionsAndParams.isEmpty() ? param : " " + param);
        }
        Response response = this.postWebResource(url, agentPassword, optionsAndParams);
        int code = response.getStatus();
        Response.Status.Family res = Response.Status.Family.familyOf((int)code);
        if (res == Response.Status.Family.SUCCESSFUL) {
            String responseString = (String)response.readEntity(String.class);
            if (path.equalsIgnoreCase("execute/continue")) {
                JsonObject json = Json.createReader((Reader)((Reader)response.readEntity(Reader.class))).readObject();
                responseString = json.getString("before");
            }
            return FormatUtils.stdoutToHtml((String)responseString);
        }
        throw new RuntimeException("Did not succeed to execute command.");
    }

    public Response doCommand(String hostAddress, String agentPassword, String cluster, String group, String service, String command) throws Exception {
        String url = this.createUrl("do", hostAddress, agentPassword, cluster, group, service, command);
        return this.getWebResource(url, agentPassword);
    }

    private String createUrl(String context, String hostAddress, String ... args) {
        String template = "%s://%s:%s/%s";
        String url = String.format(template, PROTOCOL, hostAddress, PORT, context);
        for (int i = 0; i < args.length; ++i) {
            url = url + "/" + args[i];
        }
        return url;
    }

    private String fetchContent(String url, String agentPassword) throws GenericException {
        String content = NOT_AVAILABLE;
        try {
            Response response = this.getWebResource(url, agentPassword);
            int code = response.getStatus();
            Response.Status.Family res = Response.Status.Family.familyOf((int)code);
            content = (String)response.readEntity(String.class);
            if (res == Response.Status.Family.SUCCESSFUL) {
                return content;
            }
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, "response status: " + response.getStatus(), "Error code:" + code + " Reason: " + content);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, null, e);
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
    }

    private Response getWebResource(String url, String agentPassword) throws NoSuchAlgorithmException, KeyManagementException {
        return this.getWebResource(url, agentPassword, null);
    }

    private Response getWebResource(String url, String agentPassword, Map<String, String> args) throws NoSuchAlgorithmException, KeyManagementException {
        Client client = this.getClient();
        WebTarget webResource = client.target(url);
        webResource = webResource.queryParam("username", new Object[]{"kagent@hops.io"});
        webResource = webResource.queryParam("password", new Object[]{agentPassword});
        if (args != null) {
            for (String key : args.keySet()) {
                webResource = webResource.queryParam(key, new Object[]{args.get(key)});
            }
        }
        logger.log(Level.FINEST, "WebCommunication: Requesting url: {0} with password {1}", new Object[]{url, agentPassword});
        Response response = (Response)webResource.request().header("Accept-Encoding", (Object)"gzip,deflate").get(Response.class);
        this.discardClient(client);
        logger.log(Level.INFO, "WebCommunication: Requesting url: {0}", url);
        return response;
    }

    private Client getClient() throws NoSuchAlgorithmException, KeyManagementException {
        Client client = this.availableClientPool.poll();
        if (null == client) {
            client = this.createClient();
        }
        this.inUseClientPool.offer(client);
        return client;
    }

    private void discardClient(Client client) {
        this.inUseClientPool.remove(client);
        this.availableClientPool.offer(client);
    }

    private Client createClient() throws NoSuchAlgorithmException, KeyManagementException {
        if (DISABLE_CERTIFICATE_VALIDATION) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String hostAddress, SSLSession session) {
                    return true;
                }
            };
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, trustAllCerts, new SecureRandom());
            ClientBuilder clientBuilder = ClientBuilder.newBuilder().hostnameVerifier(hv).sslContext(sc);
            return clientBuilder.build();
        }
        return ClientBuilder.newClient();
    }

    private Response postWebResource(String url, String agentPassword, String body) throws Exception {
        return this.postWebResource(url, agentPassword, "", "", body);
    }

    private Response postWebResource(String url, String agentPassword, String channelUrl, String version, String body) throws Exception {
        Client client = this.getClient();
        WebTarget webResource = client.target(url);
        webResource.queryParam("username", new Object[]{"kagent@hops.io"});
        webResource.queryParam("password", new Object[]{agentPassword});
        Response response = (Response)webResource.request().header("Accept-Encoding", (Object)"gzip,deflate").post(Entity.entity((Object)body, (String)"text/plain"), Response.class);
        this.discardClient(client);
        return response;
    }

    public Object anaconda(String hostAddress, String agentPassword, String op, String project, String arg) throws Exception {
        Response response;
        int code;
        Response.Status.Family res;
        String path = "anaconda/" + this.settings.getAnacondaUser() + '/' + op.toLowerCase() + "/" + project;
        String template = "%s://%s:%s/%s";
        String url = String.format(template, PROTOCOL, hostAddress, PORT, path);
        HashMap<String, String> args = null;
        if (op.compareToIgnoreCase(CondaOp.CLONE.toString()) == 0) {
            args = new HashMap<String, String>();
            if (arg == null || arg.isEmpty()) {
                throw new RuntimeException("You forgot the 'srcProject' argument for the conda clone environment command for project " + project);
            }
            args.put("srcproj", arg);
        }
        if ((res = Response.Status.Family.familyOf((int)(code = (response = this.getWebResource(url, agentPassword, args)).getStatus()))) == Response.Status.Family.SUCCESSFUL) {
            return response.getEntity();
        }
        throw new RuntimeException("Error. Failed to execute anaconda command " + op + " on " + project + ". Result was: " + res);
    }

    public Object conda(String hostAddress, String agentPassword, String op, String project, String channel, String lib, String version) throws Exception {
        Response response;
        int code;
        Response.Status.Family res;
        String template = "%s://%s:%s/%s";
        String channelEscaped = StringEscapeUtils.escapeJava((String)channel);
        String path = "conda/" + this.settings.getHopsworksUser() + '/' + op.toLowerCase() + "/" + project + "/" + lib;
        String url = String.format(template, PROTOCOL, hostAddress, PORT, path);
        HashMap<String, String> args = new HashMap<String, String>();
        if (!channel.isEmpty()) {
            args.put("channelurl", channelEscaped);
        }
        if (!version.isEmpty()) {
            args.put("version", version);
        }
        if ((res = Response.Status.Family.familyOf((int)(code = (response = this.getWebResource(url, agentPassword, args)).getStatus()))) == Response.Status.Family.SUCCESSFUL) {
            return response.getEntity();
        }
        throw new RuntimeException("Error. Failed to execute conda command " + op + " on " + project + ". Result was: " + res);
    }
}

