/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.jobs;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.jobs.FeaturestoreJob;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class FeaturestoreJobFacade
extends AbstractFacade<FeaturestoreJob> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeaturestoreJobFacade() {
        super(FeaturestoreJob.class);
    }

    public void insertJobs(TrainingDataset trainingDataset, List<Jobs> jobs) {
        if (jobs != null) {
            jobs.stream().forEach(job -> {
                if (!this.isJobExists((List)trainingDataset.getJobs(), (Jobs)job).booleanValue()) {
                    FeaturestoreJob featurestoreJob = new FeaturestoreJob();
                    featurestoreJob.setTrainingDataset(trainingDataset);
                    featurestoreJob.setJob(job);
                    featurestoreJob.setFeaturegroup(null);
                    this.em.persist((Object)featurestoreJob);
                }
            });
            this.em.flush();
        }
    }

    public void insertJobs(Featuregroup featuregroup, List<Jobs> jobs) {
        if (jobs != null) {
            jobs.stream().forEach(job -> {
                if (!this.isJobExists((List)featuregroup.getJobs(), (Jobs)job).booleanValue()) {
                    FeaturestoreJob featurestoreJob = new FeaturestoreJob();
                    featurestoreJob.setTrainingDataset(null);
                    featurestoreJob.setJob(job);
                    featurestoreJob.setFeaturegroup(featuregroup);
                    this.em.persist((Object)featurestoreJob);
                }
            });
            this.em.flush();
        }
    }

    public List<FeaturestoreJob> getByFeatureGroup(Featuregroup featuregroup) {
        return this.em.createNamedQuery("FeaturestoreJob.findByFeaturegroup", FeaturestoreJob.class).setParameter("featuregroup", (Object)featuregroup).getResultList();
    }

    public List<FeaturestoreJob> getByTrainingDataset(TrainingDataset trainingDataset) {
        return this.em.createNamedQuery("FeaturestoreJob.findByTrainingDataset", FeaturestoreJob.class).setParameter("trainingDataset", (Object)trainingDataset).getResultList();
    }

    private Boolean isJobExists(List<FeaturestoreJob> jobs, Jobs job) {
        return jobs.stream().anyMatch(fsjob -> fsjob.getJob().getId().equals(job.getId()));
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }
}

