/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hosts;

import com.logicalclocks.servicediscoverclient.Builder;
import com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceNotFoundException;
import com.logicalclocks.servicediscoverclient.resolvers.Type;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import io.hops.hopsworks.common.util.Settings;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.NotImplementedException;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ServiceDiscoveryController {
    private static final String CONSUL_SERVICE_TEMPLATE = "%s.service.%s";
    @EJB
    private Settings settings;

    @Lock(value=LockType.READ)
    public String constructServiceFQDN(HopsworksService service) {
        String serviceName = service.getServiceName();
        if (serviceName.endsWith(".")) {
            serviceName = serviceName.substring(0, serviceName.length() - 1);
        }
        return String.format(CONSUL_SERVICE_TEMPLATE, serviceName, this.settings.getServiceDiscoveryDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Lock(value=LockType.READ)
    public Stream<Service> getService(Type resolverType, ServiceQuery serviceQuery) throws ServiceDiscoveryException {
        try (ServiceDiscoveryClient client = this.getClient(resolverType);){
            Stream stream = client.getService(serviceQuery);
            return stream;
        }
    }

    @Lock(value=LockType.READ)
    public Service getAnyAddressOfServiceWithDNS(HopsworksService serviceName) throws ServiceDiscoveryException {
        ServiceQuery serviceQuery = ServiceQuery.of((String)this.constructServiceFQDN(serviceName), Collections.emptySet());
        Optional<Service> serviceOpt = this.getService(Type.DNS, serviceQuery).findAny();
        return serviceOpt.orElseThrow(() -> new ServiceNotFoundException("Could not find service with: " + serviceQuery));
    }

    private ServiceDiscoveryClient getClient(Type type) throws ServiceDiscoveryException {
        switch (type) {
            case DNS: {
                return new Builder(type).build();
            }
            case HTTP: 
            case CACHING: {
                throw new NotImplementedException(type + " resolver is not implemented yet");
            }
        }
        throw new RuntimeException("Unknown Service Discovery resolver type: " + type);
    }

    public static enum HopsworksService {
        LIVY("livy"),
        ZOOKEEPER_CLIENT("client.zookeeper"),
        SPARK_HISTORY_SERVER("sparkhistoryserver"),
        HTTP_RESOURCEMANAGER("http.resourcemanager"),
        HIVE_SERVER_PLAIN("hiveserver2-plain.hive"),
        HIVE_SERVER_TLS("hiveserver2-tls.hive"),
        RPC_NAMENODE("rpc.namenode"),
        TF_SERVING_LOGSTASH("tfserving.logstash"),
        SKLEARN_SERVING_LOGSTASH("sklearnserving.logstash"),
        PYTHON_JOBS_LOGSTASH("pythonjobs.logstash");

        private String name;

        private HopsworksService(String name) {
            this.name = name;
        }

        public String getServiceName() {
            return this.name;
        }
    }
}

