/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.state;

import io.hops.hopsworks.common.provenance.app.ProvAppController;
import io.hops.hopsworks.common.provenance.app.ProvAppHelper;
import io.hops.hopsworks.common.provenance.app.dto.ProvAppStateDTO;
import io.hops.hopsworks.common.provenance.app.dto.ProvAppStateElastic;
import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticCache;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHelper;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHitsHandler;
import io.hops.hopsworks.common.provenance.core.elastic.ProvElasticController;
import io.hops.hopsworks.common.provenance.state.ProvFileStateParamBuilder;
import io.hops.hopsworks.common.provenance.state.dto.ProvStateElastic;
import io.hops.hopsworks.common.provenance.state.dto.ProvStateListDTO;
import io.hops.hopsworks.common.provenance.util.ProvHelper;
import io.hops.hopsworks.common.provenance.util.functional.CheckedFunction;
import io.hops.hopsworks.common.provenance.util.functional.CheckedSupplier;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.javatuples.Pair;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProvStateController {
    private static final Logger LOGGER = Logger.getLogger(ProvStateController.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private ProvElasticController client;
    @EJB
    private ProvAppController appCtrl;
    @EJB
    private ElasticCache cache;

    public ProvStateListDTO provFileStateList(Project project, ProvFileStateParamBuilder params) throws ProvenanceException {
        if (params.getPagination() != null && !params.getAppStateFilter().isEmpty()) {
            String msg = "cannot use pagination with app state filtering";
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.UNSUPPORTED, Level.INFO, msg);
        }
        this.checkMapping(project, params);
        ProvStateListDTO fileStates = this.provFileState(project.getInode().getId(), params.getFileStateFilter(), params.getFileStateSortBy(), params.getExactXAttrFilter(), params.getLikeXAttrFilter(), params.getHasXAttrFilter(), params.getXAttrSortBy(), (Integer)params.getPagination().getValue0(), (Integer)params.getPagination().getValue1());
        if (params.hasAppExpansion()) {
            for (ProvStateElastic fileState : fileStates.getItems()) {
                Optional<String> appId = this.getAppId(fileState);
                if (!appId.isPresent()) continue;
                params.withAppExpansion(appId.get());
            }
            Map<String, Map<Provenance.AppState, ProvAppStateElastic>> appExps = this.appCtrl.provAppState(params.getAppStateFilter());
            for (ProvStateElastic fileState : fileStates.getItems()) {
                Optional<String> appId = this.getAppId(fileState);
                if (appId.isPresent() && appExps.containsKey(appId.get())) {
                    Map<Provenance.AppState, ProvAppStateElastic> appExp = appExps.get(appId.get());
                    fileState.setAppState(ProvAppHelper.buildAppState(appExp));
                    continue;
                }
                fileState.setAppState(ProvAppStateDTO.unknown());
            }
        }
        return fileStates;
    }

    public long provFileStateCount(Project project, ProvFileStateParamBuilder params) throws ProvenanceException {
        if (params.hasAppExpansion()) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.UNSUPPORTED, Level.INFO, "provenance file state count does not currently work with app state expansion");
        }
        return this.provFileStateCount(project.getInode().getId(), params.getFileStateFilter(), params.getExactXAttrFilter(), params.getLikeXAttrFilter(), params.getHasXAttrFilter());
    }

    private void checkMapping(Project project, ProvFileStateParamBuilder params) throws ProvenanceException {
        String index = Provenance.getProjectIndex(project);
        try {
            Map<String, String> mapping = this.cache.mngIndexGetMapping(index, false);
            try {
                params.fixSortBy(index, mapping);
            }
            catch (ProvenanceException e) {
                mapping = this.cache.mngIndexGetMapping(index, true);
                if (mapping.isEmpty()) {
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "provenance file state - no index");
                }
                params.fixSortBy(index, mapping);
            }
        }
        catch (ElasticException e) {
            String msg = "provenance - elastic query problem";
            throw ProvHelper.fromElastic(e, msg, msg + " - file state mapping");
        }
    }

    private Optional<String> getAppId(ProvStateElastic fileState) {
        if (fileState.getAppId().equals("none")) {
            if (fileState.getXattrs().containsKey("appId")) {
                return Optional.of(fileState.getXattrs().get("appId"));
            }
            return Optional.empty();
        }
        return Optional.of(fileState.getAppId());
    }

    private ProvStateListDTO provFileState(Long projectIId, Map<String, ProvParser.FilterVal> fileStateFilters, List<Pair<ProvParser.Field, SortOrder>> fileStateSortBy, Map<String, String> xAttrsFilters, Map<String, String> likeXAttrsFilters, Set<String> hasXAttrsFilters, List<ProvFileStateParamBuilder.SortE> xattrSortBy, Integer offset, Integer limit) throws ProvenanceException {
        Pair<Long, List<ProvStateElastic>> searchResult;
        CheckedSupplier<SearchRequest, ProvenanceException> srF = ElasticHelper.baseSearchRequest(this.settings.getProvFileIndex(projectIId), this.settings.getElasticDefaultScrollPageSize()).andThen(this.filterByStateParams(fileStateFilters, xAttrsFilters, likeXAttrsFilters, hasXAttrsFilters)).andThen(ElasticHelper.withFileStateOrder(fileStateSortBy, xattrSortBy)).andThen(ElasticHelper.withPagination(offset, limit, this.settings.getElasticMaxScrollPageSize().intValue()));
        SearchRequest request = srF.get();
        try {
            searchResult = this.client.search(request, this.fileStateParser());
        }
        catch (ElasticException e) {
            String msg = "provenance - elastic query problem";
            throw ProvHelper.fromElastic(e, msg, msg + " - file state");
        }
        return new ProvStateListDTO((List)searchResult.getValue1(), (Long)searchResult.getValue0());
    }

    private Long provFileStateCount(Long projectIId, Map<String, ProvParser.FilterVal> fileStateFilters, Map<String, String> xAttrsFilters, Map<String, String> likeXAttrsFilters, Set<String> hasXAttrsFilters) throws ProvenanceException {
        Long searchResult;
        CheckedSupplier<SearchRequest, ProvenanceException> srF = ElasticHelper.countSearchRequest(this.settings.getProvFileIndex(projectIId)).andThen(this.filterByStateParams(fileStateFilters, xAttrsFilters, likeXAttrsFilters, hasXAttrsFilters));
        SearchRequest request = srF.get();
        try {
            searchResult = this.client.searchCount(request);
        }
        catch (ElasticException e) {
            String msg = "provenance - elastic query problem";
            throw ProvHelper.fromElastic(e, msg, msg + " - file state count");
        }
        return searchResult;
    }

    private ElasticHitsHandler<ProvStateElastic, List<ProvStateElastic>, ?, ProvenanceException> fileStateParser() {
        return ElasticHitsHandler.instanceAddToList(hit -> ProvStateElastic.instance(hit));
    }

    private CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> filterByStateParams(Map<String, ProvParser.FilterVal> fileStateFilters, Map<String, String> xAttrsFilters, Map<String, String> likeXAttrsFilters, Set<String> hasXAttrsFilters) {
        return sr -> {
            BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)ProvParser.BaseField.ENTRY_TYPE.toString().toLowerCase(), (String)ProvParser.EntryType.STATE.toString().toLowerCase()));
            query = ElasticHelper.filterByBasicFields(query, fileStateFilters);
            for (Map.Entry filter : xAttrsFilters.entrySet()) {
                query = query.must(this.getXAttrQB((String)filter.getKey(), (String)filter.getValue()));
            }
            for (Map.Entry filter : likeXAttrsFilters.entrySet()) {
                query = query.must(this.getLikeXAttrQB((String)filter.getKey(), (String)filter.getValue()));
            }
            for (String xattrKey : hasXAttrsFilters) {
                query = query.must(this.hasXAttrQB(xattrKey));
            }
            sr.source().query((QueryBuilder)query);
            return sr;
        };
    }

    public QueryBuilder hasXAttrQB(String xattrAdjustedKey) {
        return QueryBuilders.existsQuery((String)xattrAdjustedKey);
    }

    public QueryBuilder getXAttrQB(String xattrAdjustedKey, String xattrVal) {
        return QueryBuilders.termQuery((String)xattrAdjustedKey, (String)xattrVal.toLowerCase());
    }

    public QueryBuilder getLikeXAttrQB(String xattrAdjustedKey, String xattrVal) {
        return ElasticHelper.fullTextSearch(xattrAdjustedKey, xattrVal);
    }
}

