/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.jdbc;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorType;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorFacade;
import io.hops.hopsworks.common.hive.HiveController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnector;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class FeaturestoreJdbcConnectorController {
    @EJB
    private FeaturestoreJdbcConnectorFacade featurestoreJdbcConnectorFacade;
    @EJB
    private Settings settings;
    @EJB
    private HiveController hiveController;

    public FeaturestoreJdbcConnectorDTO createFeaturestoreJdbcConnector(Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO) throws FeaturestoreException {
        this.verifyUserInput(featurestore, featurestoreJdbcConnectorDTO);
        FeaturestoreJdbcConnector featurestoreJdbcConnector = new FeaturestoreJdbcConnector();
        featurestoreJdbcConnector.setName(featurestoreJdbcConnectorDTO.getName());
        featurestoreJdbcConnector.setDescription(featurestoreJdbcConnectorDTO.getDescription());
        featurestoreJdbcConnector.setFeaturestore(featurestore);
        featurestoreJdbcConnector.setArguments(featurestoreJdbcConnectorDTO.getArguments());
        featurestoreJdbcConnector.setConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        this.featurestoreJdbcConnectorFacade.persist(featurestoreJdbcConnector);
        return new FeaturestoreJdbcConnectorDTO(featurestoreJdbcConnector);
    }

    public FeaturestoreJdbcConnectorDTO updateFeaturestoreJdbcConnector(Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, Integer storageConnectorId) throws FeaturestoreException {
        FeaturestoreJdbcConnector featurestoreJdbcConnector = this.verifyJdbcConnectorId(storageConnectorId, featurestore);
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getName())) {
            this.verifyJdbcConnectorName(featurestoreJdbcConnectorDTO.getName(), featurestore, true);
            featurestoreJdbcConnector.setName(featurestoreJdbcConnectorDTO.getName());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getDescription())) {
            this.verifyJdbcConnectorDescription(featurestoreJdbcConnectorDTO.getDescription());
            featurestoreJdbcConnector.setDescription(featurestoreJdbcConnectorDTO.getDescription());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getConnectionString())) {
            this.verifyJdbcConnectorConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
            featurestoreJdbcConnector.setConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getArguments())) {
            this.verifyJdbcConnectorArguments(featurestoreJdbcConnectorDTO.getArguments());
            featurestoreJdbcConnector.setArguments(featurestoreJdbcConnectorDTO.getArguments());
        }
        if (featurestore != null) {
            featurestoreJdbcConnector.setFeaturestore(featurestore);
        }
        FeaturestoreJdbcConnector updatedConnector = this.featurestoreJdbcConnectorFacade.updateJdbcConnector(featurestoreJdbcConnector);
        return new FeaturestoreJdbcConnectorDTO(updatedConnector);
    }

    public void createDefaultJdbcConnectorForOfflineFeaturestore(Featurestore featurestore, String databaseName, String description) throws FeaturestoreException {
        try {
            String hiveEndpoint = this.hiveController.getHiveServerInternalEndpoint();
            String connectionString = "jdbc:hive2://" + hiveEndpoint + "/" + databaseName + ";auth=noSasl;ssl=true;twoWay=true;";
            String arguments = "sslTrustStore,trustStorePassword,sslKeyStore,keyStorePassword";
            String name = databaseName;
            FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO();
            featurestoreJdbcConnectorDTO.setName(name);
            featurestoreJdbcConnectorDTO.setDescription(description);
            featurestoreJdbcConnectorDTO.setConnectionString(connectionString);
            featurestoreJdbcConnectorDTO.setArguments(arguments);
            this.createFeaturestoreJdbcConnector(featurestore, featurestoreJdbcConnectorDTO);
        }
        catch (ServiceDiscoveryException ex) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.JDBC_CONNECTOR_NOT_FOUND, Level.SEVERE, "Could not create Hive connection string", ex.getMessage(), (Throwable)ex);
        }
    }

    public FeaturestoreJdbcConnectorDTO removeFeaturestoreJdbcConnector(Integer featurestoreJdbcId) {
        FeaturestoreJdbcConnector featurestoreJdbcConnector = (FeaturestoreJdbcConnector)this.featurestoreJdbcConnectorFacade.find(featurestoreJdbcId);
        FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO(featurestoreJdbcConnector);
        this.featurestoreJdbcConnectorFacade.remove(featurestoreJdbcConnector);
        return featurestoreJdbcConnectorDTO;
    }

    private FeaturestoreJdbcConnector verifyJdbcConnectorId(Integer jdbcConnectorId, Featurestore featurestore) throws FeaturestoreException {
        FeaturestoreJdbcConnector featurestoreJdbcConnector = this.featurestoreJdbcConnectorFacade.findByIdAndFeaturestore(jdbcConnectorId, featurestore);
        if (featurestoreJdbcConnector == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.JDBC_CONNECTOR_NOT_FOUND, Level.FINE, "jdbcConnectorId: " + jdbcConnectorId);
        }
        return featurestoreJdbcConnector;
    }

    private void verifyJdbcConnectorName(String name, Featurestore featurestore, Boolean edit) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the storage connector name cannot be empty");
        }
        if (name.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the name should be less than 1000 characters, the provided name was: " + name);
        }
        if (!edit.booleanValue() && featurestore.getFeaturestoreJdbcConnectorConnections().stream().anyMatch(jdbcCon -> jdbcCon.getName().equalsIgnoreCase(name))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the storage connector name should be unique, there already exists a JDBC connector with the same name ");
        }
    }

    private void verifyFeaturestoreInput(Featurestore featurestore) {
        if (featurestore == null) {
            throw new IllegalArgumentException("Featurestore was not found");
        }
    }

    private void verifyJdbcConnectorDescription(String description) throws FeaturestoreException {
        if (description.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_DESCRIPTION, Level.FINE, ", the description should be less than: 1000");
        }
    }

    private void verifyJdbcConnectorConnectionString(String connectionString) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)connectionString) || connectionString.length() > 5000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_STRING, Level.FINE, ", the JDBC connection string should not be empty and not exceed: 5000 characters");
        }
    }

    private void verifyJdbcConnectorArguments(String arguments) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)arguments) && arguments.length() > 2000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_ARGUMENTS, Level.FINE, ", the JDBC connection arguments should not exceed: 2000 characters");
        }
    }

    private void verifyUserInput(Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO) throws FeaturestoreException {
        if (featurestoreJdbcConnectorDTO == null) {
            throw new IllegalArgumentException("Input data is null");
        }
        this.verifyFeaturestoreInput(featurestore);
        this.verifyJdbcConnectorName(featurestoreJdbcConnectorDTO.getName(), featurestore, false);
        this.verifyJdbcConnectorDescription(featurestoreJdbcConnectorDTO.getDescription());
        this.verifyJdbcConnectorConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        this.verifyJdbcConnectorArguments(featurestoreJdbcConnectorDTO.getArguments());
    }

    public List<FeaturestoreStorageConnectorDTO> getJdbcConnectorsForFeaturestore(Featurestore featurestore) {
        List<FeaturestoreJdbcConnector> jdbcConnectors = this.featurestoreJdbcConnectorFacade.findByFeaturestore(featurestore);
        return jdbcConnectors.stream().map(jdbcConnector -> new FeaturestoreJdbcConnectorDTO((FeaturestoreJdbcConnector)jdbcConnector)).collect(Collectors.toList());
    }

    public FeaturestoreJdbcConnectorDTO getJdbcConnectorWithIdAndFeaturestore(Featurestore featurestore, Integer id) throws FeaturestoreException {
        FeaturestoreJdbcConnector featurestoreJdbcConnector = this.verifyJdbcConnectorId(id, featurestore);
        return new FeaturestoreJdbcConnectorDTO(featurestoreJdbcConnector);
    }

    public FeaturestoreJdbcConnectorDTO createJdbcConnectorForOnlineFeaturestore(String onlineDbUsername, Featurestore featurestore, String dbName) throws FeaturestoreException {
        String connectorName = onlineDbUsername + "_onlinefeaturestore";
        List<FeaturestoreStorageConnectorDTO> featurestoreConnectors = this.getJdbcConnectorsForFeaturestore(featurestore);
        for (FeaturestoreStorageConnectorDTO storageConnector : featurestoreConnectors) {
            if (!connectorName.equalsIgnoreCase(storageConnector.getName())) continue;
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, "a storage connector with that name already exists");
        }
        String connectionString = this.settings.getFeaturestoreJdbcUrl() + dbName;
        String arguments = "password=<SECRETPASSWORD>,user=" + onlineDbUsername;
        FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO();
        featurestoreJdbcConnectorDTO.setConnectionString(connectionString);
        featurestoreJdbcConnectorDTO.setDescription("JDBC connection to Hopsworks Project Online Feature Store NDB Database for user: " + onlineDbUsername);
        featurestoreJdbcConnectorDTO.setArguments(arguments);
        featurestoreJdbcConnectorDTO.setStorageConnectorType(FeaturestoreStorageConnectorType.JDBC);
        featurestoreJdbcConnectorDTO.setName(connectorName);
        featurestoreJdbcConnectorDTO.setFeaturestoreId(featurestore.getId());
        return this.createFeaturestoreJdbcConnector(featurestore, featurestoreJdbcConnectorDTO);
    }
}

