/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hdfs.xattrs;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.MetadataException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.fs.Path;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

@Stateless(name="XAttrsController")
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class XAttrsController {
    private static String XATTR_USER_NAMESPACE = "user.";
    @EJB
    private InodeController inodeController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private DistributedFsService dfs;

    public boolean addXAttr(Project project, Users user, String inodePath, String name, String metaObj) throws DatasetException, MetadataException {
        if (name == null || name.isEmpty()) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MISSING_FIELD, Level.FINE);
        }
        JSONObject metaJSON = null;
        Object json = new JSONTokener(metaObj).nextValue();
        if (json instanceof JSONObject) {
            metaJSON = (JSONObject)json;
        } else if (json instanceof JSONArray) {
            metaJSON = new JSONObject();
            metaJSON.put(name, (Object)json.toString());
        }
        if (!metaJSON.has(name)) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MISSING_FIELD, Level.FINE);
        }
        String metadata = metaJSON.getString(name);
        if (metadata.length() > 13500 || name.length() > 255) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MAX_SIZE_EXCEEDED, Level.FINE);
        }
        boolean created = this.getXAttr(project, user, inodePath, name) == null;
        this.addXAttrInt(project, user, inodePath, name, metadata);
        return created;
    }

    public Map<String, String> getXAttrs(Project project, Users user, String inodePath, String name) throws DatasetException, MetadataException {
        HashMap<String, String> result = new HashMap();
        if (name == null || name.isEmpty()) {
            result = this.getXAttrs(project, user, inodePath);
        } else {
            String metadata = this.getXAttr(project, user, inodePath, name);
            if (metadata != null) {
                result.put(name, metadata);
            }
        }
        return result;
    }

    public boolean removeXAttr(Project project, Users user, String inodePath, String name) throws MetadataException, DatasetException {
        boolean found;
        if (name == null || name.isEmpty()) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MISSING_FIELD, Level.FINE);
        }
        boolean bl = found = this.getXAttr(project, user, inodePath, name) != null;
        if (found) {
            this.removeXAttrInt(project, user, inodePath, name);
        }
        return found;
    }

    private void addXAttrInt(Project project, Users user, String inodePath, String name, String metadataJson) throws DatasetException, MetadataException {
        String path = this.validatePath(inodePath);
        DistributedFileSystemOps udfso = this.getDFS(project, user);
        try {
            udfso.setXAttr(new Path(path), this.getXAttrName(name), metadataJson.getBytes(Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    private void removeXAttrInt(Project project, Users user, String inodePath, String name) throws MetadataException, DatasetException {
        String path = this.validatePath(inodePath);
        DistributedFileSystemOps udfso = this.getDFS(project, user);
        try {
            udfso.removeXAttr(new Path(path), this.getXAttrName(name));
        }
        catch (IOException e) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    private String getXAttr(Project project, Users user, String inodePath, String name) throws DatasetException, MetadataException {
        String path = this.validatePath(inodePath);
        DistributedFileSystemOps udfso = this.getDFS(project, user);
        try {
            byte[] value = udfso.getXAttr(new Path(path), this.getXAttrName(name));
            if (value != null) {
                String string = new String(value, Charsets.UTF_8);
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            if (e.getMessage().contains("At least one of the attributes provided was not found.")) {
                String string = null;
                return string;
            }
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    private Map<String, String> getXAttrs(Project project, Users user, String inodePath) throws DatasetException, MetadataException {
        String path = this.validatePath(inodePath);
        DistributedFileSystemOps udfso = this.getDFS(project, user);
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            Map<String, byte[]> attrs = udfso.getXAttrs(new Path(path));
            for (Map.Entry<String, byte[]> e : attrs.entrySet()) {
                if (e.getValue() == null || !e.getKey().startsWith(XATTR_USER_NAMESPACE)) continue;
                result.put(e.getKey().split(XATTR_USER_NAMESPACE)[1], new String(e.getValue(), Charsets.UTF_8));
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    private String validatePath(String path) throws MetadataException, DatasetException {
        String inodePath = path;
        try {
            inodePath = Utils.prepPath(path);
        }
        catch (UnsupportedEncodingException e) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
        if (!this.inodeController.existsPath(inodePath)) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_NOT_FOUND, Level.FINE, "file " + inodePath + "doesn't exist");
        }
        return inodePath;
    }

    private DistributedFileSystemOps getDFS(Project project, Users user) {
        String hdfsUserName = this.hdfsUsersController.getHdfsUserName(project, user);
        return this.dfs.getDfsOps(hdfsUserName);
    }

    private String getXAttrName(String name) {
        return XATTR_USER_NAMESPACE + name;
    }
}

