/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.experiments.tensorboard;

import com.google.common.io.Files;
import io.hops.hopsworks.common.dao.tensorflow.TensorBoardFacade;
import io.hops.hopsworks.common.dao.tensorflow.config.TensorBoardProcessMgr;
import io.hops.hopsworks.common.experiments.tensorboard.TensorBoardController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.TensorBoardException;
import io.hops.hopsworks.persistence.entity.tensorflow.TensorBoard;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timer;

@Singleton
@Startup
@DependsOn(value={"Settings"})
public class TensorBoardKillTimer {
    private static final Logger LOGGER = Logger.getLogger(TensorBoardKillTimer.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private TensorBoardFacade tensorBoardFacade;
    @EJB
    private TensorBoardProcessMgr tensorBoardProcessMgr;
    @EJB
    private TensorBoardController tensorBoardController;

    @Schedule(persistent=false, minute="*/10", hour="*")
    public void rotate(Timer timer) {
        try {
            LOGGER.log(Level.INFO, "Running TensorBoardKillTimer.");
            int tensorBoardMaxLastAccessed = this.settings.getTensorBoardMaxLastAccessed();
            List<TensorBoard> tensorBoardCollection = this.tensorBoardFacade.findAll();
            for (TensorBoard tensorBoard : tensorBoardCollection) {
                Date accessed = tensorBoard.getLastAccessed();
                Date current = Calendar.getInstance().getTime();
                if (current.getTime() - accessed.getTime() <= (long)tensorBoardMaxLastAccessed) continue;
                try {
                    this.tensorBoardController.cleanup(tensorBoard);
                    LOGGER.log(Level.FINE, "Killed TensorBoard " + tensorBoard.toString() + " not accessed in the last " + tensorBoardMaxLastAccessed + " milliseconds");
                }
                catch (TensorBoardException ex) {
                    LOGGER.log(Level.SEVERE, "Failed to clean up running TensorBoard", ex);
                }
            }
            try {
                List<TensorBoard> TBs = this.tensorBoardFacade.findAll();
                String tbDirPath = this.settings.getStagingDir() + "/tensorboard/";
                File tbDir = new File(tbDirPath);
                for (File currentTbDir : tbDir.listFiles()) {
                    for (File possiblePidFile : currentTbDir.listFiles()) {
                        String pidContents;
                        BigInteger pid;
                        if (!possiblePidFile.getName().endsWith(".pid") || (pid = BigInteger.valueOf(Long.parseLong(pidContents = Files.readFirstLine((File)possiblePidFile, (Charset)Charset.defaultCharset())))) == null) continue;
                        boolean tbExists = false;
                        for (TensorBoard tb : TBs) {
                            if (!tb.getPid().equals(pid)) continue;
                            tbExists = true;
                        }
                        if (tbExists) continue;
                        LOGGER.log(Level.WARNING, "Detected a stray TensorBoard with pid " + pid.toString() + " in directory " + currentTbDir.getAbsolutePath() + ", cleaning up...");
                        this.tensorBoardProcessMgr.killTensorBoard(pid);
                        this.tensorBoardProcessMgr.removeTensorBoardDirectory(currentTbDir.getAbsolutePath());
                    }
                }
            }
            catch (IOException | NumberFormatException e) {
                LOGGER.log(Level.SEVERE, "Exception while reading .pid files", e);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "An error occurred while checking for expired TensorBoards to be cleaned up", e);
        }
    }
}

