/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import io.hops.hopsworks.common.dao.jupyter.config.JupyterDTO;
import io.hops.hopsworks.common.jupyter.JupyterManager;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterProject;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterSettings;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

public abstract class JupyterManagerImpl
implements JupyterManager {
    @EJB
    private Settings settings;
    @EJB
    private OSProcessExecutor osProcessExecutor;

    @Override
    public abstract JupyterDTO startJupyterServer(Project var1, String var2, String var3, Users var4, JupyterSettings var5, String var6) throws ServiceException;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String getJupyterHome(String hdfsUser, Project project, String secret) throws ServiceException {
        if (project == null || secret == null) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_HOME_ERROR, Level.WARNING, "user: " + hdfsUser);
        }
        return this.settings.getJupyterDir() + File.separator + "Projects" + File.separator + project.getName() + File.separator + hdfsUser + File.separator + secret;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void projectCleanup(Logger logger, Project project) {
        int exitValue;
        String prog = this.settings.getSudoersDir() + "/jupyter-project-cleanup.sh";
        ProcessDescriptor.Builder pdBuilder = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand(project.getName());
        if (!logger.isLoggable(Level.FINE)) {
            pdBuilder.ignoreOutErrStreams(true);
        }
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(pdBuilder.build());
            logger.log(Level.FINE, processResult.getStdout());
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Problem cleaning up project: " + project.getName() + ": {0}", ex.toString());
            exitValue = -2;
        }
        if (exitValue != 0) {
            logger.log(Level.WARNING, "Problem remove project's jupyter folder: " + project.getName());
        }
    }

    @Override
    public abstract void waitForStartup(Project var1, Users var2) throws TimeoutException;

    @Override
    public abstract void stopOrphanedJupyterServer(Long var1, Integer var2) throws ServiceException;

    @Override
    public abstract void stopJupyterServer(Project var1, Users var2, String var3, String var4, Long var5, Integer var6) throws ServiceException;

    @Override
    public abstract void projectCleanup(Project var1);

    @Override
    public abstract boolean ping(JupyterProject var1);

    @Override
    public abstract List<JupyterProject> getAllNotebooks();
}

