/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.app.dto;

import io.hops.hopsworks.common.provenance.app.ProvAParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.elastic.BasicElasticHit;
import io.hops.hopsworks.common.provenance.util.ProvHelper;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ProvAppStateElastic
implements Comparator<ProvAppStateElastic> {
    private static final Logger LOGGER = Logger.getLogger(ProvAppStateElastic.class.getName());
    private String id;
    private float score;
    private Map<String, Object> map;
    private String appId;
    private Provenance.AppState appState = null;
    private long appStateTimestamp;
    private String readableTimestamp;
    private String appName;
    private String appUser;

    public static ProvAppStateElastic instance(BasicElasticHit hit) throws ProvenanceException {
        ProvAppStateElastic result = new ProvAppStateElastic();
        result.id = hit.getId();
        result.score = hit.getScore().floatValue();
        result.map = hit.getSource();
        HashMap<String, Object> map = new HashMap<String, Object>(result.map);
        try {
            result.appId = (String)ProvHelper.extractElasticField(map, ProvAParser.Field.APP_ID);
            result.appState = (Provenance.AppState)((Object)ProvHelper.extractElasticField(map, ProvAParser.Field.APP_STATE));
            result.appStateTimestamp = (Long)ProvHelper.extractElasticField(map, ProvAParser.Field.TIMESTAMP);
            result.appName = (String)ProvHelper.extractElasticField(map, ProvAParser.Field.APP_NAME);
            result.appUser = (String)ProvHelper.extractElasticField(map, ProvAParser.Field.APP_USER);
            result.readableTimestamp = (String)ProvHelper.extractElasticField(map, ProvAParser.Field.R_TIMESTAMP);
            if (!map.isEmpty()) {
                LOGGER.log(Level.FINE, "fields:{0} not managed in file state return", map.keySet());
            }
        }
        catch (ClassCastException e) {
            String msg = "mismatch between DTO class and ProvAParser field types (elastic)";
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, msg, msg, (Throwable)e);
        }
        return result;
    }

    @Override
    public int compare(ProvAppStateElastic o1, ProvAppStateElastic o2) {
        return Float.compare(o2.getScore(), o1.getScore());
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setMap(Map<String, Object> source) {
        this.map = new HashMap<String, Object>(source);
    }

    public Map<String, String> getMap() {
        HashMap<String, String> refined = new HashMap<String, String>();
        if (this.map != null) {
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                String value = entry.getValue() == null ? "null" : entry.getValue().toString();
                refined.put(entry.getKey(), value);
            }
        }
        return refined;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Provenance.AppState getAppState() {
        return this.appState;
    }

    public void setAppState(Provenance.AppState appState) {
        this.appState = appState;
    }

    public Long getAppStateTimestamp() {
        return this.appStateTimestamp;
    }

    public void setAppStateTimestamp(long appStateTimestamp) {
        this.appStateTimestamp = appStateTimestamp;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppUser() {
        return this.appUser;
    }

    public void setAppUser(String appUser) {
        this.appUser = appUser;
    }

    public String getReadableTimestamp() {
        return this.readableTimestamp;
    }

    public void setReadableTimestamp(String readableTimestamp) {
        this.readableTimestamp = readableTimestamp;
    }
}

