/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.api;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.AbstractFacade;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ResourceRequest {
    private Name name;
    private Integer offset;
    private Integer limit;
    private Set<? extends AbstractFacade.SortBy> sort;
    private Set<? extends AbstractFacade.FilterBy> filter;
    private Set<ResourceRequest> expansions;
    protected List<String> queryProps;

    public ResourceRequest(Name name) {
        this(name, null);
    }

    public ResourceRequest(Name name, String queryParam) {
        this.name = name;
        this.queryProps = new ArrayList<String>();
        if (!Strings.isNullOrEmpty((String)queryParam) && queryParam.contains("(")) {
            String[] queryPropsArr;
            block8: for (String queryProp : queryPropsArr = queryParam.substring(queryParam.indexOf(40) + 1, queryParam.lastIndexOf(41)).split(";")) {
                String queryName = queryProp.substring(0, queryProp.indexOf(61));
                String queryVal = queryProp.substring(queryProp.indexOf(61) + 1);
                switch (queryName) {
                    case "offset": {
                        this.offset = Integer.parseInt(queryVal);
                        continue block8;
                    }
                    case "limit": {
                        this.limit = Integer.parseInt(queryVal);
                        continue block8;
                    }
                    default: {
                        this.queryProps.add(queryProp);
                    }
                }
            }
        }
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Set<? extends AbstractFacade.SortBy> getSort() {
        return this.sort;
    }

    public void setSort(Set<? extends AbstractFacade.SortBy> sort) {
        this.sort = sort;
    }

    public Set<? extends AbstractFacade.FilterBy> getFilter() {
        return this.filter;
    }

    public void setFilter(Set<? extends AbstractFacade.FilterBy> filter) {
        this.filter = filter;
    }

    public Set<ResourceRequest> getExpansions() {
        return this.expansions;
    }

    public void setExpansions(Set<ResourceRequest> expansions) {
        this.expansions = expansions;
    }

    public boolean contains(Name name) {
        if (this.name == name) {
            return true;
        }
        if (this.expansions != null && !this.expansions.isEmpty()) {
            for (ResourceRequest expansion : this.expansions) {
                if (expansion.name != name) continue;
                return true;
            }
        }
        return false;
    }

    public ResourceRequest get(Name name) {
        if (this.expansions != null && !this.expansions.isEmpty()) {
            for (ResourceRequest expansion : this.expansions) {
                if (expansion.name != name) continue;
                return expansion;
            }
        }
        return null;
    }

    public static enum Name {
        USERS,
        USER,
        CREATOR,
        PROJECT,
        JOBS,
        KAFKA,
        TOPICS,
        ACL,
        SHARED,
        EXECUTIONS,
        DATASETS,
        REQUESTS,
        INODES,
        MESSAGES,
        ACTIVITIES,
        PYTHON,
        ENVIRONMENTS,
        COMMANDS,
        MACHINETYPES,
        LIBRARIES,
        DATASETREQUESTS,
        APIKEY,
        TEMPLATE,
        XATTRS,
        FEATURESTORES,
        FEATUREGROUPS,
        EXPERIMENTS,
        TENSORBOARD,
        RESULTS,
        MODELS,
        HOSTS,
        QUERY,
        TAGS,
        SERVICES,
        TRAININGDATASETS;


        public static Name fromString(String name) {
            return Name.valueOf(name.toUpperCase());
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

