/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka;

import io.hops.hopsworks.common.kafka.KafkaBrokers;
import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;

@Singleton
@DependsOn(value={"KafkaBrokers"})
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class HopsKafkaAdminClient {
    private static final Logger LOG = Logger.getLogger(HopsKafkaAdminClient.class.getName());
    @EJB
    private BaseHadoopClientsService baseHadoopService;
    @EJB
    private KafkaBrokers kafkaBrokers;
    private AdminClient adminClient;

    @PostConstruct
    private void init() {
        try {
            this.initClient();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Kafka is currently unavailable. Will periodically retry to connect");
        }
    }

    @Lock(value=LockType.WRITE)
    @AccessTimeout(value=5000L)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    private AdminClient getAdminClient() {
        try {
            if (this.adminClient == null) {
                this.initClient();
            } else {
                Collection nodes = (Collection)this.adminClient.describeCluster().nodes().get(5000L, TimeUnit.MILLISECONDS);
                LOG.log(Level.FINE, "Connection to Kafka cluster is online: " + nodes);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.initClient();
        }
        return this.adminClient;
    }

    private void initClient() {
        if (this.adminClient != null) {
            try {
                this.adminClient.close(Duration.ofSeconds(3L));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not close adminClient, will continue with initialization", e);
            }
        }
        Properties props = new Properties();
        Set<String> brokers = this.kafkaBrokers.getKafkaBrokers();
        brokers.removeIf(seed -> seed.split(":")[0].equalsIgnoreCase("EXTERNAL"));
        String brokerAddress = brokers.iterator().next().split("://")[1];
        props.setProperty("bootstrap.servers", brokerAddress);
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.truststore.location", this.baseHadoopService.getSuperTrustStorePath());
        props.setProperty("ssl.truststore.password", this.baseHadoopService.getSuperTrustStorePassword());
        props.setProperty("ssl.keystore.location", this.baseHadoopService.getSuperKeystorePath());
        props.setProperty("ssl.keystore.password", this.baseHadoopService.getSuperKeystorePassword());
        props.setProperty("ssl.key.password", this.baseHadoopService.getSuperKeystorePassword());
        props.setProperty("ssl.endpoint.identification.algorithm", "");
        this.adminClient = AdminClient.create((Properties)props);
    }

    public ListTopicsResult listTopics() {
        return this.getAdminClient().listTopics();
    }

    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics) {
        return this.getAdminClient().createTopics(newTopics);
    }

    public DeleteTopicsResult deleteTopics(Collection<String> topics) {
        return this.getAdminClient().deleteTopics(topics);
    }

    public DescribeTopicsResult describeTopics(Collection<String> topics) {
        return this.getAdminClient().describeTopics(topics);
    }

    @Schedule(persistent=false, minute="*/1", hour="*")
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void checkAliveTimer() {
        try {
            this.getAdminClient();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Kafka cluster is unavailable", e);
        }
    }
}

