/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.online;

import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeaturegroupPreview;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.online.OnlineFeaturegroup;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.sql.SQLException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class OnlineFeaturegroupController {
    @EJB
    private OnlineFeaturegroupFacade onlineFeaturegroupFacade;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;

    private OnlineFeaturegroup persistOnlineFeaturegroupMetadata(String dbName, String tableName) {
        OnlineFeaturegroup onlineFeaturegroup = new OnlineFeaturegroup();
        onlineFeaturegroup.setDbName(dbName);
        onlineFeaturegroup.setTableName(tableName);
        this.onlineFeaturegroupFacade.persist(onlineFeaturegroup);
        return onlineFeaturegroup;
    }

    public void dropMySQLTable(OnlineFeaturegroup onlineFeaturegroup, Featurestore featurestore, Users user) throws SQLException, FeaturestoreException {
        String query = "DROP TABLE " + onlineFeaturegroup.getTableName() + ";";
        this.onlineFeaturestoreController.executeUpdateJDBCQuery(query, onlineFeaturegroup.getDbName(), featurestore.getProject(), user);
        this.removeOnlineFeaturegroupMetadata(onlineFeaturegroup);
    }

    public OnlineFeaturegroup removeOnlineFeaturegroupMetadata(OnlineFeaturegroup onlineFeaturegroup) {
        this.onlineFeaturegroupFacade.remove(onlineFeaturegroup);
        return onlineFeaturegroup;
    }

    public OnlineFeaturegroup createMySQLTable(Featurestore featurestore, Users user, String featureStr, String tableName) throws FeaturestoreException, SQLException {
        String db = this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featurestore.getProject());
        String query = "CREATE TABLE " + db + ".`" + tableName + "` " + featureStr;
        this.onlineFeaturestoreController.executeUpdateJDBCQuery(query, db, featurestore.getProject(), user);
        return this.persistOnlineFeaturegroupMetadata(db, tableName);
    }

    public OnlineFeaturegroupDTO convertOnlineFeaturegroupToDTO(OnlineFeaturegroup onlineFeaturegroup) {
        OnlineFeaturegroupDTO onlineFeaturegroupDTO = new OnlineFeaturegroupDTO(onlineFeaturegroup);
        onlineFeaturegroupDTO.setTableType(this.onlineFeaturestoreController.getOnlineFeaturegroupTableType(onlineFeaturegroupDTO));
        onlineFeaturegroupDTO.setSize(this.onlineFeaturestoreController.getTblSize(onlineFeaturegroupDTO));
        onlineFeaturegroupDTO.setTableRows(this.onlineFeaturestoreController.getOnlineFeaturegroupTableRows(onlineFeaturegroupDTO));
        return onlineFeaturegroupDTO;
    }

    public List<FeatureDTO> getOnlineFeaturegroupFeatures(OnlineFeaturegroup onlineFeaturegroup) {
        return this.onlineFeaturestoreController.getOnlineFeaturegroupFeatures(onlineFeaturegroup);
    }

    public FeaturegroupPreview getOnlineFeaturegroupPreview(Featuregroup featuregroup, Project project, Users user, int limit) throws FeaturestoreException, SQLException {
        String tblName = featuregroup.getName() + "_" + featuregroup.getVersion();
        String query = "SELECT * FROM " + tblName + " LIMIT " + limit;
        String db = this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject());
        try {
            return this.onlineFeaturestoreController.executeReadJDBCQuery(query, db, project, user);
        }
        catch (Exception e) {
            return this.onlineFeaturestoreController.executeReadJDBCQuery(query, db, project, user);
        }
    }
}

