/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.utils;

import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.featurestore.FeaturestoreEntityDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;

@Stateless
public class FeaturestoreUtils {
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private DistributedFsService distributedFsService;
    @EJB
    private ProjectTeamFacade projectTeamFacade;

    public void verifyUserRole(FeaturestoreEntityDTO featurestoreEntityDTO, Featurestore featurestore, Users user, Project project) throws FeaturestoreException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        if (!featurestoreEntityDTO.getCreator().equals(user.getEmail()) && !userRole.equalsIgnoreCase("Data owner")) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.UNAUTHORIZED_FEATURESTORE_OPERATION, Level.FINE, "project: " + project.getName() + ", featurestoreId: " + featurestore.getId() + ", featuregroupId: " + featurestoreEntityDTO.getId() + ", userRole:" + userRole + ", creator of the featuregroup: " + featurestoreEntityDTO.getCreator());
        }
    }

    public void verifyUserRole(TrainingDataset trainingDataset, Featurestore featurestore, Users user, Project project) throws FeaturestoreException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        if (!trainingDataset.getCreator().equals((Object)user) && !userRole.equalsIgnoreCase("Data owner")) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.UNAUTHORIZED_FEATURESTORE_OPERATION, Level.FINE, "project: " + project.getName() + ", featurestoreId: " + featurestore.getId() + ", Training dataset: " + trainingDataset.getName() + ", userRole:" + userRole + ", creator of the featuregroup: " + trainingDataset.getCreator().getEmail());
        }
    }

    public void verifyUserRole(Featurestore featurestore, Users user, Project project, FeaturestoreStorageConnectorDTO storageConnectorDTO) throws FeaturestoreException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        if (!userRole.equalsIgnoreCase("Data owner")) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.UNAUTHORIZED_FEATURESTORE_OPERATION, Level.FINE, "project: " + project.getName() + ", featurestoreId: " + featurestore.getId() + ", storageConnectorId: " + storageConnectorDTO.getId() + ", userRole:" + userRole);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToHDFS(Project project, Users user, Path filePath, String content) throws IOException {
        DistributedFileSystemOps udfso = null;
        try {
            String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
            udfso = this.distributedFsService.getDfsOps(hdfsUsername);
            try (FSDataOutputStream outStream = udfso.create(filePath);){
                outStream.writeBytes(content);
                outStream.hflush();
            }
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
        }
        catch (Throwable throwable) {
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
            throw throwable;
        }
    }
}

