/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.flink;

import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.jobs.AsynchronousJobExecutor;
import io.hops.hopsworks.common.jobs.flink.FlinkYarnRunnerBuilder;
import io.hops.hopsworks.common.jobs.yarn.YarnJob;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.flink.FlinkJobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FlinkJob
extends YarnJob {
    private static final Logger LOG = Logger.getLogger(FlinkJob.class.getName());
    private FlinkYarnRunnerBuilder flinkBuilder;

    FlinkJob(Jobs job, AsynchronousJobExecutor services, Users user, String jobUser, Settings settings) {
        super(job, services, user, jobUser, settings.getHadoopSymbolicLinkDir(), settings);
        if (!(job.getJobConfig() instanceof FlinkJobConfiguration)) {
            throw new IllegalArgumentException("Job must contain a FlinkJobConfiguration object. Received: " + job.getJobConfig().getClass());
        }
    }

    @Override
    protected boolean setupJob() throws JobException {
        if (this.flinkBuilder == null) {
            this.flinkBuilder = new FlinkYarnRunnerBuilder(this.jobs);
        }
        if (this.jobSystemProperties != null && !this.jobSystemProperties.isEmpty()) {
            for (Map.Entry jobSystemProperty : this.jobSystemProperties.entrySet()) {
                this.flinkBuilder.addDynamicProperty((String)jobSystemProperty.getKey(), (String)jobSystemProperty.getValue());
            }
        }
        try {
            this.runner = this.flinkBuilder.getYarnRunner(this.jobs.getProject(), this.jobUser, this.services.getFileOperations(this.hdfsUser.getUserName()), this.yarnClient, this.services, this.settings, this.kafkaBrokersString);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to create YarnRunner.", e);
            try {
                this.writeToLogs("Failed to start Yarn client.");
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "Failed to write logs for failed application.", e);
            }
            return false;
        }
        String stdFinalDestination = Utils.getProjectPath(this.jobs.getProject().getName()) + Settings.BaseDataset.LOGS.getName() + "/" + JobType.FLINK.getName();
        this.setStdOutFinalDestination(stdFinalDestination);
        this.setStdErrFinalDestination(stdFinalDestination);
        return true;
    }

    @Override
    protected void cleanup() {
    }
}

