/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.hops.hopsworks.common.util.RemoteCommand;
import io.hops.hopsworks.common.util.RemoteCommandResult;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class RemoteCommandExecutor {
    private static final Logger LOGGER = Logger.getLogger(RemoteCommandExecutor.class.getName());

    public RemoteCommandResult execute(RemoteCommand command) throws ServiceException {
        return this.executeInternal(command);
    }

    @Asynchronous
    public Future<RemoteCommandResult> submit(RemoteCommand command) throws ServiceException {
        RemoteCommandResult asyncResult = this.executeInternal(command);
        return new AsyncResult((Object)asyncResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteCommandResult executeInternal(RemoteCommand command) throws ServiceException {
        Channel channel = null;
        Session session = null;
        try {
            LOGGER.log(Level.FINE, "Executing remote command: " + command);
            JSch jsch = new JSch();
            jsch.addIdentity(command.getIdentity().toString());
            session = jsch.getSession(command.getUser(), command.getHost(), command.getPort());
            session.setConfig(command.getSSHConfig());
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect(command.getConnectTimeout());
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command.getCommand());
            String stdout = this.waitForCommandToFinish(channel, command);
            int exitCode = channel.getExitStatus();
            RemoteCommandResult remoteCommandResult = new RemoteCommandResult(stdout, exitCode);
            return remoteCommandResult;
        }
        catch (JSchException | IOException ex) {
            LOGGER.log(Level.WARNING, "Error executing remote command " + command, ex);
            throw new ServiceException(RESTCodes.ServiceErrorCode.ERROR_EXECUTING_REMOTE_COMMAND, Level.WARNING, "Error while executing remote command", "Error executing remote command: " + command, ex);
        }
        catch (RemoteCommandTimeoutException ex) {
            RemoteCommandResult remoteCommandResult = new RemoteCommandResult("Command time-out: " + ex.getMessage(), 20);
            return remoteCommandResult;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String waitForCommandToFinish(Channel channel, RemoteCommand command) throws JSchException, IOException, RemoteCommandTimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class RemoteCommandTimeoutException
    extends Exception {
        private RemoteCommandTimeoutException(String reason) {
            super(reason);
        }

        private RemoteCommandTimeoutException(String reason, Throwable throwable) {
            super(reason, throwable);
        }
    }
}

