/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public abstract class AbstractReadOnlyFacade<T> {
    private final Class<T> entityClass;

    public AbstractReadOnlyFacade(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    protected abstract EntityManager getEntityManager();

    public T find(Object id) {
        return (T)this.getEntityManager().find(this.entityClass, id);
    }

    public List<T> findAll() {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(this.entityClass));
        return this.getEntityManager().createQuery(cq).getResultList();
    }

    public List<T> findRange(int[] range) {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(this.entityClass));
        TypedQuery q = this.getEntityManager().createQuery(cq);
        q.setMaxResults(range[1] - range[0]);
        q.setFirstResult(range[0]);
        return q.getResultList();
    }

    public int count() {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        Root rt = cq.from(this.entityClass);
        cq.select((Selection)this.getEntityManager().getCriteriaBuilder().count((Expression)rt));
        TypedQuery q = this.getEntityManager().createQuery(cq);
        return ((Long)q.getSingleResult()).intValue();
    }
}

