/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka;

import io.hops.hopsworks.common.kafka.KafkaBrokers;
import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;

@Singleton
@DependsOn(value={"KafkaBrokers"})
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class HopsKafkaAdminClient {
    @EJB
    private BaseHadoopClientsService baseHadoopService;
    @EJB
    private KafkaBrokers kafkaBrokers;
    private AdminClient adminClient;

    @PostConstruct
    private void init() {
        this.adminClient = this.getAdminClient();
    }

    private AdminClient getAdminClient() {
        Properties props = new Properties();
        Set<String> brokers = this.kafkaBrokers.getKafkaBrokers();
        brokers.removeIf(seed -> seed.split(":")[0].equalsIgnoreCase("EXTERNAL"));
        String brokerAddress = brokers.iterator().next().split("://")[1];
        props.setProperty("bootstrap.servers", brokerAddress);
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.truststore.location", this.baseHadoopService.getSuperTrustStorePath());
        props.setProperty("ssl.truststore.password", this.baseHadoopService.getSuperTrustStorePassword());
        props.setProperty("ssl.keystore.location", this.baseHadoopService.getSuperKeystorePath());
        props.setProperty("ssl.keystore.password", this.baseHadoopService.getSuperKeystorePassword());
        props.setProperty("ssl.key.password", this.baseHadoopService.getSuperKeystorePassword());
        props.setProperty("ssl.endpoint.identification.algorithm", "");
        return AdminClient.create((Properties)props);
    }

    public ListTopicsResult listTopics() {
        return this.adminClient.listTopics();
    }

    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics) {
        return this.adminClient.createTopics(newTopics);
    }

    public DeleteTopicsResult deleteTopics(Collection<String> topics) {
        return this.adminClient.deleteTopics(topics);
    }

    public DescribeTopicsResult describeTopics(Collection<String> topics) {
        return this.adminClient.describeTopics(topics);
    }
}

