/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.library;

import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.library.LibraryVersionDTO;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class LibraryController {
    private static final Logger LOGGER = Logger.getLogger(LibraryController.class.getName());
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private Settings settings;
    @EJB
    private LibraryFacade libraryFacade;
    @EJB
    private OSProcessExecutor osProcessExecutor;

    public PythonDep getPythonDep(String dependency, Project project) {
        return this.libraryFacade.findByDependencyAndProject(dependency, project);
    }

    public void uninstallLibrary(Project project, Users user, String libName) throws GenericException {
        for (PythonDep dep : project.getPythonDepCollection()) {
            if (!dep.getDependency().equals(libName)) continue;
            this.uninstallLibrary(project, user, dep.getInstallType(), dep.getRepoUrl().getUrl(), libName, dep.getVersion());
            break;
        }
    }

    public void addPythonDepsForProject(Project proj, Collection<PythonDep> pythonDeps) {
        ArrayList<PythonDep> depsInProj = new ArrayList<PythonDep>(proj.getPythonDepCollection());
        for (PythonDep dep : pythonDeps) {
            depsInProj.remove(dep);
            depsInProj.add(dep);
        }
        proj.setPythonDepCollection(depsInProj);
        this.projectFacade.update(proj);
    }

    public PythonDep addLibrary(Project proj, Users user, CondaInstallType installType, String channelUrl, String dependency, String version) throws GenericException {
        return this.commandsController.condaOp(CondaOp.INSTALL, user, installType, proj, channelUrl, dependency, version);
    }

    public void uninstallLibrary(Project proj, Users user, CondaInstallType installType, String channelUrl, String dependency, String version) throws GenericException {
        this.commandsController.condaOp(CondaOp.UNINSTALL, user, installType, proj, channelUrl, dependency, version);
    }

    public HashMap<String, List<LibraryVersionDTO>> condaSearch(String library, String url) throws ServiceException {
        HashMap<String, List<LibraryVersionDTO>> libVersions = new HashMap<String, List<LibraryVersionDTO>>();
        String prog = this.settings.getHopsworksDomainDir() + "/bin/condasearch.sh";
        String[] lines = this.search(prog, library, url);
        String foundLib = "";
        for (String line : lines) {
            String[] libVersion = line.split(",");
            if (libVersion.length != 2) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_FORMAT_ERROR, Level.WARNING);
            }
            String key = libVersion[0];
            String value = libVersion[1];
            if (key.isEmpty() || key.equalsIgnoreCase("Loading") && value.equalsIgnoreCase("channels:") || key.equalsIgnoreCase("#") && value.equalsIgnoreCase("Name") || key.equalsIgnoreCase("no") && value.equalsIgnoreCase("match")) continue;
            foundLib = key;
            String foundVersion = value;
            if (!libVersions.containsKey(foundLib)) {
                LinkedList<LibraryVersionDTO> versions = new LinkedList<LibraryVersionDTO>();
                versions.add(new LibraryVersionDTO(foundVersion));
                libVersions.put(foundLib, versions);
                continue;
            }
            LibraryVersionDTO libraryVersionDTO = new LibraryVersionDTO(foundVersion);
            if (libVersions.get(foundLib).contains(libraryVersionDTO)) continue;
            libVersions.get(foundLib).add(0, libraryVersionDTO);
        }
        if (libVersions.isEmpty()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_NOT_FOUND, Level.FINE);
        }
        return libVersions;
    }

    private void findPipLibPyPi(String libName, HashMap<String, List<LibraryVersionDTO>> versions) {
        Response resp = null;
        try {
            resp = ClientBuilder.newClient().target(this.settings.getPyPiRESTEndpoint().replaceFirst("\\{package}", libName)).request().header("Content-Type", (Object)"application/json").get();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "PyPi REST endpoint connection failed" + this.settings.getPyPiRESTEndpoint().replaceFirst("\\{package}", libName), e);
            return;
        }
        if (resp.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            return;
        }
        JSONObject jsonObject = new JSONObject((String)resp.readEntity(String.class));
        if (jsonObject.has("releases")) {
            JSONObject releases = jsonObject.getJSONObject("releases");
            versions.put(libName, this.getVersions(releases));
        }
    }

    private List<LibraryVersionDTO> getVersions(JSONObject releases) {
        ArrayList<LibraryVersionDTO> versions = new ArrayList<LibraryVersionDTO>();
        Iterator keys = releases.keys();
        Date releaseDate = new Date(0L);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (releases.get(key) instanceof JSONArray) {
                JSONObject versionMeta;
                JSONObject jSONObject = versionMeta = ((JSONArray)releases.get(key)).length() > 0 ? (JSONObject)((JSONArray)releases.get(key)).get(0) : null;
                if (versionMeta != null && versionMeta.has("upload_time")) {
                    String strDate = versionMeta.getString("upload_time");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    try {
                        releaseDate = sdf.parse(strDate);
                    }
                    catch (ParseException e) {
                        LOGGER.log(Level.FINE, "Failed to parse release date: {0}", strDate);
                    }
                }
            }
            versions.add(new LibraryVersionDTO(key, releaseDate));
        }
        return versions;
    }

    public HashMap<String, List<LibraryVersionDTO>> pipSearch(String library) throws ServiceException {
        HashMap<String, List<LibraryVersionDTO>> versions = new HashMap<String, List<LibraryVersionDTO>>();
        String prog = this.settings.getHopsworksDomainDir() + "/bin/pipsearch.sh";
        String[] lines = this.search(prog, library, null);
        library = library.toLowerCase();
        for (String line : lines) {
            ArrayList<LibraryVersionDTO> versionList;
            String libName;
            String[] lineSplit = line.split(" +");
            if (line.length() == 0 || lineSplit.length < 2 || !(libName = lineSplit[0]).toLowerCase().startsWith(library)) continue;
            this.findPipLibPyPi(libName, versions);
            if (versions.containsKey(libName) && !versions.get(libName).isEmpty()) continue;
            String version = lineSplit[1];
            if (version.equals("()")) {
                versionList = new ArrayList<LibraryVersionDTO>();
                versionList.add(new LibraryVersionDTO(""));
                versions.put(libName, versionList);
                continue;
            }
            version = version.replaceAll("[()]", "").trim();
            versionList = new ArrayList();
            versionList.add(new LibraryVersionDTO(version));
            versions.put(libName, versionList);
        }
        if (versions.isEmpty()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_NOT_FOUND, Level.FINE);
        }
        return versions;
    }

    private String[] search(String program, String library, String url) throws ServiceException {
        ProcessResult processResult;
        ProcessDescriptor.Builder pdBuilder = new ProcessDescriptor.Builder();
        pdBuilder.addCommand(program);
        if (url != null && !url.isEmpty()) {
            pdBuilder.addCommand(url);
            pdBuilder.addCommand(library);
        } else if (library != null && !library.isEmpty()) {
            pdBuilder.addCommand(library);
        }
        ProcessDescriptor processDescriptor = pdBuilder.redirectErrorStream(true).setWaitTimeout(5L, TimeUnit.MINUTES).build();
        try {
            processResult = this.osProcessExecutor.execute(processDescriptor);
            boolean exited = processResult.processExited();
            int errCode = processResult.getExitCode();
            if (!exited) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "errCode: " + errCode + ", " + processResult.getStderr());
            }
            if (errCode == 1 || errCode == 23) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_NOT_FOUND, Level.FINE, "errCode: " + errCode + ", " + processResult.getStderr());
            }
            if (errCode != 0) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "errCode: " + errCode + ", " + processResult.getStderr());
            }
        }
        catch (IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "lib: " + library, ex.getMessage(), (Throwable)ex);
        }
        String result = processResult.getStdout();
        return result != null && !result.isEmpty() ? result.split("\n") : new String[]{};
    }
}

