/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.library;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.environment.EnvironmentController;
import io.hops.hopsworks.common.python.library.LibraryController;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.command.SystemCommand;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.AnacondaRepo;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.FileUtils;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class LibraryInstaller {
    private static final Logger LOG = Logger.getLogger(LibraryInstaller.class.getName());
    private static final Comparator ASC_COMPARATOR = new CommandsComparator();
    @Resource
    private TimerService timerService;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private LibraryFacade libraryFacade;
    @EJB
    private Settings settings;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private EnvironmentController environmentController;
    @EJB
    private LibraryController libraryController;

    @PostConstruct
    public void init() {
        this.schedule();
    }

    private void schedule() {
        this.timerService.createSingleActionTimer(1000L, new TimerConfig((Serializable)((Object)"python library installer"), false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void isAlive() {
        try {
            List<CondaCommands> allCondaCommands = this.condaCommandFacade.findByStatus(CondaStatus.NEW);
            allCondaCommands.sort(ASC_COMPARATOR);
            for (CondaCommands cc : allCondaCommands) {
                try {
                    try {
                        switch (cc.getOp()) {
                            case CREATE: {
                                this.createNewImage(cc);
                                break;
                            }
                            case INSTALL: {
                                this.installLibrary(cc);
                                break;
                            }
                            case UNINSTALL: {
                                this.uninstallLibrary(cc);
                                break;
                            }
                            case REMOVE: {
                                this.deleteImage(cc);
                                break;
                            }
                            case EXPORT: {
                                this.exportLibraries(cc);
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("conda command unknown: " + cc.getOp());
                            }
                        }
                    }
                    catch (Throwable ex) {
                        LOG.log(Level.WARNING, "Could not execute command with ID: " + cc.getId(), ex);
                        this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.FAILED, cc.getArg(), cc.getOp(), ex.toString());
                        continue;
                    }
                    this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.SUCCESS, cc.getArg(), cc.getOp());
                }
                catch (ServiceException ex) {
                    LOG.log(Level.WARNING, "Could not update command with ID: " + cc.getId());
                }
            }
        }
        finally {
            this.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewImage(CondaCommands cc) throws IOException, ServiceDiscoveryException {
        File baseDir = new File("/tmp/docker/" + cc.getProjectId().getName());
        baseDir.mkdirs();
        File dockerFile = new File(baseDir, "dockerFile_" + cc.getProjectId().getName());
        BufferedWriter writer = new BufferedWriter(new FileWriter(dockerFile));
        writer.write("FROM " + this.projectUtils.getFullBaseImageName());
        writer.close();
        String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        Project project = cc.getProjectId();
        String initialDockerImage = this.projectUtils.getInitialDockerImageName(project);
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("create").addCommand(dockerFile.getAbsolutePath()).addCommand(this.projectUtils.getRegistryURL() + "/" + initialDockerImage).redirectErrorStream(true).setCurrentWorkingDirectory(baseDir).setWaitTimeout(300L, TimeUnit.SECONDS).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new IOException(errorMsg);
            }
            project.setDockerImage(initialDockerImage);
            this.projectFacade.update(project);
        }
        finally {
            FileUtils.deleteDirectory((File)baseDir);
        }
    }

    private void deleteImage(CondaCommands cc) throws IOException, ServiceDiscoveryException {
        String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("delete").addCommand(this.projectUtils.getFullDockerImageName(cc.getProjectId(), false)).redirectErrorStream(true).setWaitTimeout(300L, TimeUnit.SECONDS).build();
        ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
        if (processResult.getExitCode() != 0) {
            String errorMsg = "Could not delete the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
            throw new IOException(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installLibrary(CondaCommands cc) throws IOException, ServiceException, ServiceDiscoveryException {
        File baseDir = new File("/tmp/docker/" + cc.getProjectId().getName());
        baseDir.mkdirs();
        File home = new File(System.getProperty("user.home"));
        File condarc = new File(home, ".condarc");
        File pip = new File(home, ".pip");
        FileUtils.copyFileToDirectory((File)condarc, (File)baseDir);
        FileUtils.copyDirectoryToDirectory((File)pip, (File)baseDir);
        File dockerFile = new File(baseDir, "dockerFile_" + cc.getProjectId().getName());
        BufferedWriter writer = new BufferedWriter(new FileWriter(dockerFile));
        writer.write("# syntax=docker/dockerfile:experimental");
        writer.newLine();
        writer.write("FROM " + this.projectUtils.getFullDockerImageName(cc.getProjectId(), false));
        writer.newLine();
        writer.write("RUN --mount=type=bind,source=.condarc,target=/root/.condarc --mount=type=bind,source=.pip,target=/root/.pip ");
        switch (cc.getInstallType()) {
            case CONDA: {
                writer.write(this.settings.getAnacondaDir() + "/bin/conda install -y -n " + this.settings.getCurrentCondaEnvironment() + " -c " + cc.getChannelUrl() + " " + cc.getLib() + "=" + cc.getVersion());
                break;
            }
            case PIP: {
                writer.write(this.settings.getAnacondaProjectDir() + "/bin/pip install --upgrade " + cc.getLib() + "==" + cc.getVersion());
                break;
            }
            default: {
                throw new UnsupportedOperationException("install type unknown: " + cc.getInstallType());
            }
        }
        writer.close();
        String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        String nextDockerImageName = this.getNextDockerImageName(cc.getProjectId());
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("create").addCommand(dockerFile.getAbsolutePath()).addCommand(this.projectUtils.getRegistryURL() + "/" + nextDockerImageName).redirectErrorStream(true).setCurrentWorkingDirectory(baseDir).setWaitTimeout(300L, TimeUnit.SECONDS).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new IOException(errorMsg);
            }
            Project project = cc.getProjectId();
            project.setDockerImage(nextDockerImageName);
            this.projectFacade.update(project);
        }
        finally {
            FileUtils.deleteDirectory((File)baseDir);
        }
        Collection<PythonDep> envDeps = this.listLibraries(this.projectUtils.getFullDockerImageName(cc.getProjectId(), false));
        this.libraryController.addPythonDepsForProject(cc.getProjectId(), envDeps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallLibrary(CondaCommands cc) throws IOException, ServiceDiscoveryException {
        File baseDir = new File("/tmp/docker/" + cc.getProjectId().getName());
        baseDir.mkdirs();
        File dockerFile = new File(baseDir, "dockerFile_" + cc.getProjectId().getName());
        BufferedWriter writer = new BufferedWriter(new FileWriter(dockerFile));
        writer.write("FROM " + this.projectUtils.getFullDockerImageName(cc.getProjectId(), false) + "\n");
        switch (cc.getInstallType()) {
            case CONDA: {
                writer.write("RUN " + this.settings.getAnacondaDir() + "/bin/conda remove -y -n " + this.settings.getCurrentCondaEnvironment() + " " + cc.getLib() + "\n");
                break;
            }
            case PIP: {
                writer.write("RUN " + this.settings.getAnacondaProjectDir() + "/bin/pip uninstall -y " + cc.getLib() + "\n");
                break;
            }
            default: {
                throw new UnsupportedOperationException("install type unknown: " + cc.getInstallType());
            }
        }
        writer.close();
        String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        String nextDockerImageName = this.getNextDockerImageName(cc.getProjectId());
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("create").addCommand(dockerFile.getAbsolutePath()).addCommand(this.projectUtils.getRegistryURL() + "/" + nextDockerImageName).redirectErrorStream(true).setCurrentWorkingDirectory(baseDir).setWaitTimeout(300L, TimeUnit.SECONDS).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new IOException(errorMsg);
            }
            Project project = cc.getProjectId();
            project.setDockerImage(nextDockerImageName);
            this.projectFacade.update(project);
        }
        finally {
            FileUtils.deleteDirectory((File)baseDir);
        }
    }

    public Collection<PythonDep> listLibraries(String imageName) throws ServiceException {
        String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("list").addCommand(imageName).redirectErrorStream(true).setWaitTimeout(300L, TimeUnit.SECONDS).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                LOG.log(Level.SEVERE, errorMsg);
                throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_IMAGE_CREATION_ERROR, Level.SEVERE);
            }
            return this.depStringToCollec(processResult.getStdout());
        }
        catch (IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.DOCKER_IMAGE_CREATION_ERROR, Level.SEVERE);
        }
    }

    public void exportLibraries(CondaCommands cc) throws IOException, ServiceException, ServiceDiscoveryException {
        String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("export").addCommand(this.projectUtils.getFullDockerImageName(cc.getProjectId(), false)).redirectErrorStream(true).setWaitTimeout(300L, TimeUnit.SECONDS).build();
        ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
        if (processResult.getExitCode() != 0) {
            String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
            throw new IOException(errorMsg);
        }
        this.environmentController.uploadYmlInProject(cc.getProjectId(), cc.getUserId(), processResult.getStdout(), cc.getArg());
    }

    public Collection<PythonDep> depStringToCollec(String condaListStr) throws ServiceException {
        ArrayList<PythonDep> deps = new ArrayList<PythonDep>();
        String[] lines = condaListStr.split(System.getProperty("line.separator"));
        for (int i = 3; i < lines.length; ++i) {
            String line = lines[i];
            String[] split = line.split(" +");
            String libraryName = split[0];
            String version = split[1];
            String channel = "conda";
            if (split.length > 3) {
                channel = split[3].trim().isEmpty() ? channel : split[3];
            }
            CondaInstallType installType = CondaInstallType.PIP;
            if (!channel.equals("pypi")) {
                installType = CondaInstallType.CONDA;
            }
            AnacondaRepo repo = this.libraryFacade.getRepo(channel, true);
            boolean cannotBeRemoved = channel.equals("default");
            PythonDep pyDep = this.libraryFacade.getOrCreateDep(repo, installType, libraryName, version, false, cannotBeRemoved);
            deps.add(pyDep);
        }
        return deps;
    }

    private String getNextDockerImageName(Project project) {
        String dockerImage = project.getDockerImage();
        int indexOfLastDigit = dockerImage.lastIndexOf(".");
        int currentVersion = Integer.parseInt(dockerImage.substring(indexOfLastDigit + 1, dockerImage.length()));
        int nextVersion = currentVersion + 1;
        return dockerImage.substring(0, indexOfLastDigit) + "." + nextVersion;
    }

    private static class CommandsComparator<T>
    implements Comparator<T> {
        private CommandsComparator() {
        }

        @Override
        public int compare(T t, T t1) {
            if (t instanceof CondaCommands && t1 instanceof CondaCommands) {
                return this.condaCommandCompare((CondaCommands)t, (CondaCommands)t1);
            }
            if (t instanceof SystemCommand && t1 instanceof SystemCommand) {
                return this.systemCommandCompare((SystemCommand)t, (SystemCommand)t1);
            }
            return 0;
        }

        private int condaCommandCompare(CondaCommands t, CondaCommands t1) {
            if (t.getId() > t1.getId()) {
                return 1;
            }
            if (t.getId() < t1.getId()) {
                return -1;
            }
            return 0;
        }

        private int systemCommandCompare(SystemCommand t, SystemCommand t1) {
            return t.getId().compareTo(t1.getId());
        }
    }
}

