/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving.inference;

import com.google.common.base.Strings;
import io.hops.common.Pair;
import io.hops.hopsworks.common.dao.serving.ServingFacade;
import io.hops.hopsworks.common.serving.inference.SkLearnInferenceController;
import io.hops.hopsworks.common.serving.inference.TfInferenceController;
import io.hops.hopsworks.common.serving.inference.logger.InferenceLogger;
import io.hops.hopsworks.exceptions.InferenceException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.serving.Serving;
import io.hops.hopsworks.persistence.entity.serving.ServingType;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class InferenceController {
    private static final Logger logger = Logger.getLogger(InferenceLogger.class.getName());
    @EJB
    private ServingFacade servingFacade;
    @Inject
    private TfInferenceController tfInferenceController;
    @Inject
    private SkLearnInferenceController skLearnInferenceController;
    @Inject
    @Any
    private Instance<InferenceLogger> inferenceLoggers;

    public String infer(Project project, String modelName, Integer modelVersion, String verb, String inferenceRequestJson) throws InferenceException {
        Serving serving = this.servingFacade.findByProjectAndName(project, modelName);
        if (serving == null) {
            throw new InferenceException(RESTCodes.InferenceErrorCode.SERVING_NOT_FOUND, Level.FINE, "name: " + modelName);
        }
        if (Strings.isNullOrEmpty((String)verb)) {
            throw new InferenceException(RESTCodes.InferenceErrorCode.MISSING_VERB, Level.FINE);
        }
        Pair<Integer, String> inferenceResult = null;
        if (serving.getServingType() == ServingType.TENSORFLOW) {
            inferenceResult = this.tfInferenceController.infer(serving, modelVersion, verb, inferenceRequestJson);
        }
        if (serving.getServingType() == ServingType.SKLEARN) {
            inferenceResult = this.skLearnInferenceController.infer(serving, modelVersion, verb, inferenceRequestJson);
        }
        for (InferenceLogger inferenceLogger : this.inferenceLoggers) {
            try {
                inferenceLogger.logInferenceRequest(serving, inferenceRequestJson, (Integer)inferenceResult.getL(), (String)inferenceResult.getR());
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error logging inference for logger: " + inferenceLogger.getClassName(), e);
            }
        }
        if ((Integer)inferenceResult.getL() >= 500) {
            logger.log(Level.FINE, "Request error: " + inferenceResult.getL() + " - " + (String)inferenceResult.getR());
            throw new InferenceException(RESTCodes.InferenceErrorCode.SERVING_INSTANCE_INTERNAL, Level.FINE, (String)inferenceResult.getR());
        }
        if ((Integer)inferenceResult.getL() >= 400) {
            logger.log(Level.FINE, "Request error: " + inferenceResult.getL() + " - " + (String)inferenceResult.getR());
            throw new InferenceException(RESTCodes.InferenceErrorCode.SERVING_INSTANCE_BAD_REQUEST, Level.FINE, (String)inferenceResult.getR());
        }
        return (String)inferenceResult.getR();
    }
}

