/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.upload;

import io.hops.hopsworks.common.upload.HttpUtils;
import java.io.File;
import java.util.HashSet;

public class ResumableInfo {
    private int resumableChunkSize;
    private long resumableTotalSize;
    private String resumableIdentifier;
    private String resumableFilename;
    private String resumableRelativePath;
    private int resumableTemplateId;
    private long uploadedContentLength = 0L;
    private String resumableFilePath;
    private HashSet<ResumableChunkNumber> uploadedChunks = new HashSet();

    public boolean valid() {
        return this.resumableChunkSize >= 0 && this.resumableTotalSize >= 0L && !HttpUtils.isEmpty(this.resumableIdentifier) && !HttpUtils.isEmpty(this.resumableFilename) && !HttpUtils.isEmpty(this.resumableRelativePath);
    }

    private boolean checkIfUploadFinished() {
        if (this.uploadedContentLength != this.resumableTotalSize) {
            return false;
        }
        File file = new File(this.resumableFilePath);
        String new_path = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - ".temp".length());
        file.renameTo(new File(new_path));
        return true;
    }

    public synchronized boolean addChunkAndCheckIfFinished(ResumableChunkNumber rcn, long contentLength) {
        if (!this.uploadedChunks.contains(rcn)) {
            this.uploadedContentLength += contentLength;
        }
        this.uploadedChunks.add(rcn);
        return this.checkIfUploadFinished();
    }

    public boolean isUploaded(ResumableChunkNumber rcn) {
        return this.uploadedChunks.contains(rcn);
    }

    public int getResumableChunkSize() {
        return this.resumableChunkSize;
    }

    public long getResumableTotalSize() {
        return this.resumableTotalSize;
    }

    public String getResumableIdentifier() {
        return this.resumableIdentifier;
    }

    public String getResumableFilename() {
        return this.resumableFilename;
    }

    public String getResumableRelativePath() {
        return this.resumableRelativePath;
    }

    public int getResumableTemplateId() {
        return this.resumableTemplateId;
    }

    public long getUploadedContentLength() {
        return this.uploadedContentLength;
    }

    public String getResumableFilePath() {
        return this.resumableFilePath;
    }

    public void setResumableChunkSize(int resumableChunkSize) {
        this.resumableChunkSize = resumableChunkSize;
    }

    public void setResumableTotalSize(long resumableTotalSize) {
        this.resumableTotalSize = resumableTotalSize;
    }

    public void setResumableIdentifier(String resumableIdentifier) {
        this.resumableIdentifier = resumableIdentifier;
    }

    public void setResumableFilename(String resumableFilename) {
        this.resumableFilename = resumableFilename;
    }

    public void setResumableRelativePath(String resumableRelativePath) {
        this.resumableRelativePath = resumableRelativePath;
    }

    public void setResumableTemplateId(int resumableTemplateId) {
        this.resumableTemplateId = resumableTemplateId;
    }

    public void setUploadedContentLength(long uploadedContentLength) {
        this.uploadedContentLength = uploadedContentLength;
    }

    public void setResumableFilePath(String resumableFilePath) {
        this.resumableFilePath = resumableFilePath;
    }

    public static class ResumableChunkNumber {
        public int number;

        public ResumableChunkNumber(int number) {
            this.number = number;
        }

        public boolean equals(Object obj) {
            return obj instanceof ResumableChunkNumber ? ((ResumableChunkNumber)obj).number == this.number : false;
        }

        public int hashCode() {
            return this.number;
        }
    }
}

