/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.commands;

import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.WebCommunication;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.AnacondaRepo;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class CommandsController {
    private static final Logger LOGGER = Logger.getLogger(CommandsController.class.getName());
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private Settings settings;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private HostsFacade hostsFacade;
    @EJB
    private WebCommunication web;
    @EJB
    private LibraryFacade libraryFacade;
    @EJB
    private ProjectUtils projectUtils;

    public void deleteCommands(Project project, String lib) {
        this.condaCommandFacade.deleteCommandsForLibrary(project, lib);
    }

    public void deleteCommands(Project project) {
        this.condaCommandFacade.deleteCommandsForEnvironment(project);
    }

    public void retryFailedCondaEnvOps(Project project) {
        List<CondaCommands> commands = this.condaCommandFacade.getFailedEnvCommandsForProject(project);
        for (CondaCommands cc : commands) {
            cc.setStatus(CondaStatus.NEW);
            this.condaCommandFacade.update(cc);
        }
    }

    public void retryFailedCondaLibraryOps(Project project, String library) {
        List<CondaCommands> commands = this.condaCommandFacade.getFailedCommandsForProjectAndLib(project, library);
        for (CondaCommands cc : commands) {
            cc.setStatus(CondaStatus.NEW);
            this.condaCommandFacade.update(cc);
        }
    }

    public void deleteCommandsForProject(Project proj) {
        List<CondaCommands> commands = this.condaCommandFacade.getCommandsForProject(proj);
        if (commands == null) {
            return;
        }
        for (CondaCommands cc : commands) {
            this.condaCommandFacade.remove(cc);
        }
    }

    public PythonDep condaOp(CondaOp op, Users user, CondaInstallType installType, Project proj, String channelUrl, String lib, String version) throws GenericException {
        PythonDep dep;
        try {
            AnacondaRepo repo = this.libraryFacade.getRepo(channelUrl, true);
            dep = this.libraryFacade.getOrCreateDep(repo, installType, lib, version, true, false);
            Collection depsInProj = proj.getPythonDepCollection();
            if (depsInProj.contains(dep) && op == CondaOp.INSTALL) {
                throw new ProjectException(RESTCodes.ProjectErrorCode.PYTHON_LIB_ALREADY_INSTALLED, Level.FINE, "dep: " + dep.getDependency());
            }
            if (op == CondaOp.INSTALL) {
                depsInProj.remove(dep);
                depsInProj.add(dep);
            }
            proj.setPythonDepCollection(depsInProj);
            this.projectFacade.update(proj);
            CondaCommands cc = new CondaCommands(this.settings.getAnacondaUser(), user, op, CondaStatus.NEW, installType, proj, lib, version, channelUrl, new Date(), "", null, Boolean.valueOf(false));
            this.condaCommandFacade.save(cc);
        }
        catch (Exception ex) {
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, "condaOp failed", ex.getMessage(), (Throwable)ex);
        }
        return dep;
    }

    public void updateCondaCommandStatus(int commandId, CondaStatus condaStatus, String arg, CondaOp opType) throws ServiceException {
        this.updateCondaCommandStatus(commandId, condaStatus, arg, opType, null);
    }

    public void updateCondaCommandStatus(int commandId, CondaStatus condaStatus, String arg, CondaOp opType, String errorMessage) throws ServiceException {
        CondaCommands cc = this.condaCommandFacade.findCondaCommand(commandId);
        if (cc != null) {
            if (condaStatus == CondaStatus.SUCCESS) {
                this.condaCommandFacade.remove(cc);
                if (!CondaOp.isEnvOp((CondaOp)opType)) {
                    PythonDep dep = this.libraryFacade.getOrCreateDep(this.libraryFacade.getRepo(cc.getChannelUrl(), false), cc.getInstallType(), cc.getLib(), cc.getVersion(), true, false);
                    Collection deps = cc.getProjectId().getPythonDepCollection();
                    if (opType.equals((Object)CondaOp.INSTALL)) {
                        deps.remove(dep);
                        deps.add(dep);
                    } else if (opType.equals((Object)CondaOp.UNINSTALL)) {
                        deps.remove(dep);
                    }
                    cc.getProjectId().setPythonDepCollection(deps);
                    this.projectFacade.update(cc.getProjectId());
                }
            } else if (condaStatus == CondaStatus.FAILED) {
                cc.setStatus(condaStatus);
                cc.setArg(arg);
                cc.setErrorMsg(errorMessage);
                this.condaCommandFacade.update(cc);
            }
        } else {
            LOGGER.log(Level.FINE, "Could not remove CondaCommand with id: {0}", commandId);
        }
    }
}

