/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.common.featurestore.statistics.FeaturestoreStatisticFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeaturestoreStatistic;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeaturestoreStatisticValue;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.cluster_analysis.ClusterAnalysisDTO;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.correlation.FeatureCorrelationMatrixDTO;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.descriptive.DescriptiveStatsDTO;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.distribution.FeatureDistributionsDTO;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class FeaturestoreStatisticController {
    @EJB
    private FeaturestoreStatisticFacade featurestoreStatisticFacade;

    public void updateFeaturestoreStatistics(Featuregroup featuregroup, TrainingDataset trainingDataset, FeatureCorrelationMatrixDTO featureCorrelationMatrix, DescriptiveStatsDTO descriptiveStatistics, FeatureDistributionsDTO featuresHistogram, ClusterAnalysisDTO clusterAnalysis) {
        if (featuregroup != null) {
            this.removeFeaturestoreStatistics((List)featuregroup.getStatistics());
        }
        if (trainingDataset != null) {
            this.removeFeaturestoreStatistics((List)trainingDataset.getStatistics());
        }
        this.insertFeaturestoreStatistics(featuregroup, trainingDataset, featureCorrelationMatrix, descriptiveStatistics, featuresHistogram, clusterAnalysis);
    }

    private void removeFeaturestoreStatistics(List<FeaturestoreStatistic> featurestoreStatistics) {
        featurestoreStatistics.stream().forEach(fs -> this.featurestoreStatisticFacade.remove(fs));
    }

    private void insertFeaturestoreStatistics(Featuregroup featuregroup, TrainingDataset trainingDataset, FeatureCorrelationMatrixDTO featureCorrelationMatrix, DescriptiveStatsDTO descriptiveStatistics, FeatureDistributionsDTO featuresHistogram, ClusterAnalysisDTO clusterAnalysis) {
        ArrayList<FeaturestoreStatistic> featurestoreStatistics = new ArrayList<FeaturestoreStatistic>();
        if (descriptiveStatistics != null) {
            featurestoreStatistics.addAll(this.convertDescriptiveStatstoFeaturestoreStatistic(descriptiveStatistics, featuregroup, trainingDataset));
        }
        if (featuresHistogram != null) {
            featurestoreStatistics.addAll(this.convertFeatureDistributionsToFeaturestoreStatistics(featuresHistogram, featuregroup, trainingDataset));
        }
        if (featureCorrelationMatrix != null) {
            featurestoreStatistics.addAll(this.convertFeatureMatrixToFeaturestoreStatistics(featureCorrelationMatrix, featuregroup, trainingDataset));
        }
        if (clusterAnalysis != null) {
            featurestoreStatistics.add(this.convertClusterAnalysisToFeaturestoreStatistic(clusterAnalysis, featuregroup, trainingDataset));
        }
        featurestoreStatistics.stream().forEach(fs -> this.featurestoreStatisticFacade.persist((FeaturestoreStatistic)fs));
    }

    private List<FeaturestoreStatistic> convertDescriptiveStatstoFeaturestoreStatistic(DescriptiveStatsDTO descriptiveStatsDTO, Featuregroup featuregroup, TrainingDataset trainingDataset) {
        ArrayList<FeaturestoreStatistic> featurestoreStatistics = new ArrayList<FeaturestoreStatistic>();
        descriptiveStatsDTO.getDescriptiveStats().stream().forEach(ds -> {
            FeaturestoreStatistic featurestoreStatistic = new FeaturestoreStatistic();
            featurestoreStatistic.setName(ds.getFeatureName());
            featurestoreStatistic.setTrainingDataset(trainingDataset);
            featurestoreStatistic.setFeaturegroup(featuregroup);
            featurestoreStatistic.setValue((FeaturestoreStatisticValue)ds);
            featurestoreStatistic.setStatisticType(ds.getStatisticType());
            featurestoreStatistics.add(featurestoreStatistic);
        });
        return featurestoreStatistics;
    }

    private FeaturestoreStatistic convertClusterAnalysisToFeaturestoreStatistic(ClusterAnalysisDTO clusterAnalysisDTO, Featuregroup featuregroup, TrainingDataset trainingDataset) {
        FeaturestoreStatistic featurestoreStatistic = new FeaturestoreStatistic();
        featurestoreStatistic.setName("cluster analysis");
        featurestoreStatistic.setFeaturegroup(featuregroup);
        featurestoreStatistic.setTrainingDataset(trainingDataset);
        featurestoreStatistic.setValue((FeaturestoreStatisticValue)clusterAnalysisDTO);
        featurestoreStatistic.setStatisticType(clusterAnalysisDTO.getStatisticType());
        return featurestoreStatistic;
    }

    private List<FeaturestoreStatistic> convertFeatureDistributionsToFeaturestoreStatistics(FeatureDistributionsDTO featureDistributionsDTO, Featuregroup featuregroup, TrainingDataset trainingDataset) {
        ArrayList<FeaturestoreStatistic> featurestoreStatistics = new ArrayList<FeaturestoreStatistic>();
        featureDistributionsDTO.getFeatureDistributions().stream().forEach(fd -> {
            FeaturestoreStatistic featurestoreStatistic = new FeaturestoreStatistic();
            featurestoreStatistic.setName(fd.getFeatureName());
            featurestoreStatistic.setTrainingDataset(trainingDataset);
            featurestoreStatistic.setFeaturegroup(featuregroup);
            featurestoreStatistic.setValue((FeaturestoreStatisticValue)fd);
            featurestoreStatistic.setStatisticType(fd.getStatisticType());
            featurestoreStatistics.add(featurestoreStatistic);
        });
        return featurestoreStatistics;
    }

    private List<FeaturestoreStatistic> convertFeatureMatrixToFeaturestoreStatistics(FeatureCorrelationMatrixDTO featureCorrelationMatrixDTO, Featuregroup featuregroup, TrainingDataset trainingDataset) {
        ArrayList<FeaturestoreStatistic> featurestoreStatistics = new ArrayList<FeaturestoreStatistic>();
        featureCorrelationMatrixDTO.getFeatureCorrelations().stream().forEach(fc -> fc.getCorrelationValues().stream().forEach(cv -> {
            FeaturestoreStatistic featurestoreStatistic = new FeaturestoreStatistic();
            featurestoreStatistic.setFeaturegroup(featuregroup);
            featurestoreStatistic.setTrainingDataset(trainingDataset);
            featurestoreStatistic.setName(fc.getFeatureName());
            featurestoreStatistic.setValue((FeaturestoreStatisticValue)cv);
            featurestoreStatistic.setStatisticType(cv.getStatisticType());
            featurestoreStatistics.add(featurestoreStatistic);
        }));
        return featurestoreStatistics;
    }
}

