/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.cached;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.featurestore.FeaturestoreController;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class OfflineFeatureGroupController {
    private static final Logger LOGGER = Logger.getLogger(OfflineFeatureGroupController.class.getName());
    @EJB
    private FeaturestoreController featurestoreController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private Settings settings;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    private Configuration metastoreConf;
    private static final String COMMENT = "comment";
    private static final int CONNECTION_TIMEOUT = 600000;

    @PostConstruct
    public void init() {
        this.metastoreConf = MetastoreConf.newMetastoreConf();
        this.metastoreConf.addResource(new Path(this.settings.getHiveConfPath()));
    }

    public void createHiveTable(Featurestore featurestore, String tableName, String tableDesc, List<FeatureDTO> featureDTOList, Project project, Users user) throws FeaturestoreException, ServiceException, IOException {
        String dbName = this.featurestoreController.getOfflineFeaturestoreDbName(featurestore.getProject());
        Table table = this.getEmptyTable(dbName, tableName, this.hdfsUsersController.getHdfsUserName(project, user));
        table.getParameters().put(COMMENT, tableDesc);
        ArrayList<SQLPrimaryKey> primaryKeys = new ArrayList<SQLPrimaryKey>();
        int constraintId = 0;
        for (FeatureDTO featureDTO : featureDTOList) {
            FieldSchema fieldSchema = new FieldSchema(featureDTO.getName(), featureDTO.getType().toLowerCase(), featureDTO.getDescription());
            if (featureDTO.getPartition().booleanValue()) {
                table.addToPartitionKeys(fieldSchema);
            } else {
                table.getSd().addToCols(fieldSchema);
            }
            if (!featureDTO.getPrimary().booleanValue()) continue;
            primaryKeys.add(new SQLPrimaryKey(dbName, tableName, featureDTO.getName(), constraintId++, dbName + "_" + tableName + "_" + featureDTO.getName() + "_pk", false, false, false));
        }
        this.sendMetastoreCreate(table, primaryKeys, project, user);
    }

    private void sendMetastoreCreate(Table table, List<SQLPrimaryKey> primaryKeys, Project project, Users user) throws FeaturestoreException, ServiceException, IOException {
        ThriftHiveMetastore.Client client = null;
        try {
            client = this.openMetastoreClient(project, user);
            client.create_table_with_constraints(table, primaryKeys, null, null, null, null, null);
        }
        catch (TException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_FEATUREGROUP, Level.SEVERE, "Error creating feature group in the Hive Metastore: " + e.getMessage(), e.getMessage(), (Throwable)e);
        }
        finally {
            this.certificateMaterializer.removeCertificatesLocal(user.getUsername(), project.getName());
            if (client != null) {
                try {
                    client.shutdown();
                }
                catch (TException e) {
                    LOGGER.log(Level.SEVERE, "Error closing Metastore connection", e);
                }
            }
        }
    }

    public void dropFeatureGroup(String dbName, String tableName, Project project, Users user) throws FeaturestoreException, ServiceException, IOException {
        ThriftHiveMetastore.Client client = null;
        try {
            client = this.openMetastoreClient(project, user);
            client.drop_table(dbName, tableName, true);
        }
        catch (TException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_FEATUREGROUP, Level.SEVERE, "Error dropping feature group in the Hive Metastore: " + e.getMessage(), e.getMessage(), (Throwable)e);
        }
        finally {
            this.certificateMaterializer.removeCertificatesLocal(user.getUsername(), project.getName());
            if (client != null) {
                try {
                    client.shutdown();
                }
                catch (TException e) {
                    LOGGER.log(Level.SEVERE, "Error closing Metastore connection", e);
                }
            }
        }
    }

    private ThriftHiveMetastore.Client openMetastoreClient(Project project, Users user) throws ServiceException, IOException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        ThriftHiveMetastore.Client client = null;
        try {
            TSocket transport;
            this.certificateMaterializer.materializeCertificatesLocal(user.getUsername(), project.getName());
            CertificateMaterializer.CryptoMaterial userMaterial = this.certificateMaterializer.getUserMaterial(user.getUsername(), project.getName());
            String password = String.copyValueOf(userMaterial.getPassword());
            Service metastoreService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.HIVE_METASTORE);
            if (this.settings.getHopsRpcTls()) {
                TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
                params.setTrustStore(this.certificateMaterializer.getUserTransientTruststorePath(project, user), password);
                params.setKeyStore(this.certificateMaterializer.getUserTransientKeystorePath(project, user), password);
                transport = TSSLTransportFactory.getClientSocket((String)metastoreService.getAddress(), (int)metastoreService.getPort(), (int)600000, (TSSLTransportFactory.TSSLTransportParameters)params);
            } else {
                transport = new TSocket(metastoreService.getAddress(), metastoreService.getPort().intValue(), 600000);
            }
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            client = new ThriftHiveMetastore.Client((TProtocol)protocol);
            if (!transport.isOpen()) {
                transport.open();
            }
            client.set_ugi(hdfsUsername, new ArrayList());
            if (this.settings.getHopsRpcTls()) {
                client.set_crypto(userMaterial.getKeyStore(), password, userMaterial.getTrustStore(), password, false);
            }
        }
        catch (ServiceDiscoveryException | CryptoPasswordNotFoundException | TException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.METASTORE_CONNECTION_ERROR, Level.SEVERE, "Hive metastore connection error", e.getMessage(), e);
        }
        return client;
    }

    private Table getEmptyTable(String databaseName, String tableName, String username) {
        Formats format = Formats.valueOf(this.settings.getFeaturestoreDbDefaultStorageFormat());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setSerdeInfo(new SerDeInfo());
        sd.setNumBuckets(-1);
        sd.setBucketCols(new ArrayList());
        sd.setCols(new ArrayList());
        sd.setParameters(new HashMap());
        sd.setSortCols(new ArrayList());
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().setSerializationLib(format.getSerde());
        sd.setInputFormat(format.getInputFormat());
        sd.setOutputFormat(format.getOutputFormat());
        sd.getSerdeInfo().getParameters().put("serialization.format", "1");
        SkewedInfo skewInfo = new SkewedInfo();
        skewInfo.setSkewedColNames(new ArrayList());
        skewInfo.setSkewedColValues(new ArrayList());
        skewInfo.setSkewedColValueLocationMaps(new HashMap());
        sd.setSkewedInfo(skewInfo);
        Table t = new Table();
        t.setSd(sd);
        t.setPartitionKeys(new ArrayList());
        t.setParameters(new HashMap());
        t.setTableType(TableType.MANAGED_TABLE.toString());
        t.setDbName(databaseName);
        t.setTableName(tableName);
        t.setOwner(username);
        t.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        t.getParameters().put("bucketing_version", "2");
        return t;
    }

    public static enum Formats {
        ORC("org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat", "org.apache.hadoop.hive.ql.io.orc.OrcSerde"),
        PARQUET("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat", "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe"),
        AVRO("org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat", "org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat", "org.apache.hadoop.hive.serde2.avro.AvroSerDe"),
        HUDI("org.apache.hudi.hadoop.HoodieParquetInputFormat", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat", "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");

        private String inputFormat;
        private String outputFormat;
        private String serde;

        private Formats(String inputFormat, String outputFormat, String serde) {
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;
            this.serde = serde;
        }

        public String getInputFormat() {
            return this.inputFormat;
        }

        public String getOutputFormat() {
            return this.outputFormat;
        }

        public String getSerde() {
            return this.serde;
        }
    }
}

