/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.app;

import com.lambdista.util.Try;
import io.hops.hopsworks.common.provenance.app.dto.ProvAppStateElastic;
import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.elastic.BasicElasticHit;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHelper;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHits;
import io.hops.hopsworks.common.provenance.core.elastic.ProvElasticController;
import io.hops.hopsworks.common.provenance.util.ProvHelper;
import io.hops.hopsworks.common.provenance.util.functional.CheckedFunction;
import io.hops.hopsworks.common.provenance.util.functional.CheckedSupplier;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.javatuples.Pair;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProvAppController {
    @EJB
    private Settings settings;
    @EJB
    private ProvElasticController client;

    public Map<String, Map<Provenance.AppState, ProvAppStateElastic>> provAppState(Map<ProvParser.Field, ProvParser.FilterVal> appStateFilters) throws ProvenanceException {
        Pair<Long, Try<ElasticAppStatesObj>> searchResult;
        CheckedSupplier<SearchRequest, ProvenanceException> srF = ElasticHelper.scrollingSearchRequest("app_prov", this.settings.getElasticDefaultScrollPageSize()).andThen(this.provAppStateQB(appStateFilters));
        SearchRequest request = srF.get();
        try {
            searchResult = this.client.searchScrolling(request, ElasticAppStatesObj.getHandler());
        }
        catch (ElasticException e) {
            String msg = "provenance - elastic query problem";
            throw ProvHelper.fromElastic(e, msg, msg + " - app state");
        }
        return ElasticAppStatesObj.checkedResult(searchResult);
    }

    private CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> provAppStateQB(Map<ProvParser.Field, ProvParser.FilterVal> appStateFilters) {
        return sr -> {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query = ElasticHelper.filterByBasicFields(query, appStateFilters);
            sr.source().query((QueryBuilder)query);
            return sr;
        };
    }

    private static class ElasticAppStatesObj
    extends HashMap<String, Map<Provenance.AppState, ProvAppStateElastic>> {
        private ElasticAppStatesObj() {
        }

        private static ElasticHits.Merger<ProvAppStateElastic, ElasticAppStatesObj> getMerger() {
            return (item, states) -> {
                Map appIdStates = states.computeIfAbsent(item.getAppId(), key -> new TreeMap());
                appIdStates.put(item.getAppState(), item);
                return Try.apply(() -> states);
            };
        }

        static ElasticHits.Handler<ProvAppStateElastic, ElasticAppStatesObj> getHandler() {
            ElasticHits.Parser parser = hit -> ProvAppStateElastic.tryInstance(BasicElasticHit.instance(hit));
            return ElasticHits.handlerBasic(parser, new ElasticAppStatesObj(), ElasticAppStatesObj.getMerger());
        }

        static Map<String, Map<Provenance.AppState, ProvAppStateElastic>> checkedResult(Pair<Long, Try<ElasticAppStatesObj>> result) throws ProvenanceException {
            try {
                return (Map)((Try)result.getValue1()).checkedGet();
            }
            catch (Throwable t) {
                if (t instanceof ProvenanceException) {
                    throw (ProvenanceException)t;
                }
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.INFO, "unhandled error", "unhandled error", t);
            }
        }
    }
}

