/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.environment;

import io.hops.hopsworks.common.dao.command.SystemCommandFacade;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.integrations.UnmanagedStereotype;
import io.hops.hopsworks.common.proxies.client.HttpClient;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.environment.DockerRegistryMngr;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.command.Operation;
import io.hops.hopsworks.persistence.entity.command.SystemCommand;
import io.hops.hopsworks.persistence.entity.host.Hosts;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
@UnmanagedStereotype
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class LocalDockerRegistryMngr
implements DockerRegistryMngr {
    private static final Logger LOG = Logger.getLogger(LocalDockerRegistryMngr.class.getName());
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private Settings settings;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private SystemCommandFacade systemCommandFacade;
    @EJB
    private HostsFacade hostsFacade;
    @EJB
    private HttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gc() throws IOException, ServiceException {
        List<CondaCommands> condaCommandsRemove = this.condaCommandFacade.findByStatusAndCondaOp(CondaStatus.NEW, CondaOp.REMOVE);
        try {
            for (CondaCommands cc : condaCommandsRemove) {
                String projectDockerImage = cc.getArg();
                String projectDockerImageNoTags = projectDockerImage.split(":")[0];
                if (!projectDockerImage.equals(this.settings.getBaseDockerImage())) {
                    try {
                        URI registryURL = URI.create("https://" + this.projectUtils.getRegistryURL() + "/v2/" + projectDockerImageNoTags + "/tags/list");
                        HttpGet request = new HttpGet(registryURL);
                        request.setHeader("Content-Type", "application/json");
                        HttpHost host = new HttpHost(registryURL.getHost(), registryURL.getPort(), registryURL.getScheme());
                        String httpResp = (String)this.httpClient.execute(host, (HttpRequest)request, httpResponse -> {
                            if (httpResponse.getStatusLine().getStatusCode() >= 400) {
                                throw new IOException("Could not fetch tags from registry: " + httpResponse.getStatusLine().toString());
                            }
                            return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                        });
                        JSONObject respJson = new JSONObject(httpResp);
                        if (respJson.has("tags") && respJson.get("tags") != "null") {
                            JSONArray tagsJSON = new JSONObject(httpResp).getJSONArray("tags");
                            for (int i = 0; i < tagsJSON.length(); ++i) {
                                String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
                                String tag = tagsJSON.get(i).toString();
                                ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("delete").addCommand(projectDockerImageNoTags).addCommand(tag).redirectErrorStream(true).setWaitTimeout(5L, TimeUnit.MINUTES).build();
                                ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
                                if (processResult.getExitCode() != 0) {
                                    throw new IOException("Could not delete the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr());
                                }
                                this.dockerImagesGC(this.projectUtils.getRegistryURL() + "/" + projectDockerImageNoTags + ":" + tag);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "Could not complete docker registry cleanup for: " + cc, ex);
                        try {
                            this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.FAILED, cc.getArg(), cc.getOp(), "Could not complete docker registry cleanup: " + ex.getMessage());
                        }
                        catch (ServiceException e) {
                            LOG.log(Level.WARNING, "Could not change conda command status to NEW.", e);
                        }
                    }
                }
                this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.SUCCESS, cc.getArg(), cc.getOp());
            }
        }
        finally {
            if (!condaCommandsRemove.isEmpty()) {
                String prog = this.settings.getSudoersDir() + "/dockerImage.sh";
                ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("gc").redirectErrorStream(true).setWaitTimeout(5L, TimeUnit.MINUTES).build();
                ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
                if (processResult.getExitCode() != 0) {
                    LOG.log(Level.WARNING, "Could not delete the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr());
                }
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void dockerImagesGC(String image) {
        List allHosts = this.hostsFacade.findAll();
        for (Hosts host : allHosts) {
            SystemCommand condaGCCommand = new SystemCommand(host, Operation.CONDA_GC);
            condaGCCommand.setCommandArgumentsAsString(image);
            this.systemCommandFacade.persist(condaGCCommand);
        }
    }
}

