/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security.secrets;

import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.security.MasterPasswordChangeResult;
import io.hops.hopsworks.common.security.MasterPasswordHandler;
import io.hops.hopsworks.common.security.SymmetricEncryptionDescriptor;
import io.hops.hopsworks.common.security.SymmetricEncryptionService;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.exceptions.EncryptionMasterPasswordException;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.persistence.entity.user.security.secrets.SecretId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class SecretsPasswordHandler
implements MasterPasswordHandler {
    private final Logger LOGGER = Logger.getLogger(SecretsPasswordHandler.class.getName());
    @EJB
    private SecretsController secretsController;
    @EJB
    private SymmetricEncryptionService symmetricEncryptionService;
    @EJB
    private SecretsFacade secretsFacade;

    @Override
    public void pre() {
    }

    @Override
    public MasterPasswordChangeResult perform(String oldPassword, String newPassword) {
        HashMap<SecretId, byte[]> secrets2Rollback = new HashMap<SecretId, byte[]>();
        StringBuilder successLog = new StringBuilder();
        successLog.append("Performing change of master password for Secrets\n");
        try {
            this.LOGGER.log(Level.INFO, "Updating Secrets with new Hopsworks master encryption password");
            List<Secret> cipheredSecrets = this.secretsController.getAllCiphered();
            for (Secret cipheredSecret : cipheredSecrets) {
                SecretId secretId = cipheredSecret.getId();
                secrets2Rollback.put(secretId, cipheredSecret.getSecret());
                byte[][] cryptoPrimitives = this.symmetricEncryptionService.splitPayloadFromCryptoPrimitives(cipheredSecret.getSecret());
                SymmetricEncryptionDescriptor inDescriptor = new SymmetricEncryptionDescriptor.Builder().setPassword(oldPassword).setSalt(cryptoPrimitives[0]).setIV(cryptoPrimitives[1]).setInput(cryptoPrimitives[2]).build();
                SymmetricEncryptionDescriptor outDescriptor = this.symmetricEncryptionService.decrypt(inDescriptor);
                inDescriptor.clearPassword();
                inDescriptor = new SymmetricEncryptionDescriptor.Builder().setInput(outDescriptor.getOutput()).setPassword(newPassword).build();
                outDescriptor = this.symmetricEncryptionService.encrypt(inDescriptor);
                inDescriptor.clearPassword();
                byte[] newCipheredSecret = this.symmetricEncryptionService.mergePayloadWithCryptoPrimitives(outDescriptor.getSalt(), outDescriptor.getIv(), outDescriptor.getOutput());
                Secret newSecret = new Secret(secretId, newCipheredSecret, cipheredSecret.getAddedOn());
                newSecret.setVisibilityType(cipheredSecret.getVisibilityType());
                if (cipheredSecret.getProjectIdScope() != null) {
                    newSecret.setProjectIdScope(cipheredSecret.getProjectIdScope());
                }
                this.secretsFacade.update(newSecret);
                successLog.append("Updated Secret <").append(newSecret.getId().getUid()).append(",").append(newSecret.getId().getName()).append(">\n");
            }
            return new MasterPasswordChangeResult(successLog, secrets2Rollback, null);
        }
        catch (Exception ex) {
            String errorMsg = "Error while updating master encryption password for Secrets";
            this.LOGGER.log(Level.SEVERE, errorMsg, ex);
            return new MasterPasswordChangeResult(secrets2Rollback, new EncryptionMasterPasswordException(errorMsg, (Throwable)ex));
        }
    }

    @Override
    public void rollback(MasterPasswordChangeResult result) {
        HashMap secrets2rollback = (HashMap)result.getRollbackItems();
        this.LOGGER.log(Level.INFO, "Rolling back Secrets");
        for (Map.Entry secret2rollback : secrets2rollback.entrySet()) {
            Secret persistedSecret = this.secretsFacade.findById((SecretId)secret2rollback.getKey());
            if (persistedSecret == null) continue;
            Secret secret = new Secret((SecretId)secret2rollback.getKey(), (byte[])secret2rollback.getValue(), persistedSecret.getAddedOn());
            secret.setVisibilityType(persistedSecret.getVisibilityType());
            if (persistedSecret.getProjectIdScope() != null) {
                secret.setProjectIdScope(persistedSecret.getProjectIdScope());
            }
            this.secretsFacade.update(secret);
        }
    }

    @Override
    public void post() {
    }
}

