/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.online;

import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class OnlineFeaturestoreFacade {
    private static final Logger LOGGER = Logger.getLogger(OnlineFeaturestoreFacade.class.getName());
    @PersistenceContext(unitName="featurestorePU")
    private EntityManager em;

    public Double getDbSize(String dbName) {
        try {
            return ((BigDecimal)this.em.createNativeQuery("SELECT ROUND(SUM(`tables`.`data_length` + `index_length`) / 1024 / 1024, 1) AS 'size_mb' FROM information_schema.`tables` WHERE `tables`.`table_schema`=? GROUP BY `tables`.`table_schema`").setParameter(1, (Object)dbName).getSingleResult()).doubleValue();
        }
        catch (NoResultException e) {
            return 0.0;
        }
    }

    public BigInteger getTblSize(String tableName, String dbName) {
        try {
            return (BigInteger)this.em.createNativeQuery("SELECT (`TABLES`.`data_length` + `TABLES`.`index_length`) `size` FROM information_schema.`TABLES` WHERE table_schema=? AND table_name=?;").setParameter(1, (Object)dbName).setParameter(2, (Object)tableName).getSingleResult();
        }
        catch (NoResultException e) {
            return BigInteger.ZERO;
        }
    }

    public List<FeatureDTO> getMySQLFeatures(String tableName, String db) {
        List featureObjects = this.em.createNativeQuery("SELECT `COLUMNS`.`COLUMN_NAME`, `COLUMNS`.`COLUMN_TYPE`, `COLUMNS`.`COLUMN_COMMENT` FROM INFORMATION_SCHEMA.`COLUMNS` WHERE `COLUMNS`.`TABLE_NAME`=? AND `COLUMNS`.`TABLE_SCHEMA`=?;").setParameter(1, (Object)tableName).setParameter(2, (Object)db).getResultList();
        ArrayList<FeatureDTO> featureDTOs = new ArrayList<FeatureDTO>();
        for (Object[] featureObject : featureObjects) {
            FeatureDTO featureDTO = new FeatureDTO((String)featureObject[0], (String)featureObject[1], (String)featureObject[2]);
            featureDTOs.add(featureDTO);
        }
        return featureDTOs;
    }

    public String getMySQLSchema(String tableName, String db) {
        List schemaObjects = this.em.createNativeQuery("SHOW CREATE TABLE `" + db + "`.`" + tableName + "`;").getResultList();
        return (String)((Object[])schemaObjects.get(0))[1];
    }

    public void createOnlineFeaturestoreDatabase(String db) {
        this.em.createNativeQuery("CREATE DATABASE " + db + ";").executeUpdate();
    }

    public void removeOnlineFeaturestoreDatabase(String db) {
        this.em.createNativeQuery("DROP DATABASE IF EXISTS " + db + ";").executeUpdate();
    }

    public void createOnlineFeaturestoreUser(String user, String pw) {
        this.em.createNativeQuery("CREATE USER IF NOT EXISTS ? IDENTIFIED BY ?;").setParameter(1, (Object)user).setParameter(2, (Object)pw).executeUpdate();
    }

    public void revokeUserPrivileges(String dbName, String dbUser) {
        try {
            String grantee = "'" + dbUser + "'@'%'";
            Long numGrants = (Long)this.em.createNativeQuery("SELECT COUNT(*) FROM information_schema.SCHEMA_PRIVILEGES WHERE GRANTEE = ? AND TABLE_SCHEMA = ?").setParameter(1, (Object)grantee).setParameter(2, (Object)dbName).getSingleResult();
            if (numGrants != 0L) {
                this.em.createNativeQuery("REVOKE ALL PRIVILEGES ON " + dbName + ".* FROM " + dbUser + ";").executeUpdate();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in revoking the privileges", e);
        }
    }

    public void grantDataOwnerPrivileges(String dbName, String dbUser) {
        this.em.createNativeQuery("GRANT ALL PRIVILEGES ON " + dbName + ".* TO " + dbUser + ";").executeUpdate();
    }

    public void grantDataScientistPrivileges(String dbName, String dbUser) {
        this.em.createNativeQuery("GRANT SELECT ON " + dbName + ".* TO " + dbUser + ";").executeUpdate();
    }

    public void removeOnlineFeaturestoreUser(String dbUser) {
        this.em.createNativeQuery("DROP USER IF EXISTS ?").setParameter(1, (Object)dbUser).executeUpdate();
    }

    public List<String> getDatabaseUsers(String dbName) {
        return this.em.createNativeQuery("SELECT `User` FROM `mysql`.`user` WHERE `User` LIKE ?").setParameter(1, (Object)(dbName + "_%")).getResultList();
    }

    public Boolean checkIfDatabaseExists(String dbName) {
        try {
            this.em.createNativeQuery("SELECT `SCHEMA_NAME` FROM `INFORMATION_SCHEMA`.`SCHEMATA` WHERE `SCHEMA_NAME`=?").setParameter(1, (Object)dbName).getSingleResult();
            return true;
        }
        catch (NoResultException e) {
            return false;
        }
    }
}

