/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.yarn;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.jobs.AsynchronousJobExecutor;
import io.hops.hopsworks.common.jobs.yarn.YarnSetupCommand;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.yarn.LocalResourceDTO;
import io.hops.hopsworks.persistence.entity.jobs.configuration.yarn.YarnJobConfiguration;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.flink.client.deployment.ClusterDeploymentException;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.yarn.YarnClusterDescriptor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.parquet.Strings;

public class YarnRunner {
    private static final Logger logger = Logger.getLogger(YarnRunner.class.getName());
    public static final String APPID_PLACEHOLDER = "**APPID";
    public static final String KEY_CLASSPATH = "CLASSPATH";
    private static final String LOCAL_LOG_DIR_PLACEHOLDER = "<LOG_DIR>";
    private Configuration conf;
    private ApplicationId appId = null;
    private JobType jobType;
    private YarnClusterDescriptor yarnClusterDescriptor;
    private ClusterSpecification clusterSpecification;
    private final String amQueue;
    private int amMemory;
    private int amVCores;
    private String appName;
    private final String amMainClass;
    private String amArgs;
    private final Map<String, LocalResourceDTO> amLocalResourcesOnHDFS;
    private final Map<String, String> amEnvironment;
    private String localResourcesBasePath;
    private final List<String> filesToBeCopied;
    private final List<YarnSetupCommand> commands;
    private final List<String> javaOptions;
    private final List<String> filesToRemove;
    private String serviceDir;
    private final AsynchronousJobExecutor services;
    private DistributedFileSystemOps dfsClient;
    private YarnClient yarnClient;
    private boolean readyToSubmit = false;
    private ApplicationSubmissionContext appContext;

    public static String escapeForShell(String s) {
        if (s != null) {
            StringBuilder escaped = new StringBuilder("'");
            block5: for (int i = 0; i < s.length(); ++i) {
                switch (s.charAt(i)) {
                    case '$': {
                        escaped.append("\\$");
                        continue block5;
                    }
                    case '\"': {
                        escaped.append("\\\"");
                        continue block5;
                    }
                    case '\'': {
                        escaped.append("'\\''");
                        continue block5;
                    }
                    default: {
                        escaped.append(s.charAt(i));
                    }
                }
            }
            return escaped.append("'").toString();
        }
        return s;
    }

    private void copyUserCertificates(Project project, JobType jobType, DistributedFileSystemOps dfso, String username, String applicationId) {
        ArrayList<LocalResourceDTO> materialResources = new ArrayList<LocalResourceDTO>(2);
        HashMap systemProperties = new HashMap(2);
        HopsUtils.copyProjectUserCerts(project, username, this.services.getSettings().getHopsworksTmpCertDir(), this.services.getSettings().getHdfsTmpCertDir(), jobType, dfso, materialResources, applicationId, this.services.getCertificateMaterializer());
        for (LocalResourceDTO localResourceDTO : materialResources) {
            this.amLocalResourcesOnHDFS.put(localResourceDTO.getName(), localResourceDTO);
        }
        for (Map.Entry entry : systemProperties.entrySet()) {
            String option = YarnRunner.escapeForShell("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            this.javaOptions.add(option);
        }
    }

    ApplicationId startAppMaster(Project project, DistributedFileSystemOps dfso, String username, String args) throws YarnException, IOException, URISyntaxException, InterruptedException {
        logger.info("Starting application master.");
        if (this.jobType == JobType.SPARK || this.jobType == JobType.PYSPARK) {
            if (!Strings.isNullOrEmpty((String)args)) {
                String[] argsArray;
                for (String s : argsArray = args.trim().split(" ")) {
                    this.amArgs = this.amArgs + " --arg '" + s + "'";
                }
            }
            YarnClientApplication app = this.yarnClient.createApplication();
            GetNewApplicationResponse appResponse = app.getNewApplicationResponse();
            this.appId = appResponse.getApplicationId();
            this.fillInAppid(this.appId.toString());
            if (!this.services.getSettings().getHopsRpcTls()) {
                this.copyUserCertificates(project, this.jobType, dfso, username, this.appId.toString());
            }
            this.checkAmResourceRequest(appResponse);
            this.appContext = app.getApplicationSubmissionContext();
            this.appContext.setApplicationName(this.appName);
            this.appContext.setApplicationType("Hopsworks-Yarn");
            Map<String, LocalResource> localResources = this.addAllToLocalResources();
            this.copyAllToHDFS();
            HashMap<String, String> env = new HashMap<String, String>(this.amEnvironment);
            this.setUpClassPath(env);
            List<String> amCommands = this.setUpCommands();
            ContainerLaunchContext amContainer = ContainerLaunchContext.newInstance(localResources, env, amCommands, null, null, null);
            this.appContext.setAMContainerSpec(amContainer);
            this.appContext.setResource(Resource.newInstance((int)this.amMemory, (int)this.amVCores));
            this.appContext.setQueue(this.amQueue);
            this.readyToSubmit = true;
            for (YarnSetupCommand c : this.commands) {
                c.execute(this);
            }
            logger.log(Level.INFO, "Submitting application {0}", this.appId);
            this.yarnClient.submitApplication(this.appContext);
        } else if (this.jobType == JobType.FLINK) {
            logger.log(Level.INFO, "FLINK: YarnRunner got a Flink Job!");
            YarnClientApplication yarnApplication = this.yarnClient.createApplication();
            GetNewApplicationResponse appResponse = yarnApplication.getNewApplicationResponse();
            this.yarnClusterDescriptor.setYarnApplication(yarnApplication);
            this.yarnClusterDescriptor.setAppResponse(appResponse);
            this.appId = appResponse.getApplicationId();
            this.fillInAppid(this.appId.toString());
            logger.log(Level.INFO, "FLINK: Created YarnApplication with appId = {0},", this.appId.toString());
            this.yarnClusterDescriptor.setStagingDir(new Path(this.localResourcesBasePath));
            try {
                logger.log(Level.FINE, "Deploying Flink cluster.");
                ClusterClient clusterClient = this.yarnClusterDescriptor.deploySessionCluster(this.clusterSpecification);
                clusterClient.setDetached(true);
                this.appId = (ApplicationId)clusterClient.getClusterId();
                logger.log(Level.FINE, "Deployed Flink cluster with ID {0}", this.appId.toString());
            }
            catch (ClusterDeploymentException ex) {
                logger.log(Level.INFO, "FLINK: Error ClusterDeploymentException while submitting Flink job to cluster ", ex);
                throw new IOException("FLINK: Error while submitting Flink job to cluster, ClusterDeploymentException : " + ex.getMessage());
            }
            finally {
                this.yarnClusterDescriptor = null;
                this.appContext = null;
            }
        }
        return this.appId;
    }

    public ApplicationSubmissionContext getAppContext() {
        if (!this.readyToSubmit) {
            throw new IllegalStateException("ApplicationSubmissionContext cannot be requested before it is set up.");
        }
        return this.appContext;
    }

    public void stop(DistributedFsService dfs) {
        if (this.dfsClient != null && dfs != null) {
            dfs.closeDfsClient(this.dfsClient);
        }
    }

    private void fillInAppid(String id) {
        this.localResourcesBasePath = this.localResourcesBasePath.replace(APPID_PLACEHOLDER, id);
        this.appName = this.appName.replace(APPID_PLACEHOLDER, id);
        if (this.amArgs != null) {
            this.amArgs = this.amArgs.replace(APPID_PLACEHOLDER, id);
        }
        for (Map.Entry<String, String> entry : this.amEnvironment.entrySet()) {
            entry.setValue(entry.getValue().replace(APPID_PLACEHOLDER, id));
        }
        ListIterator<String> i = this.javaOptions.listIterator();
        while (i.hasNext()) {
            i.set(i.next().replace(APPID_PLACEHOLDER, id));
        }
        i = this.filesToRemove.listIterator();
        while (i.hasNext()) {
            i.set(i.next().replace(APPID_PLACEHOLDER, id));
        }
        if (this.jobType == JobType.FLINK) {
            this.yarnClusterDescriptor.setDynamicPropertiesEncoded(this.yarnClusterDescriptor.getDynamicPropertiesEncoded().replace(APPID_PLACEHOLDER, id));
        }
    }

    private void checkAmResourceRequest(GetNewApplicationResponse appResponse) {
        int maxVcores;
        int maxMem = appResponse.getMaximumResourceCapability().getMemory();
        if (this.amMemory > maxMem) {
            logger.log(Level.WARNING, "AM memory specified above max threshold of cluster. Using max value. Specified: {0}, max: {1}", new Object[]{this.amMemory, maxMem});
            this.amMemory = maxMem;
        }
        if (this.amVCores > (maxVcores = appResponse.getMaximumResourceCapability().getVirtualCores())) {
            logger.log(Level.WARNING, "AM vcores specified above max threshold of cluster. Using max value. Specified: {0}, max: {1}", new Object[]{this.amVCores, maxVcores});
            this.amVCores = maxVcores;
        }
    }

    private Map<String, LocalResource> addAllToLocalResources() throws IOException, URISyntaxException {
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        DistributedFileSystem fs = this.dfsClient.getFilesystem();
        String hdfsPrefix = this.conf.get("fs.defaultFS");
        String basePath = hdfsPrefix + this.localResourcesBasePath;
        logger.log(Level.FINER, "Base path: {0}", basePath);
        for (Map.Entry<String, LocalResourceDTO> entry : this.amLocalResourcesOnHDFS.entrySet()) {
            logger.log(Level.FINE, "LocalResourceDTO to upload is :{0}", entry.toString());
            String key = entry.getKey();
            String pathToResource = entry.getValue().getPath();
            pathToResource = pathToResource.replaceFirst("hdfs:/*Projects", "hdfs:///Projects");
            pathToResource = pathToResource.replaceFirst("hdfs:/*user", "hdfs:///user");
            Path src = new Path(pathToResource);
            FileStatus scFileStat = fs.getFileStatus(src);
            LocalResource scRsrc = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)src), (LocalResourceType)LocalResourceType.valueOf((String)entry.getValue().getType().toUpperCase()), (LocalResourceVisibility)LocalResourceVisibility.valueOf((String)entry.getValue().getVisibility().toUpperCase()), (long)scFileStat.getLen(), (long)scFileStat.getModificationTime(), (String)entry.getValue().getPattern());
            localResources.put(key, scRsrc);
        }
        if (this.jobType == JobType.SPARK || this.jobType == JobType.PYSPARK) {
            StringBuilder uris = new StringBuilder();
            StringBuilder timestamps = new StringBuilder();
            StringBuilder sizes = new StringBuilder();
            StringBuilder visibilities = new StringBuilder();
            StringBuilder types = new StringBuilder();
            for (Map.Entry entry : localResources.entrySet()) {
                Path destPath = ConverterUtils.getPathFromYarnURL((URL)((LocalResource)entry.getValue()).getResource());
                URI sparkUri = destPath.toUri();
                URI pathURI = new URI(sparkUri.getScheme(), sparkUri.getAuthority(), sparkUri.getPath(), null, (String)entry.getKey());
                uris.append(pathURI.toString()).append(",");
                timestamps.append(((LocalResource)entry.getValue()).getTimestamp()).append(",");
                sizes.append(((LocalResource)entry.getValue()).getSize()).append(",");
                visibilities.append(((LocalResource)entry.getValue()).getVisibility()).append(",");
                types.append(((LocalResource)entry.getValue()).getType()).append(",");
            }
            this.javaOptions.add(YarnRunner.escapeForShell("-Dspark.yarn.cache.filenames=" + uris.substring(0, uris.length() - 1)));
            this.javaOptions.add(YarnRunner.escapeForShell("-Dspark.yarn.cache.timestamps=" + timestamps.substring(0, timestamps.length() - 1)));
            this.javaOptions.add(YarnRunner.escapeForShell("-Dspark.yarn.cache.sizes=" + sizes.substring(0, sizes.length() - 1)));
            this.javaOptions.add(YarnRunner.escapeForShell("-Dspark.yarn.cache.visibilities=" + visibilities.substring(0, visibilities.length() - 1)));
            this.javaOptions.add(YarnRunner.escapeForShell("-Dspark.yarn.cache.types=" + types.substring(0, types.length() - 1)));
        }
        return localResources;
    }

    private void copyAllToHDFS() throws IOException {
        DistributedFileSystem fs = this.dfsClient.getFilesystem();
        String hdfsPrefix = this.conf.get("fs.defaultFS");
        String basePath = hdfsPrefix + this.localResourcesBasePath;
        for (String path : this.filesToBeCopied) {
            String destination = basePath + File.separator + Utils.getFileName(path);
            Path dst = new Path(destination);
            if (!path.startsWith(fs.getScheme()) && !path.startsWith(fs.getAlternativeScheme())) {
                String dirPart = Utils.getDirectoryPart(path);
                String filename = Utils.getFileName(path);
                String crcName = dirPart + "." + filename + ".crc";
                Files.deleteIfExists(Paths.get(crcName, new String[0]));
                fs.copyFromLocalFile(new Path(path), dst);
            } else {
                Path srcPath = new Path(path);
                Path[] srcs = FileUtil.stat2Paths((FileStatus[])fs.globStatus(srcPath), (Path)srcPath);
                if (srcs.length > 1 && !fs.isDirectory(dst)) {
                    throw new IOException("When copying multiple files, destination should be a directory.");
                }
                for (Path src1 : srcs) {
                    FileUtil.copy((FileSystem)fs, (Path)src1, (FileSystem)fs, (Path)dst, (boolean)false, (Configuration)this.conf);
                }
            }
            logger.log(Level.INFO, "Copying from: {0} to: {1}", new Object[]{path, dst});
        }
    }

    private void setUpClassPath(Map<String, String> env) throws InterruptedException, IOException {
        StringBuilder classPathEnv = new StringBuilder();
        for (String c : this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            classPathEnv.append(":").append(c.trim());
        }
        if (this.conf.getBoolean("yarn.is.minicluster", false)) {
            classPathEnv.append(':');
            classPathEnv.append(System.getProperty("java.class.path"));
        }
        String hadoopDir = this.services.getSettings().getHadoopSymbolicLinkDir();
        classPathEnv.append(this.services.getSettings().getHadoopClasspathGlob());
        if (env.containsKey(KEY_CLASSPATH)) {
            String clpth = env.get(KEY_CLASSPATH) + ":" + classPathEnv.toString();
            env.put(KEY_CLASSPATH, clpth);
        } else {
            env.put(KEY_CLASSPATH, classPathEnv.toString());
        }
        env.put("HADOOP_HOME", hadoopDir);
        env.put("HADOOP_COMMON_HOME", hadoopDir);
        env.put("HADOOP_CONF_DIR", this.services.getSettings().getHadoopConfDir(hadoopDir));
        env.put("HADOOP_HDFS_HOME", hadoopDir);
        env.put("HADOOP_YARN_HOME", hadoopDir);
    }

    private List<String> setUpCommands() {
        ArrayList<String> vargs = new ArrayList<String>();
        logger.info("Setting up app master command");
        vargs.add(ApplicationConstants.Environment.JAVA_HOME.$() + "/bin/java");
        vargs.add("-Xmx" + this.amMemory + "M");
        for (String string : this.javaOptions) {
            vargs.add(string);
        }
        vargs.add(this.amMainClass);
        vargs.add(this.amArgs);
        vargs.add("1> ");
        vargs.add("<LOG_DIR>/stdout");
        vargs.add("2> ");
        vargs.add("<LOG_DIR>/stderr");
        StringBuilder amcommand = new StringBuilder();
        for (CharSequence charSequence : vargs) {
            amcommand.append(charSequence).append(" ");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(amcommand.toString());
        return arrayList;
    }

    private YarnRunner(Builder builder) {
        this.jobType = builder.jobType;
        this.yarnClusterDescriptor = builder.flinkCluster;
        this.clusterSpecification = builder.flinkClusterSpecification;
        this.amQueue = builder.amQueue;
        this.amMemory = builder.amMemory;
        this.amVCores = builder.amVCores;
        this.appName = builder.appName;
        this.amMainClass = builder.amMainClass;
        this.amArgs = builder.amArgs;
        this.amLocalResourcesOnHDFS = builder.amLocalResourcesOnHDFS;
        this.amEnvironment = builder.amEnvironment;
        this.localResourcesBasePath = builder.localResourcesBasePath;
        this.yarnClient = builder.yarnClient;
        this.dfsClient = builder.dfsClient;
        this.conf = builder.conf;
        this.filesToBeCopied = builder.filesToBeCopied;
        this.commands = builder.commands;
        this.javaOptions = builder.javaOptions;
        this.filesToRemove = builder.filesToRemove;
        this.serviceDir = builder.serviceDir;
        this.services = builder.services;
    }

    public String getAmArgs() {
        return this.amArgs;
    }

    public String getLocalResourcesBasePath() {
        return this.localResourcesBasePath;
    }

    public List<String> getFilesToRemove() {
        return this.filesToRemove;
    }

    public void cancelJob(String appid) throws YarnException, IOException {
        ApplicationId applicationId = ConverterUtils.toApplicationId((String)appid);
        this.yarnClient.killApplication(applicationId);
    }

    public String toString() {
        if (!this.readyToSubmit) {
            return "YarnRunner: application context not requested yet.";
        }
        return "YarnRunner, ApplicationSubmissionContext: " + this.appContext;
    }

    private static InetSocketAddress getInetFromHostport(String hostport) {
        URI uri;
        try {
            uri = new URI("my://" + hostport);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not identify hostname and port in '" + hostport + "'.", e);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (host == null || port == -1) {
            throw new RuntimeException("Could not identify hostname and port in '" + hostport + "'.");
        }
        return new InetSocketAddress(host, port);
    }

    public static final class Builder {
        private String amMainClass;
        private JobType jobType;
        private YarnClusterDescriptor flinkCluster;
        private String amQueue = "default";
        private int amMemory = 1024;
        private int amVCores = 1;
        private String appName = "Hopsworks-Yarn";
        private String amArgs;
        private Map<String, LocalResourceDTO> amLocalResourcesOnHDFS = new HashMap<String, LocalResourceDTO>();
        private Map<String, String> amEnvironment = new HashMap<String, String>();
        private String localResourcesBasePath;
        private boolean shouldAddAmJarToLocalResources = true;
        private List<String> filesToBeCopied = new ArrayList<String>();
        private List<YarnSetupCommand> commands = new ArrayList<YarnSetupCommand>();
        private List<String> javaOptions = new ArrayList<String>();
        private List<String> filesToRemove = new ArrayList<String>();
        private Configuration conf;
        private YarnClient yarnClient;
        private DistributedFileSystemOps dfsClient;
        private String serviceDir;
        private AsynchronousJobExecutor services;
        private ClusterSpecification flinkClusterSpecification;

        public Builder(String amMainClass) {
            this.amMainClass = amMainClass;
        }

        public Builder setDfsClient(DistributedFileSystemOps dfsClient) {
            this.dfsClient = dfsClient;
            return this;
        }

        public Builder setYarnClient(YarnClient yarnClient) {
            this.yarnClient = yarnClient;
            return this;
        }

        public Builder amArgs(String amArgs) {
            this.amArgs = amArgs;
            return this;
        }

        public Builder amMemory(int amMem) {
            this.amMemory = amMem;
            return this;
        }

        public Builder amVCores(int amVCores) {
            this.amVCores = amVCores;
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder amQueue(String queuename) {
            this.amQueue = queuename;
            return this;
        }

        public void setJobType(JobType jobType) {
            this.jobType = jobType;
        }

        public void setFlinkCluster(YarnClusterDescriptor flinkCluster) {
            this.flinkCluster = flinkCluster;
        }

        public void setFlinkClusterSpecification(ClusterSpecification flinkClusterSpecification) {
            this.flinkClusterSpecification = flinkClusterSpecification;
        }

        public Builder setConfig(YarnJobConfiguration config) {
            this.amQueue = config.getAmQueue();
            this.amMemory = config.getAmMemory();
            this.amVCores = config.getAmVCores();
            this.appName = config.getAppName();
            return this;
        }

        public Builder localResourcesBasePath(String basePath) {
            while (basePath.endsWith(File.separator)) {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            if (!basePath.startsWith("/")) {
                basePath = "/" + basePath;
            }
            this.localResourcesBasePath = basePath;
            return this;
        }

        public Builder addLocalResource(LocalResourceDTO dto, DistributedFileSystemOps dfsClient) {
            if (!dto.getPath().startsWith(dfsClient.getFilesystem().getScheme()) && !dto.getPath().startsWith(dfsClient.getFilesystem().getAlternativeScheme())) {
                throw new IllegalArgumentException("Dependencies need to be stored in Datasets, local file system is not supported");
            }
            this.amLocalResourcesOnHDFS.put(dto.getName(), dto);
            return this;
        }

        public void addFileToRemove(String path) {
            this.filesToRemove.add(path);
        }

        public Builder addToAppMasterEnvironment(String key, String value) {
            if (this.amEnvironment.containsKey(key)) {
                this.amEnvironment.put(key, this.amEnvironment.get(key) + ":" + value);
            } else {
                this.amEnvironment.put(key, value);
            }
            return this;
        }

        public Builder addAllToAppMasterEnvironment(Map<String, String> env) {
            this.amEnvironment.putAll(env);
            return this;
        }

        public Builder addCommand(YarnSetupCommand c) {
            this.commands.add(c);
            return this;
        }

        public Builder addJavaOption(String option) {
            this.javaOptions.add(option);
            return this;
        }

        public YarnRunner build(String serviceDir, JobType jobType, AsynchronousJobExecutor services) throws IllegalStateException, IOException {
            try {
                this.services = services;
                this.conf = services.getSettings().getConfiguration();
                this.serviceDir = serviceDir;
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Failed to load configuration", e);
            }
            if (this.yarnClient == null) {
                this.yarnClient = YarnClient.createYarnClient();
                this.yarnClient.init(this.conf);
            }
            if (this.amMainClass == null) {
                throw new IllegalStateException("Could not infer main class name from jar and was not specified.");
            }
            if (this.localResourcesBasePath == null) {
                this.localResourcesBasePath = File.separator + YarnRunner.APPID_PLACEHOLDER;
            }
            return new YarnRunner(this);
        }
    }
}

