/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.util.ConfigurationUtil;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.templates.ConfigProperty;
import io.hops.hopsworks.common.util.templates.ConfigReplacementPolicy;
import io.hops.hopsworks.persistence.entity.jobs.configuration.DistributionStrategy;
import io.hops.hopsworks.persistence.entity.jobs.configuration.ExperimentType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.spark.SparkJobConfiguration;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SparkConfigurationUtil
extends ConfigurationUtil {
    @Override
    public Map<String, String> setFrameworkProperties(Project project, JobConfiguration jobConfiguration, Settings settings, String hdfsUser, Map<String, String> extraJavaOptions, String kafkaBrokersString, String hopsworksRestEndpoint, ServiceDiscoveryController serviceDiscoveryController) throws IOException, ServiceDiscoveryException {
        String applicationPyFiles;
        String applicationFiles;
        String applicationArchives;
        SparkJobConfiguration sparkJobConfiguration = (SparkJobConfiguration)jobConfiguration;
        ExperimentType experimentType = sparkJobConfiguration.getExperimentType();
        DistributionStrategy distributionStrategy = sparkJobConfiguration.getDistributionStrategy();
        String userSparkProperties = sparkJobConfiguration.getProperties();
        HashMap<String, ConfigProperty> sparkProps = new HashMap<String, ConfigProperty>();
        if (jobConfiguration.getAppName() != null) {
            sparkProps.put("spark.app.name", new ConfigProperty("spark.app.name", HopsUtils.OVERWRITE, sparkJobConfiguration.getAppName()));
        }
        if (sparkJobConfiguration.getJobType() != null && sparkJobConfiguration.getJobType() == JobType.PYSPARK) {
            sparkProps.put("spark.yarn.isPython", new ConfigProperty("spark.yarn.isPython", HopsUtils.OVERWRITE, "true"));
        }
        sparkProps.put("spark.yarn.appMasterEnv.YARN_CONTAINER_RUNTIME_TYPE", new ConfigProperty("spark.yarn.appMasterEnv.YARN_CONTAINER_RUNTIME_TYPE", HopsUtils.OVERWRITE, settings.getYarnRuntime()));
        sparkProps.put("spark.yarn.appMasterEnv.YARN_CONTAINER_RUNTIME_DOCKER_IMAGE", new ConfigProperty("spark.yarn.appMasterEnv.YARN_CONTAINER_RUNTIME_DOCKER_IMAGE", HopsUtils.OVERWRITE, ProjectUtils.getFullDockerImageName(project, settings, serviceDiscoveryController, false)));
        sparkProps.put("spark.yarn.appMasterEnv.YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS", new ConfigProperty("spark.yarn.appMasterEnv.YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS", HopsUtils.OVERWRITE, settings.getDockerMounts()));
        sparkProps.put("spark.executorEnv.YARN_CONTAINER_RUNTIME_TYPE", new ConfigProperty("spark.executorEnv.YARN_CONTAINER_RUNTIME_TYPE", HopsUtils.OVERWRITE, settings.getYarnRuntime()));
        sparkProps.put("spark.executorEnv.YARN_CONTAINER_RUNTIME_DOCKER_IMAGE", new ConfigProperty("spark.executorEnv.YARN_CONTAINER_RUNTIME_DOCKER_IMAGE", HopsUtils.OVERWRITE, ProjectUtils.getFullDockerImageName(project, settings, serviceDiscoveryController, false)));
        sparkProps.put("spark.executorEnv.YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS", new ConfigProperty("spark.executorEnv.YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS", HopsUtils.OVERWRITE, settings.getDockerMounts()));
        sparkProps.put("spark.hadoop.fs.permissions.umask-mode", new ConfigProperty("spark.hadoop.fs.permissions.umask-mode", HopsUtils.OVERWRITE, "0007"));
        sparkProps.put("spark.pyspark.python", new ConfigProperty("spark.pyspark.python", HopsUtils.IGNORE, settings.getAnacondaProjectDir() + "/bin/python"));
        sparkProps.put("spark.yarn.appMasterEnv.CUDA_VISIBLE_DEVICES", new ConfigProperty("spark.yarn.appMasterEnv.CUDA_VISIBLE_DEVICES", HopsUtils.IGNORE, ""));
        sparkProps.put("spark.yarn.appMasterEnv.HIP_VISIBLE_DEVICES", new ConfigProperty("spark.yarn.appMasterEnv.HIP_VISIBLE_DEVICES", HopsUtils.IGNORE, "-1"));
        sparkProps.put("spark.yarn.appMasterEnv.EXECUTOR_GPUS", new ConfigProperty("spark.yarn.appMasterEnv.EXECUTOR_GPUS", HopsUtils.IGNORE, "0"));
        sparkProps.put("spark.executorEnv.EXECUTOR_GPUS", new ConfigProperty("spark.executorEnv.EXECUTOR_GPUS", HopsUtils.IGNORE, Integer.toString(sparkJobConfiguration.getExecutorGpus())));
        sparkProps.put("spark.submit.deployMode", new ConfigProperty("spark.submit.deployMode", HopsUtils.OVERWRITE, "cluster"));
        if (experimentType != null) {
            if (sparkJobConfiguration.getExecutorGpus() == 0) {
                this.addToSparkEnvironment(sparkProps, "HIP_VISIBLE_DEVICES", "-1", HopsUtils.IGNORE);
                this.addToSparkEnvironment(sparkProps, "CUDA_VISIBLE_DEVICES", "", HopsUtils.IGNORE);
            }
            if (sparkJobConfiguration.getExecutorGpus() > 0) {
                sparkProps.put("spark.executor.gpus", new ConfigProperty("spark.executor.gpus", HopsUtils.OVERWRITE, Integer.toString(sparkJobConfiguration.getExecutorGpus())));
                sparkProps.put("spark.tensorflow.application", new ConfigProperty("spark.tensorflow.application", HopsUtils.OVERWRITE, "true"));
            } else {
                sparkProps.put("spark.tensorflow.application", new ConfigProperty("spark.tensorflow.application", HopsUtils.OVERWRITE, "false"));
            }
        }
        this.addToSparkEnvironment(sparkProps, "SPARK_HOME", settings.getSparkDir(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "SPARK_CONF_DIR", settings.getSparkConfDir(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "ELASTIC_ENDPOINT", settings.getElasticRESTEndpoint(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "HADOOP_VERSION", settings.getHadoopVersion(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "HOPSWORKS_VERSION", settings.getHopsworksVersion(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "TENSORFLOW_VERSION", settings.getTensorflowVersion(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "KAFKA_VERSION", settings.getKafkaVersion(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "SPARK_VERSION", settings.getSparkVersion(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "LIVY_VERSION", settings.getLivyVersion(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "HADOOP_HOME", settings.getHadoopSymbolicLinkDir(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "HADOOP_HDFS_HOME", settings.getHadoopSymbolicLinkDir(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "HADOOP_USER_NAME", hdfsUser, HopsUtils.IGNORE);
        if (!Strings.isNullOrEmpty((String)sparkJobConfiguration.getAppName())) {
            this.addToSparkEnvironment(sparkProps, "HOPSWORKS_JOB_NAME", sparkJobConfiguration.getAppName(), HopsUtils.IGNORE);
        }
        if (!Strings.isNullOrEmpty((String)kafkaBrokersString)) {
            this.addToSparkEnvironment(sparkProps, "KAFKA_BROKERS", kafkaBrokersString, HopsUtils.IGNORE);
        }
        this.addToSparkEnvironment(sparkProps, "REST_ENDPOINT", hopsworksRestEndpoint, HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "PYSPARK_PYTHON", settings.getAnacondaProjectDir() + "/bin/python", HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "HOPSWORKS_PROJECT_ID", Integer.toString(project.getId()), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "FLINK_CONF_DIR", settings.getFlinkConfDir(), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "REQUESTS_VERIFY", String.valueOf(settings.getRequestsVerify()), HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "DOMAIN_CA_TRUSTSTORE", "t_certificate", HopsUtils.IGNORE);
        this.addToSparkEnvironment(sparkProps, "SERVICE_DISCOVERY_DOMAIN", settings.getServiceDiscoveryDomain(), HopsUtils.IGNORE);
        this.addLibHdfsOpts(userSparkProperties, settings, sparkProps, sparkJobConfiguration);
        sparkProps.put("spark.dynamicAllocation.enabled", new ConfigProperty("spark.dynamicAllocation.enabled", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.isDynamicAllocationEnabled() || experimentType != null)));
        if (experimentType != null) {
            sparkProps.put("spark.shuffle.service.enabled", new ConfigProperty("spark.shuffle.service.enabled", HopsUtils.OVERWRITE, "true"));
            if (experimentType == ExperimentType.DISTRIBUTED_TRAINING) {
                if (distributionStrategy == DistributionStrategy.MULTI_WORKER_MIRRORED) {
                    sparkProps.put("spark.dynamicAllocation.minExecutors", new ConfigProperty("spark.dynamicAllocation.minExecutors", HopsUtils.OVERWRITE, "0"));
                    sparkProps.put("spark.dynamicAllocation.maxExecutors", new ConfigProperty("spark.dynamicAllocation.maxExecutors", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.getDynamicAllocationMaxExecutors())));
                    sparkProps.put("spark.dynamicAllocation.initialExecutors", new ConfigProperty("spark.dynamicAllocation.initialExecutors", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.getDynamicAllocationMaxExecutors())));
                } else if (distributionStrategy == DistributionStrategy.PARAMETER_SERVER) {
                    sparkProps.put("spark.tensorflow.num.ps", new ConfigProperty("spark.tensorflow.num.ps", HopsUtils.OVERWRITE, Integer.toString(sparkJobConfiguration.getNumPs())));
                    sparkProps.put("spark.dynamicAllocation.minExecutors", new ConfigProperty("spark.dynamicAllocation.minExecutors", HopsUtils.OVERWRITE, "0"));
                    sparkProps.put("spark.dynamicAllocation.maxExecutors", new ConfigProperty("spark.dynamicAllocation.maxExecutors", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.getDynamicAllocationMaxExecutors() + sparkJobConfiguration.getNumPs())));
                    sparkProps.put("spark.dynamicAllocation.initialExecutors", new ConfigProperty("spark.dynamicAllocation.initialExecutors", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.getDynamicAllocationMaxExecutors() + sparkJobConfiguration.getNumPs())));
                }
                this.addToSparkEnvironment(sparkProps, "NCCL_SOCKET_NTHREADS", "2", HopsUtils.OVERWRITE);
                this.addToSparkEnvironment(sparkProps, "NCCL_NSOCKS_PERTHREAD", "8", HopsUtils.OVERWRITE);
            } else if (experimentType == ExperimentType.PARALLEL_EXPERIMENTS) {
                sparkProps.put("spark.dynamicAllocation.minExecutors", new ConfigProperty("spark.dynamicAllocation.minExecutors", HopsUtils.OVERWRITE, "0"));
                sparkProps.put("spark.dynamicAllocation.maxExecutors", new ConfigProperty("spark.dynamicAllocation.maxExecutors", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.getDynamicAllocationMaxExecutors())));
                sparkProps.put("spark.dynamicAllocation.initialExecutors", new ConfigProperty("spark.dynamicAllocation.initialExecutors", HopsUtils.OVERWRITE, "0"));
            } else {
                sparkProps.put("spark.dynamicAllocation.minExecutors", new ConfigProperty("spark.dynamicAllocation.minExecutors", HopsUtils.OVERWRITE, "0"));
                sparkProps.put("spark.dynamicAllocation.maxExecutors", new ConfigProperty("spark.dynamicAllocation.maxExecutors", HopsUtils.OVERWRITE, "1"));
                sparkProps.put("spark.dynamicAllocation.initialExecutors", new ConfigProperty("spark.dynamicAllocation.initialExecutors", HopsUtils.OVERWRITE, "0"));
            }
        } else if (sparkJobConfiguration.isDynamicAllocationEnabled()) {
            sparkProps.put("spark.shuffle.service.enabled", new ConfigProperty("spark.shuffle.service.enabled", HopsUtils.OVERWRITE, "true"));
            if (sparkJobConfiguration.getDynamicAllocationInitialExecutors() > sparkJobConfiguration.getDynamicAllocationMaxExecutors()) {
                sparkProps.put("spark.dynamicAllocation.initialExecutors", new ConfigProperty("spark.dynamicAllocation.initialExecutors", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.getDynamicAllocationMaxExecutors())));
            } else if (sparkJobConfiguration.getDynamicAllocationInitialExecutors() < sparkJobConfiguration.getDynamicAllocationMinExecutors()) {
                sparkProps.put("spark.dynamicAllocation.initialExecutors", new ConfigProperty("spark.dynamicAllocation.initialExecutors", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.getDynamicAllocationMinExecutors())));
            } else {
                sparkProps.put("spark.dynamicAllocation.initialExecutors", new ConfigProperty("spark.dynamicAllocation.initialExecutors", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.getDynamicAllocationInitialExecutors())));
            }
            sparkProps.put("spark.dynamicAllocation.minExecutors", new ConfigProperty("spark.dynamicAllocation.minExecutors", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.getDynamicAllocationMinExecutors())));
            sparkProps.put("spark.dynamicAllocation.maxExecutors", new ConfigProperty("spark.dynamicAllocation.maxExecutors", HopsUtils.OVERWRITE, String.valueOf(sparkJobConfiguration.getDynamicAllocationMaxExecutors())));
            sparkProps.put("spark.executor.instances", new ConfigProperty("spark.executor.instances", HopsUtils.OVERWRITE, Integer.toString(sparkJobConfiguration.getDynamicAllocationMinExecutors())));
        } else {
            sparkProps.put("spark.executor.instances", new ConfigProperty("spark.executor.instances", HopsUtils.OVERWRITE, Integer.toString(sparkJobConfiguration.getExecutorInstances())));
        }
        sparkProps.put("spark.driver.memory", new ConfigProperty("spark.driver.memory", HopsUtils.OVERWRITE, sparkJobConfiguration.getAmMemory() + "m"));
        sparkProps.put("spark.driver.cores", new ConfigProperty("spark.driver.cores", HopsUtils.OVERWRITE, Integer.toString(experimentType != null ? 1 : sparkJobConfiguration.getExecutorCores())));
        sparkProps.put("spark.executor.memory", new ConfigProperty("spark.executor.memory", HopsUtils.OVERWRITE, sparkJobConfiguration.getExecutorMemory() + "m"));
        sparkProps.put("spark.executor.cores", new ConfigProperty("spark.executor.cores", HopsUtils.OVERWRITE, Integer.toString(experimentType != null ? 1 : sparkJobConfiguration.getExecutorCores())));
        StringBuilder sparkFiles = new StringBuilder();
        sparkFiles.append(settings.getSparkMetricsPath()).append(",").append(settings.getSparkLog4JPath()).append(",").append(settings.getHiveSiteSparkHdfsPath());
        StringBuilder extraClassPath = new StringBuilder();
        extraClassPath.append("{{PWD}}").append(File.pathSeparator).append(settings.getSparkDir()).append("/jars/*").append(File.pathSeparator).append(settings.getSparkDir()).append("/hopsworks-jars/*");
        String applicationsJars = sparkJobConfiguration.getJars();
        if (!Strings.isNullOrEmpty((String)applicationsJars)) {
            applicationsJars = this.formatResources(applicationsJars);
            for (String jar : applicationsJars.split(",")) {
                String[] name = jar.substring(jar.lastIndexOf("/") + 1);
                extraClassPath.append(File.pathSeparator).append((String)name);
            }
            applicationsJars = this.formatResources(applicationsJars);
            sparkFiles.append(",").append(applicationsJars);
        }
        if (!Strings.isNullOrEmpty((String)(applicationArchives = sparkJobConfiguration.getArchives()))) {
            applicationArchives = this.formatResources(applicationArchives);
            sparkProps.put("spark.yarn.dist.archives", new ConfigProperty("spark.yarn.dist.archives", HopsUtils.APPEND_COMMA, applicationArchives));
        }
        if (!settings.getHopsRpcTls()) {
            sparkFiles.append(",hdfs://").append(settings.getHdfsTmpCertDir()).append(File.separator).append(hdfsUser).append(File.separator).append(hdfsUser).append("__kstore.jks#").append("k_certificate").append(",").append("hdfs://").append(settings.getHdfsTmpCertDir()).append(File.separator).append(hdfsUser).append(File.separator).append(hdfsUser).append("__tstore.jks#").append("t_certificate").append(",").append("hdfs://").append(settings.getHdfsTmpCertDir()).append(File.separator).append(hdfsUser).append(File.separator).append(hdfsUser).append("__cert.key#").append("material_passwd");
        }
        if (!Strings.isNullOrEmpty((String)(applicationFiles = sparkJobConfiguration.getFiles()))) {
            applicationFiles = this.formatResources(applicationFiles);
            sparkFiles.append(",").append(applicationFiles);
        }
        if (!Strings.isNullOrEmpty((String)(applicationPyFiles = sparkJobConfiguration.getPyFiles()))) {
            StringBuilder pythonPath = new StringBuilder();
            applicationPyFiles = this.formatResources(applicationPyFiles);
            for (String pythonDep : applicationPyFiles.split(",")) {
                String name = pythonDep.substring(pythonDep.lastIndexOf("/") + 1);
                pythonPath.append("{{PWD}}/" + name + File.pathSeparator);
            }
            this.addToSparkEnvironment(sparkProps, "PYTHONPATH", pythonPath.toString(), HopsUtils.APPEND_PATH);
            sparkFiles.append(",").append(applicationPyFiles);
        }
        applicationFiles = this.formatResources(sparkFiles.toString());
        sparkProps.put("spark.yarn.dist.files", new ConfigProperty("spark.yarn.dist.files", HopsUtils.APPEND_COMMA, applicationFiles));
        sparkProps.put("spark.driver.extraClassPath", new ConfigProperty("spark.driver.extraClassPath", HopsUtils.APPEND_PATH, extraClassPath.toString()));
        sparkProps.put("spark.executor.extraClassPath", new ConfigProperty("spark.executor.extraClassPath", HopsUtils.APPEND_PATH, extraClassPath.toString()));
        if (experimentType == ExperimentType.DISTRIBUTED_TRAINING) {
            sparkProps.put("spark.blacklist.enabled", new ConfigProperty("spark.blacklist.enabled", HopsUtils.OVERWRITE, "false"));
        } else if (sparkJobConfiguration.isBlacklistingEnabled()) {
            sparkProps.put("spark.blacklist.enabled", new ConfigProperty("spark.blacklist.enabled", HopsUtils.OVERWRITE, Boolean.toString(sparkJobConfiguration.isBlacklistingEnabled())));
            sparkProps.put("spark.blacklist.task.maxTaskAttemptsPerExecutor", new ConfigProperty("spark.blacklist.task.maxTaskAttemptsPerExecutor", HopsUtils.OVERWRITE, "1"));
            sparkProps.put("spark.blacklist.task.maxTaskAttemptsPerNode", new ConfigProperty("spark.blacklist.task.maxTaskAttemptsPerNode", HopsUtils.OVERWRITE, "2"));
            sparkProps.put("spark.blacklist.stage.maxFailedTasksPerExecutor", new ConfigProperty("spark.blacklist.stage.maxFailedTasksPerExecutor", HopsUtils.OVERWRITE, "1"));
            sparkProps.put("spark.blacklist.stage.maxFailedExecutorsPerNode", new ConfigProperty("spark.blacklist.stage.maxFailedExecutorsPerNode", HopsUtils.OVERWRITE, "2"));
            sparkProps.put("spark.blacklist.application.maxFailedTasksPerExecutor", new ConfigProperty("spark.blacklist.application.maxFailedTasksPerExecutor", HopsUtils.OVERWRITE, "1"));
            sparkProps.put("spark.blacklist.application.maxFailedExecutorsPerNode", new ConfigProperty("spark.blacklist.application.maxFailedExecutorsPerNode", HopsUtils.OVERWRITE, "2"));
            sparkProps.put("spark.blacklist.killBlacklistedExecutors", new ConfigProperty("spark.blacklist.killBlacklistedExecutors", HopsUtils.OVERWRITE, "true"));
        }
        if (experimentType != null) {
            if (sparkJobConfiguration.isBlacklistingEnabled() && (experimentType == ExperimentType.EXPERIMENT || experimentType == ExperimentType.PARALLEL_EXPERIMENTS)) {
                sparkProps.put("spark.task.maxFailures", new ConfigProperty("spark.task.maxFailures", HopsUtils.OVERWRITE, "3"));
            } else {
                sparkProps.put("spark.task.maxFailures", new ConfigProperty("spark.task.maxFailures", HopsUtils.OVERWRITE, "1"));
            }
        }
        extraJavaOptions.put("log4j.configuration", "log4j.properties");
        extraJavaOptions.put("hopsworks.restendpoint", hopsworksRestEndpoint);
        extraJavaOptions.put("hopsutil.insecure", String.valueOf(settings.isHopsUtilInsecure()));
        extraJavaOptions.put("server.truststore", "server.truststore");
        extraJavaOptions.put("hopsworks.elastic.endpoint", settings.getElasticRESTEndpoint());
        extraJavaOptions.put("hopsworks.projectid", Integer.toString(project.getId()));
        extraJavaOptions.put("hopsworks.projectname", project.getName());
        extraJavaOptions.put("java.library.path", settings.getHadoopSymbolicLinkDir() + "/lib/native/");
        extraJavaOptions.put("hopsworks.projectuser", hdfsUser);
        extraJavaOptions.put("hopsworks.kafka.brokeraddress", kafkaBrokersString);
        extraJavaOptions.put("hopsworks.job.type", JobType.SPARK.name());
        extraJavaOptions.put("hopsworks.domain.truststore", "t_certificate");
        if (jobConfiguration.getAppName() != null) {
            extraJavaOptions.put("hopsworks.job.name", jobConfiguration.getAppName());
        }
        StringBuilder extraJavaOptionsSb = new StringBuilder();
        for (String key : extraJavaOptions.keySet()) {
            extraJavaOptionsSb.append(" -D").append(key).append("=").append(extraJavaOptions.get(key));
        }
        sparkProps.put("spark.executor.extraJavaOptions", new ConfigProperty("spark.executor.extraJavaOptions", HopsUtils.APPEND_SPACE, extraJavaOptionsSb.toString()));
        sparkProps.put("spark.driver.extraJavaOptions", new ConfigProperty("spark.driver.extraJavaOptions", HopsUtils.APPEND_SPACE, extraJavaOptionsSb.toString()));
        Map<String, String> validatedSparkProperties = HopsUtils.validateUserProperties(userSparkProperties, settings.getSparkDir());
        return HopsUtils.mergeHopsworksAndUserParams(sparkProps, validatedSparkProperties);
    }

    private void addToSparkEnvironment(Map<String, ConfigProperty> sparkProps, String envName, String value, ConfigReplacementPolicy replacementPolicy) {
        sparkProps.put("spark.executorEnv." + envName, new ConfigProperty("spark.executorEnv." + envName, replacementPolicy, value));
        sparkProps.put("spark.yarn.appMasterEnv." + envName, new ConfigProperty("spark.yarn.appMasterEnv." + envName, replacementPolicy, value));
    }

    private void addLibHdfsOpts(String userSparkProperties, Settings settings, Map<String, ConfigProperty> sparkProps, SparkJobConfiguration sparkJobConfiguration) {
        String defaultLibHdfsOpts = "-Dlog4j.configuration=" + settings.getHadoopSymbolicLinkDir() + "/etc/hadoop/log4j.properties -Dhadoop.root.logger=ERROR,RFA";
        Map<String, String> userProperties = HopsUtils.parseUserProperties(userSparkProperties);
        if (userProperties.containsKey("spark.yarn.appMasterEnv.LIBHDFS_OPTS")) {
            sparkProps.put("spark.yarn.appMasterEnv.LIBHDFS_OPTS", new ConfigProperty("spark.yarn.appMasterEnv.LIBHDFS_OPTS", HopsUtils.APPEND_SPACE, defaultLibHdfsOpts));
        } else {
            this.addDefaultXmx(sparkProps, "spark.yarn.appMasterEnv.", (int)((double)sparkJobConfiguration.getAmMemory() * 0.2), defaultLibHdfsOpts);
        }
        if (userProperties.containsKey("spark.executorEnv.LIBHDFS_OPTS")) {
            sparkProps.put("spark.executorEnv.LIBHDFS_OPTS", new ConfigProperty("spark.executorEnv.LIBHDFS_OPTS", HopsUtils.APPEND_SPACE, defaultLibHdfsOpts));
        } else {
            this.addDefaultXmx(sparkProps, "spark.executorEnv.", (int)((double)sparkJobConfiguration.getExecutorMemory() * 0.2), defaultLibHdfsOpts);
        }
    }

    private void addDefaultXmx(Map<String, ConfigProperty> sparkProps, String property, int xmxValue, String defaultLibHdfsOpts) {
        sparkProps.put(property + "LIBHDFS_OPTS", new ConfigProperty(property + "LIBHDFS_OPTS", HopsUtils.IGNORE, defaultLibHdfsOpts + " -Xmx" + xmxValue + "m"));
    }

    private String formatResources(String commaSeparatedResources) {
        String[] resourceArr = commaSeparatedResources.split(",");
        StringBuilder resourceBuilder = new StringBuilder();
        for (String resource : resourceArr) {
            if (resource.equals(",") || resource.equals("")) continue;
            resourceBuilder.append(resource.trim()).append(",");
        }
        if (resourceBuilder.charAt(resourceBuilder.length() - 1) == ',') {
            resourceBuilder.deleteCharAt(resourceBuilder.length() - 1);
        }
        return resourceBuilder.toString();
    }
}

