/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hdfs;

import io.hops.hopsworks.common.dao.hdfsUser.HdfsGroupsFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.FsPermissions;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.dataset.PermissionTransition;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsGroups;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.security.UserAlreadyInGroupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class HdfsUsersController {
    public static final String USER_NAME_DELIMITER = "__";
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private HdfsGroupsFacade hdfsGroupsFacade;
    @EJB
    private DistributedFsService dfsService;

    public void addProjectFolderOwner(Project project, DistributedFileSystemOps dfso) throws IOException {
        String owner = this.getHdfsUserName(project, project.getOwner());
        Path location = new Path(Utils.getProjectPath(project.getName()));
        dfso.setOwner(location, owner, project.getName());
        dfso.setPermission(location, FsPermissions.r_xr_xr_x);
        HdfsGroups projectGroup = this.hdfsGroupsFacade.findByName(project.getName());
        if (projectGroup == null) {
            throw new IllegalArgumentException("No group found for project in HDFS.");
        }
        this.addToGroup(owner, projectGroup.getName(), dfso);
    }

    public void createDatasetGroupsAndSetPermissions(Users owner, Project project, Dataset dataset, Path dsPath, DistributedFileSystemOps dfso) throws IOException {
        if (owner == null || project == null || project.getProjectTeamCollection() == null || dataset == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        String datasetGroup = this.getHdfsGroupName(project, dataset);
        String datasetAclGroup = this.getHdfsAclGroupName(project, dataset);
        String dsOwner = this.getHdfsUserName(project, owner);
        dfso.setOwner(dsPath, dsOwner, datasetGroup);
        dfso.addGroup(datasetAclGroup);
        dfso.setPermission(dsPath, this.getDatasetAcl(datasetAclGroup));
        HdfsGroups hdfsGroup = this.hdfsGroupsFacade.findByName(datasetGroup);
        if (hdfsGroup == null) {
            throw new IllegalArgumentException("Could not create dataset group in HDFS.");
        }
        String hdfsUsername = this.getHdfsUserName(project, owner);
        this.addToGroup(hdfsUsername, hdfsGroup.getName(), dfso);
        this.addMembersToGroups(datasetGroup, datasetAclGroup, dfso, project.getProjectTeamCollection(), dataset.getPermission());
    }

    private List<AclEntry> getDatasetAcl(String aclGroup) {
        ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
        AclEntry aclEntryUser = new AclEntry.Builder().setType(AclEntryType.USER).setScope(AclEntryScope.ACCESS).setPermission(FsAction.ALL).build();
        aclEntries.add(aclEntryUser);
        AclEntry aclEntryGroup = new AclEntry.Builder().setType(AclEntryType.GROUP).setScope(AclEntryScope.ACCESS).setPermission(FsAction.ALL).build();
        aclEntries.add(aclEntryGroup);
        AclEntry aclEntryDatasetGroup = new AclEntry.Builder().setType(AclEntryType.GROUP).setName(aclGroup).setScope(AclEntryScope.ACCESS).setPermission(FsAction.READ_EXECUTE).build();
        aclEntries.add(aclEntryDatasetGroup);
        AclEntry aclEntryOther = new AclEntry.Builder().setType(AclEntryType.OTHER).setScope(AclEntryScope.ACCESS).setPermission(FsAction.NONE).build();
        aclEntries.add(aclEntryOther);
        AclEntry aclEntryDefault = new AclEntry.Builder().setType(AclEntryType.GROUP).setName(aclGroup).setScope(AclEntryScope.DEFAULT).setPermission(FsAction.READ_EXECUTE).build();
        aclEntries.add(aclEntryDefault);
        return aclEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroups(List<HdfsGroups> hdfsDsGroups) throws IOException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            for (HdfsGroups hdfsDsGroup : hdfsDsGroups) {
                dfso.removeGroup(hdfsDsGroup.getName());
            }
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUsers(Collection<HdfsUsers> users) throws IOException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            for (HdfsUsers user : users) {
                dfso.removeUser(user.getName());
            }
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatasetGroup(Dataset dataset) throws IOException {
        if (dataset == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        String datasetGroup = this.getHdfsGroupName(dataset);
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            dfso.removeGroup(datasetGroup);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    public List<HdfsUsers> getAllProjectHdfsUsers(String projectName) {
        return this.hdfsUsersFacade.findProjectUsers(projectName);
    }

    public List<HdfsGroups> getAllProjectHdfsGroups(String projectName) {
        return this.hdfsGroupsFacade.findProjectGroups(projectName);
    }

    public List<HdfsGroups> listProjectGroups(Project project, List<Dataset> dsInProject) {
        if (project == null) {
            throw new IllegalArgumentException("One or more arguments are null.");
        }
        ArrayList<HdfsGroups> projectGroups = new ArrayList<HdfsGroups>();
        projectGroups.add(this.hdfsGroupsFacade.findByName(project.getName()));
        for (Dataset ds : dsInProject) {
            String dsGroups = this.getHdfsGroupName(project, ds);
            projectGroups.add(this.hdfsGroupsFacade.findByName(dsGroups));
        }
        return projectGroups;
    }

    public String getHdfsUserName(Project project, Users user) {
        if (project == null || user == null) {
            throw new IllegalArgumentException("project or user were not provided");
        }
        return project.getName() + USER_NAME_DELIMITER + user.getUsername();
    }

    public String getUserName(String hdfsUser) {
        return hdfsUser.split(USER_NAME_DELIMITER)[1];
    }

    public String getProjectName(String hdfsUser) {
        return hdfsUser.split(USER_NAME_DELIMITER)[0];
    }

    public String getHdfsGroupName(Project project, Dataset ds) {
        if (project == null || ds == null) {
            return null;
        }
        return project.getName() + USER_NAME_DELIMITER + ds.getInode().getInodePK().getName();
    }

    public String getHdfsAclGroupName(Project project, Dataset ds) {
        return this.getHdfsGroupName(project, ds) + USER_NAME_DELIMITER + "read";
    }

    public String getHdfsGroupName(Project project, String dataSetName) {
        if (project == null || dataSetName == null) {
            return null;
        }
        return project.getName() + USER_NAME_DELIMITER + dataSetName;
    }

    public String getHdfsGroupName(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        return dataset.getProject().getName() + USER_NAME_DELIMITER + dataset.getInode().getInodePK().getName();
    }

    public void makeImmutable(Path path, DistributedFileSystemOps dfso) throws IOException {
        ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
        AclEntry aclEntryUser = new AclEntry.Builder().setType(AclEntryType.USER).setScope(AclEntryScope.ACCESS).setPermission(FsAction.READ_EXECUTE).build();
        aclEntries.add(aclEntryUser);
        AclEntry aclEntryGroup = new AclEntry.Builder().setType(AclEntryType.GROUP).setScope(AclEntryScope.ACCESS).setPermission(FsAction.READ_EXECUTE).build();
        aclEntries.add(aclEntryGroup);
        AclEntry aclEntryOther = new AclEntry.Builder().setType(AclEntryType.OTHER).setScope(AclEntryScope.ACCESS).setPermission(FsAction.NONE).build();
        aclEntries.add(aclEntryOther);
        dfso.setPermission(path, aclEntries);
    }

    public void undoImmutable(Path path, DistributedFileSystemOps dfso) throws IOException {
        ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
        AclEntry aclEntryUser = new AclEntry.Builder().setType(AclEntryType.USER).setScope(AclEntryScope.ACCESS).setPermission(FsAction.ALL).build();
        aclEntries.add(aclEntryUser);
        AclEntry aclEntryGroup = new AclEntry.Builder().setType(AclEntryType.GROUP).setScope(AclEntryScope.ACCESS).setPermission(FsAction.ALL).build();
        aclEntries.add(aclEntryGroup);
        AclEntry aclEntryOther = new AclEntry.Builder().setType(AclEntryType.OTHER).setScope(AclEntryScope.ACCESS).setPermission(FsAction.NONE).build();
        aclEntries.add(aclEntryOther);
        dfso.setPermission(path, aclEntries);
    }

    public void addNewProjectMember(ProjectTeam teamMember) throws IOException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            this.addNewProjectMember(teamMember, dfso);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    public void addNewMember(ProjectTeam teamMember) throws IOException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            this.addNewMember(teamMember, dfso);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewMember(Dataset dataset, DatasetAccessPermission permission, ProjectTeam teamMember) throws IOException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            this.addNewMember(dataset, permission, teamMember, dfso);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    public void addNewProjectMember(ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        this.createUserIfNotExist(teamMember, dfso);
        if ("Data owner".equals(teamMember.getTeamRole())) {
            this.addToGroup(teamMember.getProject().getName(), teamMember, dfso);
        }
        this.addNewMember(teamMember, dfso);
    }

    public void addNewMember(ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        this.createUserIfNotExist(teamMember, dfso);
        for (Dataset ds : teamMember.getProject().getDatasetCollection()) {
            this.addNewMember(ds, ds.getPermission(), teamMember, dfso);
        }
        for (DatasetSharedWith datasetSharedWith : teamMember.getProject().getDatasetSharedWithCollection()) {
            this.addNewMember(datasetSharedWith.getDataset(), datasetSharedWith.getPermission(), teamMember, dfso);
        }
    }

    public void removeMember(ProjectTeam teamMember) throws IOException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            this.removeMember(teamMember, dfso);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    public void removeUserName(ProjectTeam teamMember) throws IOException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            this.removeUserName(teamMember, dfso);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(Dataset dataset, DatasetAccessPermission permission, ProjectTeam teamMember) throws IOException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            this.removeMember(dataset, permission, teamMember, dfso);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    public void removeUserName(ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        String hdfsUserName = this.getHdfsUserName(teamMember.getProject(), teamMember.getUser());
        dfso.removeUser(hdfsUserName);
    }

    public void removeMember(ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        for (Dataset ds : teamMember.getProject().getDatasetCollection()) {
            this.removeMember(ds, ds.getPermission(), teamMember, dfso);
        }
        for (DatasetSharedWith datasetSharedWith : teamMember.getProject().getDatasetSharedWithCollection()) {
            this.removeMember(datasetSharedWith.getDataset(), datasetSharedWith.getPermission(), teamMember, dfso);
        }
    }

    public void changeMemberRole(ProjectTeam teamMember) throws IOException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            this.changeMemberRole(teamMember, dfso);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeMemberRole(Dataset dataset, DatasetAccessPermission permission, ProjectTeam teamMember) throws IOException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            this.changeMemberRole(dataset, permission, teamMember, dfso);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    public void changeMemberRole(ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        if ("Data owner".equals(teamMember.getTeamRole())) {
            this.addToGroup(teamMember.getProject().getName(), teamMember, dfso);
        } else {
            this.removeFromGroup(teamMember.getProject().getName(), teamMember, dfso);
        }
        for (Dataset ds : teamMember.getProject().getDatasetCollection()) {
            this.changeMemberRole(ds, ds.getPermission(), teamMember, dfso);
        }
        for (DatasetSharedWith datasetSharedWith : teamMember.getProject().getDatasetSharedWithCollection()) {
            this.changeMemberRole(datasetSharedWith.getDataset(), datasetSharedWith.getPermission(), teamMember, dfso);
        }
    }

    public void addNewMember(Dataset dataset, DatasetAccessPermission permission, ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        String datasetGroup = this.getHdfsGroupName(dataset.getProject(), dataset);
        String datasetAclGroup = this.getHdfsAclGroupName(dataset.getProject(), dataset);
        String hdfsUserName = this.getHdfsUserName(teamMember.getProject(), teamMember.getUser());
        this.addNewMember(datasetGroup, datasetAclGroup, hdfsUserName, permission, teamMember, dfso);
    }

    private void addNewMember(String datasetGroup, String datasetAclGroup, String hdfsUserName, DatasetAccessPermission permission, ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        switch (permission) {
            case EDITABLE: {
                this.addToGroup(hdfsUserName, datasetGroup, dfso);
                break;
            }
            case EDITABLE_BY_OWNERS: {
                if ("Data owner".equals(teamMember.getTeamRole())) {
                    this.addToGroup(hdfsUserName, datasetGroup, dfso);
                    break;
                }
                this.addToGroup(hdfsUserName, datasetAclGroup, dfso);
                break;
            }
            case READ_ONLY: {
                this.addToGroup(hdfsUserName, datasetAclGroup, dfso);
                break;
            }
            default: {
                throw new IOException("Unknown permission for dataset: " + datasetGroup);
            }
        }
    }

    public void addMembersToGroups(String datasetGroup, String datasetAclGroup, DistributedFileSystemOps dfso, Collection<ProjectTeam> projectTeamMembers, DatasetAccessPermission permission) throws IOException {
        if (projectTeamMembers == null || projectTeamMembers.isEmpty()) {
            return;
        }
        for (ProjectTeam teamMember : projectTeamMembers) {
            String hdfsUserName = this.getHdfsUserName(teamMember.getProject(), teamMember.getUser());
            this.addNewMember(datasetGroup, datasetAclGroup, hdfsUserName, permission, teamMember, dfso);
        }
    }

    public void removeMember(Dataset dataset, DatasetAccessPermission permission, ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        String datasetGroup = this.getHdfsGroupName(dataset.getProject(), dataset);
        String datasetAclGroup = this.getHdfsAclGroupName(dataset.getProject(), dataset);
        String hdfsUserName = this.getHdfsUserName(teamMember.getProject(), teamMember.getUser());
        switch (permission) {
            case EDITABLE: {
                this.removeFromGroup(hdfsUserName, datasetGroup, dfso);
                break;
            }
            case EDITABLE_BY_OWNERS: {
                if ("Data owner".equals(teamMember.getTeamRole())) {
                    this.removeFromGroup(hdfsUserName, datasetGroup, dfso);
                    break;
                }
                this.removeFromGroup(hdfsUserName, datasetAclGroup, dfso);
                break;
            }
            case READ_ONLY: {
                this.removeFromGroup(hdfsUserName, datasetAclGroup, dfso);
                break;
            }
            default: {
                throw new IOException("Unknown permission for dataset: " + dataset.getName());
            }
        }
    }

    public void changeMemberRole(Dataset dataset, DatasetAccessPermission permission, ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        String datasetGroup = this.getHdfsGroupName(dataset.getProject(), dataset);
        String datasetAclGroup = this.getHdfsAclGroupName(dataset.getProject(), dataset);
        String hdfsUserName = this.getHdfsUserName(teamMember.getProject(), teamMember.getUser());
        switch (permission) {
            case EDITABLE: 
            case READ_ONLY: {
                break;
            }
            case EDITABLE_BY_OWNERS: {
                if ("Data owner".equals(teamMember.getTeamRole())) {
                    this.removeFromGroup(hdfsUserName, datasetAclGroup, dfso);
                    this.addToGroup(hdfsUserName, datasetGroup, dfso);
                    break;
                }
                this.removeFromGroup(hdfsUserName, datasetGroup, dfso);
                this.addToGroup(hdfsUserName, datasetAclGroup, dfso);
                break;
            }
            default: {
                throw new IOException("Unknown permission for dataset: " + dataset.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePermission(Dataset ds, Project targetProject, PermissionTransition permissionTransition) throws IOException {
        DistributedFileSystemOps dfso = this.dfsService.getDfsOps();
        try {
            dfso = this.dfsService.getDfsOps();
            this.changePermission(ds, targetProject, permissionTransition, dfso);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    public void changePermission(Dataset ds, Project targetProject, PermissionTransition permissionTransition, DistributedFileSystemOps dfso) throws IOException {
        for (ProjectTeam teamMember : targetProject.getProjectTeamCollection()) {
            this.changePermission(ds, teamMember, permissionTransition, dfso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePermission(Dataset dataset, ProjectTeam teamMember, PermissionTransition permissionTransition) throws IOException {
        DistributedFileSystemOps dfso = this.dfsService.getDfsOps();
        try {
            dfso = this.dfsService.getDfsOps();
            this.changePermission(dataset, teamMember, permissionTransition, dfso);
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    public void changePermission(Dataset dataset, ProjectTeam teamMember, PermissionTransition permissionTransition, DistributedFileSystemOps dfso) throws IOException {
        String hdfsUserName = this.getHdfsUserName(teamMember.getProject(), teamMember.getUser());
        String datasetGroup = this.getHdfsGroupName(dataset.getProject(), dataset);
        String datasetAclGroup = this.getHdfsAclGroupName(dataset.getProject(), dataset);
        switch (permissionTransition) {
            case EDITABLE_TO_EDITABLE: 
            case READ_ONLY_TO_READ_ONLY: 
            case EDITABLE_BY_OWNERS_TO_EDITABLE_BY_OWNERS: {
                break;
            }
            case EDITABLE_TO_EDITABLE_BY_OWNERS: {
                this.changePermissionEditableToEditableByOwners(datasetGroup, datasetAclGroup, hdfsUserName, teamMember.getTeamRole(), dfso);
                break;
            }
            case EDITABLE_TO_READ_ONLY: {
                this.changePermissionEditableToReadOnly(datasetGroup, datasetAclGroup, hdfsUserName, dfso);
                break;
            }
            case EDITABLE_BY_OWNERS_TO_EDITABLE: {
                this.changePermissionEditableByOwnersToEditable(datasetGroup, datasetAclGroup, hdfsUserName, teamMember.getTeamRole(), dfso);
                break;
            }
            case EDITABLE_BY_OWNERS_TO_READ_ONLY: {
                this.changePermissionEditableByOwnersToReadOnly(datasetGroup, datasetAclGroup, hdfsUserName, teamMember.getTeamRole(), dfso);
                break;
            }
            case READ_ONLY_TO_EDITABLE: {
                this.changePermissionReadOnlyToEditable(datasetGroup, datasetAclGroup, hdfsUserName, dfso);
                break;
            }
            case READ_ONLY_TO_EDITABLE_BY_OWNERS: {
                this.changePermissionReadOnlyToEditableByOwners(datasetGroup, datasetAclGroup, hdfsUserName, teamMember.getTeamRole(), dfso);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal permission transition.");
            }
        }
    }

    private void changePermissionReadOnlyToEditableByOwners(String datasetGroup, String datasetAclGroup, String hdfsUserName, String role, DistributedFileSystemOps dfso) throws IOException {
        if ("Data owner".equals(role)) {
            this.removeFromGroup(hdfsUserName, datasetAclGroup, dfso);
            this.addToGroup(hdfsUserName, datasetGroup, dfso);
        }
    }

    private void changePermissionReadOnlyToEditable(String datasetGroup, String datasetAclGroup, String hdfsUserName, DistributedFileSystemOps dfso) throws IOException {
        this.removeFromGroup(hdfsUserName, datasetAclGroup, dfso);
        this.addToGroup(hdfsUserName, datasetGroup, dfso);
    }

    private void changePermissionEditableByOwnersToReadOnly(String datasetGroup, String datasetAclGroup, String hdfsUserName, String role, DistributedFileSystemOps dfso) throws IOException {
        if ("Data owner".equals(role)) {
            this.removeFromGroup(hdfsUserName, datasetGroup, dfso);
            this.addToGroup(hdfsUserName, datasetAclGroup, dfso);
        }
    }

    private void changePermissionEditableByOwnersToEditable(String datasetGroup, String datasetAclGroup, String hdfsUserName, String role, DistributedFileSystemOps dfso) throws IOException {
        if ("Data scientist".equals(role)) {
            this.removeFromGroup(hdfsUserName, datasetAclGroup, dfso);
            this.addToGroup(hdfsUserName, datasetGroup, dfso);
        }
    }

    private void changePermissionEditableToReadOnly(String datasetGroup, String datasetAclGroup, String hdfsUserName, DistributedFileSystemOps dfso) throws IOException {
        this.removeFromGroup(hdfsUserName, datasetGroup, dfso);
        this.addToGroup(hdfsUserName, datasetAclGroup, dfso);
    }

    private void changePermissionEditableToEditableByOwners(String datasetGroup, String datasetAclGroup, String hdfsUserName, String role, DistributedFileSystemOps dfso) throws IOException {
        if ("Data scientist".equals(role)) {
            this.removeFromGroup(hdfsUserName, datasetGroup, dfso);
            this.addToGroup(hdfsUserName, datasetAclGroup, dfso);
        }
    }

    private void addToGroup(String group, ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        String hdfsUserName = this.getHdfsUserName(teamMember.getProject(), teamMember.getUser());
        this.addToGroup(hdfsUserName, group, dfso);
    }

    private void removeFromGroup(String group, ProjectTeam teamMember, DistributedFileSystemOps dfso) throws IOException {
        String hdfsUserName = this.getHdfsUserName(teamMember.getProject(), teamMember.getUser());
        this.removeFromGroup(hdfsUserName, group, dfso);
    }

    private void removeFromGroup(String hdfsUserName, String group, DistributedFileSystemOps dfso) throws IOException {
        HdfsGroups hdfsGroup = this.hdfsGroupsFacade.findByName(group);
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(hdfsUserName);
        this.removeFromGroup(hdfsUser, hdfsGroup, dfso);
    }

    public void removeFromGroup(HdfsUsers hdfsUser, HdfsGroups hdfsGroup, DistributedFileSystemOps dfso) throws IOException {
        if (hdfsGroup.hasUser(hdfsUser)) {
            dfso.removeUserFromGroup(hdfsUser.getName(), hdfsGroup.getName());
        }
    }

    public void addToGroup(String hdfsUserName, String group, DistributedFileSystemOps dfso) throws IOException {
        try {
            dfso.addUserToGroup(hdfsUserName, group);
        }
        catch (UserAlreadyInGroupException userAlreadyInGroupException) {
            // empty catch block
        }
    }

    private void createUserIfNotExist(ProjectTeam member, DistributedFileSystemOps dfso) throws IOException {
        String hdfsUsername = this.getHdfsUserName(member.getProject(), member.getUser());
        HdfsUsers memberHdfsUser = this.hdfsUsersFacade.findByName(hdfsUsername);
        if (memberHdfsUser == null) {
            dfso.addUser(hdfsUsername);
        }
    }

    public HdfsUsers getOrCreateUser(String hdfsUsername, DistributedFileSystemOps dfso) throws IOException {
        HdfsUsers memberHdfsUser = this.hdfsUsersFacade.findByName(hdfsUsername);
        if (memberHdfsUser == null) {
            dfso.addUser(hdfsUsername);
        }
        return this.hdfsUsersFacade.findByName(hdfsUsername);
    }
}

