/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import io.hops.hopsworks.common.dao.dela.certs.ClusterCertificateFacade;
import io.hops.hopsworks.common.security.MasterPasswordChangeResult;
import io.hops.hopsworks.common.security.MasterPasswordHandler;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.EncryptionMasterPasswordException;
import io.hops.hopsworks.persistence.entity.dela.certs.ClusterCertificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class DelaCertsMasterPasswordHandler
implements MasterPasswordHandler {
    private final Logger LOGGER = Logger.getLogger(DelaCertsMasterPasswordHandler.class.getName());
    @EJB
    private ClusterCertificateFacade clusterCertificateFacade;
    @EJB
    private Settings settings;

    @Override
    public void pre() {
    }

    @Override
    public MasterPasswordChangeResult perform(String oldMasterPassword, String newMasterPassword) {
        StringBuilder successLog = new StringBuilder();
        successLog.append("Performing change of master password for Dela certificates\n");
        HashMap<String, String> items2rollback = new HashMap<String, String>();
        Optional<List<ClusterCertificate>> maybe = this.clusterCertificateFacade.getAllClusterCerts();
        if (maybe.isPresent()) {
            this.LOGGER.log(Level.INFO, "Updating Dela certs with new Hopsworks master encryption password");
            String mapKey = null;
            try {
                for (ClusterCertificate cert : maybe.get()) {
                    mapKey = cert.getClusterName();
                    String oldPassword = cert.getCertificatePassword();
                    items2rollback.putIfAbsent(mapKey, oldPassword);
                    String newEncCertPassword = this.getNewUserPassword(this.settings.getHopsSiteClusterPswd().get(), oldPassword, oldMasterPassword, newMasterPassword);
                    cert.setCertificatePassword(newEncCertPassword);
                    this.clusterCertificateFacade.updateClusterCerts(cert);
                    successLog.append("Updated certificate: ").append(mapKey).append("\n");
                }
            }
            catch (Exception ex) {
                String errorMsg = "Something went wrong while updating master encryption password for Cluster Certificates. Cluster certificate provoked the error was: " + mapKey;
                this.LOGGER.log(Level.SEVERE, errorMsg + " rolling back...", ex);
                return new MasterPasswordChangeResult(items2rollback, new EncryptionMasterPasswordException(errorMsg));
            }
        }
        return new MasterPasswordChangeResult(successLog, items2rollback, null);
    }

    @Override
    public void rollback(MasterPasswordChangeResult result) {
        this.LOGGER.log(Level.INFO, "Rolling back Dela certificates");
        HashMap items2rollback = (HashMap)result.getRollbackItems();
        for (Map.Entry cert : items2rollback.entrySet()) {
            String key = (String)cert.getKey();
            String value = (String)cert.getValue();
            Optional<ClusterCertificate> optional = this.clusterCertificateFacade.getClusterCert(key);
            if (!optional.isPresent()) continue;
            ClusterCertificate cc = optional.get();
            cc.setCertificatePassword(value);
            this.clusterCertificateFacade.updateClusterCerts(cc);
        }
    }

    @Override
    public void post() {
    }
}

