/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeaturegroupPreview;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.jobs.FeaturestoreJobDTO;
import io.hops.hopsworks.common.featurestore.jobs.FeaturestoreJobFacade;
import io.hops.hopsworks.common.featurestore.statistics.FeaturestoreStatisticController;
import io.hops.hopsworks.common.featurestore.statistics.columns.StatisticColumnController;
import io.hops.hopsworks.common.featurestore.statistics.columns.StatisticColumnFacade;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreInputValidation;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.CachedFeaturegroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.HivePartitions;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.ondemand.OnDemandFeaturegroup;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturegroupController {
    @EJB
    private FeaturegroupFacade featuregroupFacade;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private FeaturestoreStatisticController featurestoreStatisticController;
    @EJB
    private CachedFeaturegroupController cachedFeaturegroupController;
    @EJB
    private OnDemandFeaturegroupController onDemandFeaturegroupController;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeaturestoreJobFacade featurestoreJobFacade;
    @EJB
    private JobFacade jobFacade;
    @EJB
    private StatisticColumnController statisticColumnController;
    @EJB
    private StatisticColumnFacade statisticColumnFacade;
    @EJB
    private FeaturestoreInputValidation featurestoreInputValidation;
    @EJB
    private CachedFeaturegroupFacade cachedFeaturegroupFacade;
    @EJB
    private HopsFSProvenanceController fsController;
    @EJB
    private ActivityFacade activityFacade;

    public List<FeaturegroupDTO> getFeaturegroupsForFeaturestore(Featurestore featurestore) {
        List<Featuregroup> featuregroups = this.featuregroupFacade.findByFeaturestore(featurestore);
        return featuregroups.stream().map(fg -> this.convertFeaturegrouptoDTO((Featuregroup)fg)).collect(Collectors.toList());
    }

    public FeaturegroupDTO clearFeaturegroup(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException, SQLException, ProvenanceException, IOException, ServiceException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                FeaturegroupDTO featuregroupDTO = this.convertFeaturegrouptoDTO(featuregroup);
                this.deleteFeaturegroup(featuregroup, project, user);
                return this.createFeaturegroup(featuregroup.getFeaturestore(), featuregroupDTO, project, user);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CLEAR_OPERATION_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, "featuregroupId: " + featuregroup.getId());
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public FeaturegroupDTO createFeaturegroup(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Project project, Users user) throws FeaturestoreException, SQLException, ProvenanceException, IOException, ServiceException {
        if (featuregroupDTO.getVersion() == null) {
            List<Featuregroup> fgPrevious = this.featuregroupFacade.findByNameAndFeaturestoreOrderedDescVersion(featuregroupDTO.getName(), featurestore);
            if (fgPrevious != null && !fgPrevious.isEmpty()) {
                featuregroupDTO.setVersion(fgPrevious.get(0).getVersion() + 1);
            } else {
                featuregroupDTO.setVersion(1);
            }
        }
        this.verifyFeatureGroupInput(featuregroupDTO);
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(featurestore.getProject(), user);
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(hdfsUsername);
        OnDemandFeaturegroup onDemandFeaturegroup = null;
        CachedFeaturegroup cachedFeaturegroup = null;
        if (featuregroupDTO instanceof CachedFeaturegroupDTO) {
            cachedFeaturegroup = this.cachedFeaturegroupController.createCachedFeaturegroup(featurestore, (CachedFeaturegroupDTO)featuregroupDTO, project, user);
        } else {
            onDemandFeaturegroup = this.onDemandFeaturegroupController.createOnDemandFeaturegroup((OnDemandFeaturegroupDTO)featuregroupDTO);
        }
        Featuregroup featuregroup = this.persistFeaturegroupMetadata(featurestore, hdfsUser, user, featuregroupDTO, cachedFeaturegroup, onDemandFeaturegroup);
        this.statisticColumnController.persistStatisticColumns(featuregroup, featuregroupDTO.getStatisticColumns());
        featuregroup.setStatisticColumns(this.statisticColumnFacade.findByFeaturegroup(featuregroup));
        this.featurestoreStatisticController.updateFeaturestoreStatistics(featuregroup, null, featuregroupDTO.getFeatureCorrelationMatrix(), featuregroupDTO.getDescriptiveStatistics(), featuregroupDTO.getFeaturesHistogram(), featuregroupDTO.getClusterAnalysis());
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobFacade.insertJobs(featuregroup, jobs);
        FeaturegroupDTO completeFeaturegroupDTO = this.convertFeaturegrouptoDTO(featuregroup);
        if (FeaturegroupType.CACHED_FEATURE_GROUP.equals((Object)featuregroup.getFeaturegroupType())) {
            this.fsController.featuregroupAttachXAttrs(user, featurestore.getProject(), completeFeaturegroupDTO);
        }
        return completeFeaturegroupDTO;
    }

    private List<Jobs> getJobs(List<FeaturestoreJobDTO> jobDTOs, Project project) {
        if (jobDTOs != null) {
            return jobDTOs.stream().filter(jobDTO -> jobDTO != null && !Strings.isNullOrEmpty((String)jobDTO.getJobName())).map(jobDTO -> jobDTO.getJobName()).distinct().map(jobName -> this.jobFacade.findByProjectAndName(project, (String)jobName)).collect(Collectors.toList());
        }
        return new ArrayList<Jobs>();
    }

    private FeaturegroupDTO convertFeaturegrouptoDTO(Featuregroup featuregroup) {
        String featurestoreName = this.featurestoreFacade.getHiveDbName(featuregroup.getFeaturestore().getHiveDbId());
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                CachedFeaturegroupDTO cachedFeaturegroupDTO = this.cachedFeaturegroupController.convertCachedFeaturegroupToDTO(featuregroup);
                cachedFeaturegroupDTO.setFeaturestoreName(featurestoreName);
                return cachedFeaturegroupDTO;
            }
            case ON_DEMAND_FEATURE_GROUP: {
                OnDemandFeaturegroupDTO onDemandFeaturegroupDTO = new OnDemandFeaturegroupDTO(featuregroup);
                onDemandFeaturegroupDTO.setFeaturestoreName(featurestoreName);
                return onDemandFeaturegroupDTO;
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public List<FeaturegroupDTO> getFeaturegroupWithNameAndFeaturestore(Featurestore featurestore, String name) {
        List<Featuregroup> featuregroup = this.verifyFeaturegroupName(featurestore, name);
        return featuregroup.stream().map(this::convertFeaturegrouptoDTO).collect(Collectors.toList());
    }

    public FeaturegroupDTO getFeaturegroupWithNameVersionAndFeaturestore(Featurestore featurestore, String name, Integer version) throws FeaturestoreException {
        Featuregroup featuregroup = this.verifyFeaturegroupNameVersion(featurestore, name, version);
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    public FeaturegroupDTO getFeaturegroupWithIdAndFeaturestore(Featurestore featurestore, Integer id) throws FeaturestoreException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, id);
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    public FeaturegroupDTO updateFeaturegroupMetadata(Featurestore featurestore, FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_UPDATING_METADATA, Level.FINE, ", updating metadata of feature groups is currently only supported for on-demand feature groups.");
        }
        this.featurestoreInputValidation.verifyUserInput(featuregroupDTO);
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            this.onDemandFeaturegroupController.updateOnDemandFeaturegroupMetadata(featuregroup.getOnDemandFeaturegroup(), (OnDemandFeaturegroupDTO)featuregroupDTO);
        }
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobFacade.insertJobs(featuregroup, jobs);
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    public FeaturegroupDTO updateFeaturegroupJob(Featurestore featurestore, FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobFacade.insertJobs(featuregroup, jobs);
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    public FeaturegroupDTO enableFeaturegroupOnline(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Project project, Users user) throws FeaturestoreException, SQLException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ONLINE_FEATURE_SERVING_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, ", Online feature serving is only supported for featuregroups of type: " + FeaturegroupType.CACHED_FEATURE_GROUP + ", and the user requested to enable feature serving on a featuregroup with type:" + FeaturegroupType.ON_DEMAND_FEATURE_GROUP);
        }
        this.cachedFeaturegroupController.enableFeaturegroupOnline(featurestore, featuregroup, project, user);
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    public FeaturegroupDTO disableFeaturegroupOnline(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException, SQLException {
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ONLINE_FEATURE_SERVING_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, ", Online feature serving is only supported for featuregroups of type: " + FeaturegroupType.CACHED_FEATURE_GROUP + ", and the user requested to a feature serving operation on a featuregroup with type:" + FeaturegroupType.ON_DEMAND_FEATURE_GROUP);
        }
        this.cachedFeaturegroupController.disableFeaturegroupOnline(featuregroup, project, user);
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    public FeaturegroupDTO updateFeaturegroupStats(Featurestore featurestore, FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        this.verifyStatisticsInput(featuregroupDTO);
        this.featurestoreStatisticController.updateFeaturestoreStatistics(featuregroup, null, featuregroupDTO.getFeatureCorrelationMatrix(), featuregroupDTO.getDescriptiveStatistics(), featuregroupDTO.getFeaturesHistogram(), featuregroupDTO.getClusterAnalysis());
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    public FeaturegroupDTO updateFeaturegroupStatsSettings(Featurestore featurestore, FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        this.statisticColumnController.persistStatisticColumns(featuregroup, featuregroupDTO.getStatisticColumns());
        featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        this.verifyAndSetFeaturegroupStatsSettings(featuregroupDTO, featuregroup);
        this.featuregroupFacade.updateFeaturegroupMetadata(featuregroup);
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    public void verifyAndSetFeaturegroupStatsSettings(FeaturegroupDTO featuregroupDTO, Featuregroup featuregroup) {
        if (featuregroupDTO.isDescStatsEnabled() != null) {
            featuregroup.setDescStatsEnabled(featuregroupDTO.isDescStatsEnabled().booleanValue());
        }
        if (featuregroupDTO.isFeatCorrEnabled() != null) {
            featuregroup.setFeatCorrEnabled(featuregroupDTO.isFeatCorrEnabled().booleanValue());
        }
        if (featuregroupDTO.isFeatHistEnabled() != null) {
            featuregroup.setFeatHistEnabled(featuregroupDTO.isFeatHistEnabled().booleanValue());
        }
        if (featuregroupDTO.isClusterAnalysisEnabled() != null) {
            featuregroup.setClusterAnalysisEnabled(featuregroupDTO.isClusterAnalysisEnabled().booleanValue());
        }
        if (featuregroupDTO.getNumBins() != null) {
            featuregroup.setNumBins(featuregroupDTO.getNumBins());
        }
        if (featuregroupDTO.getNumClusters() != null) {
            featuregroup.setNumClusters(featuregroupDTO.getNumClusters());
        }
        if (featuregroupDTO.getCorrMethod() != null) {
            featuregroup.setCorrMethod(featuregroupDTO.getCorrMethod());
        }
    }

    public void verifyStatisticsInput(FeaturegroupDTO featuregroupDTO) {
        if (featuregroupDTO.getFeatureCorrelationMatrix() != null && featuregroupDTO.getFeatureCorrelationMatrix().getFeatureCorrelations().size() > 50) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.CORRELATION_MATRIX_EXCEED_MAX_SIZE.getMessage());
        }
    }

    public boolean featuregroupExists(Featurestore featurestore, FeaturegroupDTO featuregroupDTO) {
        if (!Strings.isNullOrEmpty((String)featuregroupDTO.getName()) && featuregroupDTO.getVersion() != null) {
            return this.featuregroupFacade.findByNameVersionAndFeaturestore(featuregroupDTO.getName(), featuregroupDTO.getVersion(), featurestore).isPresent();
        }
        return false;
    }

    public Optional<Featuregroup> getFeaturegroupByDTO(Featurestore featurestore, FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO.getId() != null) {
            return Optional.of(this.getFeaturegroupById(featurestore, featuregroupDTO.getId()));
        }
        List<Featuregroup> featuregroups = this.featuregroupFacade.findByFeaturestore(featurestore);
        return featuregroups.stream().filter(fg -> {
            FeaturegroupDTO convertedFeaturegroupDTO = this.convertFeaturegrouptoDTO((Featuregroup)fg);
            return convertedFeaturegroupDTO.getName().equalsIgnoreCase(featuregroupDTO.getName()) && convertedFeaturegroupDTO.getVersion().equals(featuregroupDTO.getVersion());
        }).findFirst();
    }

    public void deleteFeaturegroup(Featuregroup featuregroup, Project project, Users user) throws SQLException, FeaturestoreException, ServiceException, IOException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                this.cachedFeaturegroupController.dropHiveFeaturegroup(featuregroup, project, user);
                this.cachedFeaturegroupController.dropMySQLFeaturegroup(featuregroup, project, user);
                break;
            }
            case ON_DEMAND_FEATURE_GROUP: {
                this.onDemandFeaturegroupController.removeOnDemandFeaturegroup(featuregroup.getOnDemandFeaturegroup());
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
            }
        }
        this.activityFacade.persistActivity(" deleted a feature group named " + featuregroup.getName(), project, user, ActivityFlag.SERVICE);
    }

    public FeaturegroupPreview getFeaturegroupPreview(Featuregroup featuregroup, Project project, Users user, String partition, boolean online, int limit) throws SQLException, FeaturestoreException, HopsSecurityException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                return this.cachedFeaturegroupController.getFeaturegroupPreview(featuregroup, project, user, partition, online, limit);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.PREVIEW_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, "featuregroupId: " + featuregroup.getId());
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public List<HivePartitions> getPartitions(Featuregroup featuregroup, Integer offset, Integer limit) throws FeaturestoreException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                return this.cachedFeaturegroupFacade.getHiveTablePartitions(featuregroup.getCachedFeaturegroup().getHiveTbls(), offset, limit);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_ONDEMAND_NO_PARTS, Level.FINE, "featuregroupId: " + featuregroup.getId());
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public Featuregroup getFeaturegroupById(Featurestore featurestore, Integer featuregroupId) throws FeaturestoreException {
        Featuregroup featuregroup = null;
        featuregroup = featurestore != null ? this.featuregroupFacade.findByIdAndFeaturestore(featuregroupId, featurestore) : this.featuregroupFacade.findById(featuregroupId);
        if (featuregroup == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.FINE, "featuregroupId: " + featuregroupId);
        }
        return featuregroup;
    }

    private List<Featuregroup> verifyFeaturegroupName(Featurestore featurestore, String featureGroupName) {
        List<Featuregroup> featuregroup = this.featuregroupFacade.findByNameAndFeaturestore(featureGroupName, featurestore);
        if (featuregroup == null || featuregroup.isEmpty()) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND + " feature group name " + featureGroupName);
        }
        return featuregroup;
    }

    public Featuregroup verifyFeaturegroupNameVersion(Featurestore featurestore, String featureGroupName, Integer version) throws FeaturestoreException {
        return this.featuregroupFacade.findByNameVersionAndFeaturestore(featureGroupName, version, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.FINE, "feature group name: " + featureGroupName + " feature group version: " + version));
    }

    public FeaturegroupDTO syncHiveTableWithFeaturestore(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Users user) throws FeaturestoreException {
        if (featuregroupDTO instanceof OnDemandFeaturegroupDTO) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Only cached feature groups can be synced from an existing Hive table, not on-demand feature groups.");
        }
        this.verifyFeatureGroupInput(featuregroupDTO);
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(featurestore.getProject(), user);
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(hdfsUsername);
        CachedFeaturegroup cachedFeaturegroup = this.cachedFeaturegroupController.syncHiveTableWithFeaturestore(featurestore, (CachedFeaturegroupDTO)featuregroupDTO);
        Featuregroup featuregroup = this.persistFeaturegroupMetadata(featurestore, hdfsUser, user, featuregroupDTO, cachedFeaturegroup, null);
        this.featurestoreStatisticController.updateFeaturestoreStatistics(featuregroup, null, featuregroupDTO.getFeatureCorrelationMatrix(), featuregroupDTO.getDescriptiveStatistics(), featuregroupDTO.getFeaturesHistogram(), featuregroupDTO.getClusterAnalysis());
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobFacade.insertJobs(featuregroup, jobs);
        return featuregroupDTO;
    }

    private Featuregroup persistFeaturegroupMetadata(Featurestore featurestore, HdfsUsers hdfsUser, Users user, FeaturegroupDTO featuregroupDTO, CachedFeaturegroup cachedFeaturegroup, OnDemandFeaturegroup onDemandFeaturegroup) {
        Featuregroup featuregroup = new Featuregroup();
        featuregroup.setName(featuregroupDTO.getName());
        featuregroup.setFeaturestore(featurestore);
        featuregroup.setHdfsUserId(hdfsUser.getId());
        featuregroup.setCreated(new Date());
        featuregroup.setCreator(user);
        featuregroup.setVersion(featuregroupDTO.getVersion());
        featuregroup.setFeaturegroupType(featuregroupDTO instanceof CachedFeaturegroupDTO ? FeaturegroupType.CACHED_FEATURE_GROUP : FeaturegroupType.ON_DEMAND_FEATURE_GROUP);
        featuregroup.setCachedFeaturegroup(cachedFeaturegroup);
        featuregroup.setOnDemandFeaturegroup(onDemandFeaturegroup);
        this.verifyAndSetFeaturegroupStatsSettings(featuregroupDTO, featuregroup);
        this.featuregroupFacade.persist(featuregroup);
        return featuregroup;
    }

    public List<FeatureDTO> getFeatures(Featuregroup featuregroup) {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                return this.cachedFeaturegroupController.getFeaturesDTO(featuregroup.getCachedFeaturegroup().getHiveTbls());
            }
            case ON_DEMAND_FEATURE_GROUP: {
                return featuregroup.getOnDemandFeaturegroup().getFeatures().stream().map(f -> new FeatureDTO(f.getName(), f.getType(), f.getPrimary())).collect(Collectors.toList());
            }
        }
        return new ArrayList<FeatureDTO>();
    }

    private void verifyFeatureGroupInput(FeaturegroupDTO featureGroupDTO) throws FeaturestoreException {
        this.featurestoreInputValidation.verifyUserInput(featureGroupDTO);
        this.verifyFeatureGroupVersion(featureGroupDTO.getVersion());
        this.verifyStatisticsInput(featureGroupDTO);
    }

    private void verifyFeatureGroupVersion(Integer version) throws FeaturestoreException {
        if (version == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_VERSION_NOT_PROVIDED.getMessage());
        }
        if (version <= 0) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_VERSION, Level.FINE, "version cannot be negative or zero");
        }
    }
}

