/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.StreamGobbler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.concurrent.ManagedExecutorService;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class OSProcessExecutor {
    private static final Logger LOGGER = Logger.getLogger(OSProcessExecutor.class.getName());
    @Resource(lookup="concurrent/hopsExecutorService")
    private ManagedExecutorService executorService;

    public ProcessResult execute(ProcessDescriptor processDescriptor) throws IOException {
        try {
            return this.runProcess(processDescriptor);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new IOException(ex);
        }
    }

    @Asynchronous
    public Future<ProcessResult> submit(ProcessDescriptor processDescriptor) throws IOException {
        try {
            ProcessResult processResult = this.runProcess(processDescriptor);
            return new AsyncResult((Object)processResult);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new IOException(ex);
        }
    }

    private ProcessResult runProcess(ProcessDescriptor processDescriptor) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        ProcessBuilder processBuilder = new ProcessBuilder(processDescriptor.getSubcommands());
        processBuilder.directory(processDescriptor.getCwd());
        Map<String, String> env = processBuilder.environment();
        for (Map.Entry<String, String> entry : processDescriptor.getEnvironmentVariables().entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        processBuilder.redirectErrorStream(processDescriptor.redirectErrorStream());
        Process process = processBuilder.start();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        boolean ignoreStreams = processDescriptor.ignoreOutErrStreams();
        Future stderrGobblerFuture = null;
        if (!processDescriptor.redirectErrorStream()) {
            StreamGobbler stderrGobbler = new StreamGobbler(process.getErrorStream(), errStream, ignoreStreams);
            stderrGobblerFuture = this.executorService.submit((Runnable)stderrGobbler);
        }
        StreamGobbler stdoutGobbler = new StreamGobbler(process.getInputStream(), outStream, ignoreStreams);
        Future stdoutGobblerFuture = this.executorService.submit((Runnable)stdoutGobbler);
        boolean exited = process.waitFor(processDescriptor.getWaitTimeout(), processDescriptor.getTimeoutUnit());
        if (exited) {
            this.waitForGobbler(stdoutGobblerFuture);
            if (stderrGobblerFuture != null) {
                this.waitForGobbler(stderrGobblerFuture);
            }
            return new ProcessResult(process.exitValue(), true, this.stringifyStream(outStream, ignoreStreams), this.stringifyStream(errStream, ignoreStreams));
        }
        exited = process.destroyForcibly().waitFor(1L, TimeUnit.SECONDS);
        stdoutGobblerFuture.cancel(true);
        if (stderrGobblerFuture != null) {
            stderrGobblerFuture.cancel(true);
        }
        int returnValue = 200;
        if (exited) {
            returnValue = process.exitValue();
        }
        return new ProcessResult(returnValue, false, this.stringifyStream(outStream, ignoreStreams), "Process timed-out");
    }

    private void waitForGobbler(Future gobbler) throws InterruptedException, ExecutionException {
        try {
            gobbler.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            LOGGER.log(Level.WARNING, "Waited enough for StreamGobbler to finish, killing it...");
            gobbler.cancel(true);
        }
    }

    private String stringifyStream(OutputStream outputStream, boolean ignoreStream) {
        if (ignoreStream) {
            return "";
        }
        return outputStream.toString();
    }
}

