/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user;

import com.google.common.base.Strings;
import com.google.zxing.WriterException;
import io.hops.hopsworks.common.dao.user.BbcGroupFacade;
import io.hops.hopsworks.common.dao.user.UserDTO;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.security.audit.AccountAuditFacade;
import io.hops.hopsworks.common.dao.user.security.audit.RolesAuditFacade;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountsEmailMessages;
import io.hops.hopsworks.common.dao.user.sshkey.SshKeyDTO;
import io.hops.hopsworks.common.dao.user.sshkey.SshkeysFacade;
import io.hops.hopsworks.common.security.utils.Secret;
import io.hops.hopsworks.common.security.utils.SecurityUtils;
import io.hops.hopsworks.common.user.AuthController;
import io.hops.hopsworks.common.user.PasswordRecovery;
import io.hops.hopsworks.common.user.UserValidator;
import io.hops.hopsworks.common.util.EmailBean;
import io.hops.hopsworks.common.util.QRCodeGenerator;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.user.BbcGroup;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.Address;
import io.hops.hopsworks.persistence.entity.user.security.Organization;
import io.hops.hopsworks.persistence.entity.user.security.audit.AccountAudit;
import io.hops.hopsworks.persistence.entity.user.security.audit.RolesAudit;
import io.hops.hopsworks.persistence.entity.user.security.ua.SecurityQuestion;
import io.hops.hopsworks.persistence.entity.user.security.ua.UserAccountStatus;
import io.hops.hopsworks.persistence.entity.user.security.ua.UserAccountType;
import io.hops.hopsworks.persistence.entity.user.security.ua.ValidationKeyType;
import io.hops.hopsworks.persistence.entity.user.sshkey.SshKeys;
import io.hops.hopsworks.persistence.entity.user.sshkey.SshKeysPK;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.GenericEntity;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class UsersController {
    private static final Logger LOGGER = Logger.getLogger(UsersController.class.getName());
    @EJB
    private UserFacade userFacade;
    @EJB
    private AccountAuditFacade accountAuditFacade;
    @EJB
    private RolesAuditFacade rolesAuditFacade;
    @EJB
    private BbcGroupFacade bbcGroupFacade;
    @EJB
    private SshkeysFacade sshKeysBean;
    @EJB
    private UserValidator userValidator;
    @EJB
    private EmailBean emailBean;
    @EJB
    private Settings settings;
    @EJB
    private AuthController authController;
    @EJB
    private SecurityUtils securityUtils;
    @Inject
    private PasswordRecovery passwordRecovery;
    private byte[] qrCode;

    public byte[] registerUser(UserDTO newUser, String validationKeyUrl) throws UserException {
        if (newUser.getEmail() != null && !newUser.getEmail().isEmpty()) {
            newUser.setEmail(newUser.getEmail().toLowerCase());
        }
        this.userValidator.isValidNewUser(newUser);
        newUser.setMaxNumProjects(0);
        Users user = this.createNewUser(newUser, UserAccountStatus.NEW_MOBILE_ACCOUNT, UserAccountType.M_ACCOUNT_TYPE);
        this.addAddress(user);
        this.addOrg(user);
        try {
            if (!newUser.isTestUser()) {
                this.authController.sendEmailValidationKey(user, user.getValidationKey(), validationKeyUrl);
            }
            this.userFacade.persist(user);
            this.qrCode = QRCodeGenerator.getQRCodeBytes(newUser.getEmail(), "hops.io", user.getSecret());
        }
        catch (WriterException | IOException | MessagingException ex) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_REGISTRATION_ERROR, Level.SEVERE, "user: " + newUser.getUsername(), ex.getMessage(), ex);
        }
        return this.qrCode;
    }

    public Users registerUser(UserDTO newUser, String role, UserAccountStatus accountStatus, UserAccountType accountType) throws UserException {
        if (!Strings.isNullOrEmpty((String)newUser.getEmail())) {
            newUser.setEmail(newUser.getEmail().toLowerCase());
        }
        this.userValidator.isValidEmail(newUser.getEmail());
        if (this.userFacade.findByEmail(newUser.getEmail()) != null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_EXISTS, Level.FINE);
        }
        Users user = this.createNewUser(newUser, accountStatus, accountType);
        BbcGroup group = this.bbcGroupFacade.findByGroupName(role);
        if (group != null) {
            user.getBbcGroupCollection().add(group);
        }
        this.addAddress(user);
        this.addOrg(user);
        this.userFacade.persist(user);
        return user;
    }

    public void addRole(String role, Integer id) throws UserException {
        Users p = (Users)this.userFacade.find(id);
        BbcGroup bbcGroup = this.bbcGroupFacade.findByGroupName(role);
        if (bbcGroup == null) {
            throw new UserException(RESTCodes.UserErrorCode.ROLE_NOT_FOUND, Level.FINE, "Role could not be granted.");
        }
        this.registerGroup(p, bbcGroup.getGid());
    }

    public void removeRole(String role, Integer id) throws UserException {
        Users p = (Users)this.userFacade.find(id);
        BbcGroup bbcGroup = this.bbcGroupFacade.findByGroupName(role);
        if (bbcGroup != null && p.getBbcGroupCollection().contains(bbcGroup)) {
            this.userFacade.removeGroup(p.getEmail(), bbcGroup.getGid());
            p.getBbcGroupCollection().remove(bbcGroup);
        } else if (bbcGroup != null) {
            throw new UserException(RESTCodes.UserErrorCode.ROLE_NOT_FOUND, Level.FINE, "Role could not be granted.");
        }
    }

    public void sendConfirmationMail(Users user) throws ServiceException {
        try {
            this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, "Welcome to Hopsworks!", UserAccountsEmailMessages.accountActivatedMessage(user.getEmail()));
        }
        catch (MessagingException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.EMAIL_SENDING_FAILURE, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
    }

    public void sendRejectionEmail(Users user) throws ServiceException {
        try {
            this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, "Your Hopsworks account request has been rejected", UserAccountsEmailMessages.accountRejectedMessage());
        }
        catch (MessagingException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.EMAIL_SENDING_FAILURE, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
    }

    public Users resendAccountVerificationEmail(Users user, String linkUrl) throws ServiceException {
        try {
            this.authController.sendNewValidationKey(user, linkUrl);
            return user;
        }
        catch (MessagingException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.EMAIL_SENDING_FAILURE, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
    }

    public Users createNewUser(UserDTO newUser, UserAccountStatus accountStatus, UserAccountType accountType) {
        String otpSecret = this.securityUtils.calculateSecretKey();
        String activationKey = this.securityUtils.generateSecureRandomString();
        String uname = this.generateUsername(newUser.getEmail());
        ArrayList groups = new ArrayList();
        Secret secret = this.securityUtils.generateSecret(newUser.getChosenPassword());
        Timestamp now = new Timestamp(new Date().getTime());
        SecurityQuestion secQuestion = SecurityQuestion.getQuestion((String)newUser.getSecurityQuestion());
        String secAnswer = this.securityUtils.getHash(newUser.getSecurityAnswer().toLowerCase());
        int maxNumProjects = newUser.getMaxNumProjects() > 0 ? newUser.getMaxNumProjects() : this.settings.getMaxNumProjPerUser().intValue();
        Users user = new Users(uname, secret.getSha256HexDigest(), newUser.getEmail(), newUser.getFirstName(), newUser.getLastName(), (Date)now, "-", "-", accountStatus, otpSecret, activationKey, (Date)now, ValidationKeyType.EMAIL, secQuestion, secAnswer, accountType, (Date)now, newUser.getTelephoneNum(), Integer.valueOf(maxNumProjects), newUser.isTwoFactor(), secret.getSalt(), newUser.getToursState());
        user.setBbcGroupCollection(groups);
        return user;
    }

    public Users createNewAgent(String email, String fname, String lname, String pwd, String title) {
        String uname = this.generateUsername(email);
        ArrayList groups = new ArrayList();
        Secret secret = this.securityUtils.generateSecret(pwd);
        Users user = new Users(uname, secret.getSha256HexDigest(), email, fname, lname, (Date)new Timestamp(new Date().getTime()), title, "-", UserAccountStatus.NEW_MOBILE_ACCOUNT, UserAccountType.M_ACCOUNT_TYPE, (Date)new Timestamp(new Date().getTime()), Integer.valueOf(0), secret.getSalt());
        user.setBbcGroupCollection(groups);
        return user;
    }

    public Users createNewRemoteUser(String email, String fname, String lname, String pwd, UserAccountStatus accStatus) {
        String uname = this.generateUsername(email);
        ArrayList groups = new ArrayList();
        Secret secret = this.securityUtils.generateSecret(pwd);
        Users user = new Users(uname, secret.getSha256HexDigest(), email, fname, lname, (Date)new Timestamp(new Date().getTime()), "-", "-", accStatus, UserAccountType.REMOTE_ACCOUNT_TYPE, (Date)new Timestamp(new Date().getTime()), this.settings.getMaxNumProjPerUser(), secret.getSalt());
        user.setBbcGroupCollection(groups);
        this.addAddress(user);
        this.addOrg(user);
        return user;
    }

    public void addAddress(Users user) {
        Address a = new Address();
        a.setUid(user);
        a.setAddress1("-");
        a.setAddress2("-");
        a.setAddress3("-");
        a.setCity("Stockholm");
        a.setCountry("SE");
        a.setPostalcode("-");
        a.setState("-");
        user.setAddress(a);
    }

    public void addOrg(Users user) {
        Organization org = new Organization();
        org.setUid(user);
        org.setContactEmail("-");
        org.setContactPerson("-");
        org.setDepartment("-");
        org.setFax("-");
        org.setOrgName("-");
        org.setWebsite("-");
        org.setPhone("-");
        user.setOrganization(org);
    }

    public void sendQRRecoveryEmail(String email, String password, String reqUrl) throws UserException, MessagingException {
        Users user = this.userFacade.findByEmail(email);
        if (!this.authController.checkUserPasswordAndStatus(user, password)) {
            throw new UserException(RESTCodes.UserErrorCode.INCORRECT_CREDENTIALS, Level.FINE);
        }
        if (!user.getTwoFactor()) {
            throw new UserException(RESTCodes.UserErrorCode.TWO_FA_DISABLED, Level.FINE);
        }
        this.authController.sendNewRecoveryValidationKey(user, reqUrl, false);
    }

    public void sendPasswordRecoveryEmail(String email, String securityQuestion, String securityAnswer, String reqUrl) throws UserException, MessagingException {
        Users user = this.userFacade.findByEmail(email);
        this.passwordRecovery.validateSecurityQAndStatus(user, securityQuestion, securityAnswer);
        this.authController.sendNewRecoveryValidationKey(user, reqUrl, true);
    }

    public String recoverQRCode(String key) throws UserException, MessagingException {
        return new String(this.recoverQRCodeByte(key));
    }

    public byte[] recoverQRCodeByte(String key) throws UserException, MessagingException {
        Users user = this.authController.validateRecoveryKey(key, ValidationKeyType.QR_RESET);
        byte[] qrCode = this.recoverQRCode(user);
        if (qrCode == null) {
            throw new UserException(RESTCodes.UserErrorCode.TWO_FA_DISABLED, Level.FINE);
        }
        this.authController.resetValidationKey(user);
        String subject = "Your QR code has been reset";
        String msg = UserAccountsEmailMessages.buildQRResetMessage();
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
        return Base64.encodeBase64((byte[])qrCode);
    }

    private byte[] recoverQRCode(Users user) {
        String random = this.securityUtils.calculateSecretKey();
        this.updateSecret(user, random);
        return this.getQrCode(user);
    }

    public void changePassword(Users user, String oldPassword, String newPassword, String confirmedPassword) throws UserException {
        if (!this.authController.validatePassword(user, oldPassword)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        if (UserAccountStatus.TEMP_PASSWORD.equals((Object)user.getStatus())) {
            user.setStatus(UserAccountStatus.ACTIVATED_ACCOUNT);
        }
        this.changePassword(user, newPassword, confirmedPassword);
    }

    public void checkRecoveryKey(String key) throws UserException {
        this.authController.checkRecoveryKey(key);
    }

    public void validateKey(String key) throws UserException {
        this.authController.validateEmail(key);
    }

    public String resetPassword(Integer id, String initiator) throws UserException, MessagingException {
        Users user = (Users)this.userFacade.find(id);
        String randomPwd = this.securityUtils.generateRandomString(8);
        user.setStatus(UserAccountStatus.TEMP_PASSWORD);
        this.changePasswordAsAdmin(user, randomPwd);
        String subject = "Your password has been reset";
        String msg = UserAccountsEmailMessages.buildResetByAdminMessage(initiator);
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
        return randomPwd;
    }

    public void changePassword(String key, String newPassword, String confirmedPassword) throws UserException, MessagingException {
        this.userValidator.isValidPassword(newPassword, confirmedPassword);
        Users user = this.authController.validateRecoveryKey(key, ValidationKeyType.PASSWORD_RESET);
        this.changePassword(user, newPassword, confirmedPassword);
        this.authController.resetValidationKey(user);
        String subject = "Your password has been reset";
        String msg = UserAccountsEmailMessages.buildResetMessage();
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
    }

    private void changePassword(Users user, String newPassword, String confirmedPassword) throws UserException {
        if (this.userValidator.isValidPassword(newPassword, confirmedPassword)) {
            try {
                Secret secret = this.securityUtils.generateSecret(newPassword);
                this.authController.changePassword(user, secret);
            }
            catch (Exception ex) {
                throw new UserException(RESTCodes.UserErrorCode.PASSWORD_RESET_UNSUCCESSFUL, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void changePasswordAsAdmin(Users user, String newPassword) throws UserException {
        try {
            Secret secret = this.securityUtils.generateSecret(newPassword);
            this.authController.changeUserPasswordAsAdmin(user, secret);
        }
        catch (Exception ex) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_RESET_UNSUCCESSFUL, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
        }
    }

    public void changeSecQA(Users user, String oldPassword, String securityQuestion, String securityAnswer) throws UserException {
        if (!this.authController.validatePassword(user, oldPassword)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        if (this.userValidator.isValidsecurityQA(securityQuestion, securityAnswer)) {
            this.authController.changeSecQA(user, securityQuestion, securityAnswer);
        }
    }

    public Users updateProfile(Users user, String firstName, String lastName, String telephoneNum, Integer toursState) throws UserException {
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        if (firstName != null) {
            user.setFname(firstName);
        }
        if (lastName != null) {
            user.setLname(lastName);
        }
        if (telephoneNum != null) {
            user.setMobile(telephoneNum);
        }
        if (toursState != null) {
            user.setToursState(toursState.intValue());
        }
        this.userFacade.update(user);
        return user;
    }

    public SshKeyDTO addSshKey(int id, String name, String sshKey) {
        SshKeys key = new SshKeys();
        key.setSshKeysPK(new SshKeysPK(id, name));
        key.setPublicKey(sshKey);
        this.sshKeysBean.persist(key);
        return new SshKeyDTO(key);
    }

    public void removeSshKey(int id, String name) {
        this.sshKeysBean.removeByIdName(id, name);
    }

    public List<SshKeyDTO> getSshKeys(int id) {
        List<SshKeys> keys = this.sshKeysBean.findAllById(id);
        ArrayList<SshKeyDTO> dtos = new ArrayList<SshKeyDTO>();
        for (SshKeys sshKey : keys) {
            dtos.add(new SshKeyDTO(sshKey));
        }
        return dtos;
    }

    public String generateUsername(String email) {
        int count;
        if (email == null) {
            throw new IllegalArgumentException("Email is null");
        }
        String emailUsername = email.substring(0, email.lastIndexOf("@")).toLowerCase();
        String baseUsername = emailUsername.replaceAll("[^a-z0-9]", "");
        baseUsername = baseUsername.length() <= 8 ? baseUsername + StringUtils.repeat((String)"0", (int)(8 - baseUsername.length())) : baseUsername.substring(0, 8);
        Users user = this.userFacade.findByUsername(baseUsername);
        if (user == null) {
            return baseUsername;
        }
        String testUname = "";
        String suffix = "";
        for (count = 1; user != null && count < 1000; ++count) {
            suffix = String.valueOf(count);
            testUname = baseUsername.substring(0, 8 - suffix.length());
            user = this.userFacade.findByUsername(testUname + suffix);
        }
        if (count == 1000) {
            throw new IllegalStateException("You cannot register with this email address. Pick another.");
        }
        return testUname + suffix;
    }

    public byte[] changeTwoFactor(Users user, String password) throws UserException {
        if (user == null) {
            throw new IllegalArgumentException("User was not provided.");
        }
        if (!this.authController.validatePassword(user, password)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        byte[] qr_code = null;
        if (user.getTwoFactor()) {
            user.setTwoFactor(false);
            this.userFacade.update(user);
        } else {
            try {
                user.setTwoFactor(true);
                this.userFacade.update(user);
                qr_code = QRCodeGenerator.getQRCodeBytes(user.getEmail(), "hops.io", user.getSecret());
            }
            catch (WriterException | IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                throw new UserException(RESTCodes.UserErrorCode.TWO_FA_ENABLE_ERROR, Level.SEVERE, "user: " + user.getUsername(), ex.getMessage(), ex);
            }
        }
        return qr_code;
    }

    public byte[] getQRCode(Users user, String password) throws UserException {
        if (user == null) {
            throw new IllegalArgumentException("User was not provided");
        }
        if (!this.authController.validatePassword(user, password)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        return this.getQrCode(user);
    }

    public byte[] getQrCode(Users user) {
        byte[] qr_code = null;
        if (user.getTwoFactor()) {
            try {
                qr_code = QRCodeGenerator.getQRCodeBytes(user.getEmail(), "hops.io", user.getSecret());
            }
            catch (WriterException | IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        return qr_code;
    }

    public void registerGroup(Users uid, int gidNumber) {
        BbcGroup bbcGroup = (BbcGroup)this.bbcGroupFacade.find(gidNumber);
        uid.getBbcGroupCollection().add(bbcGroup);
        this.userFacade.update(uid);
    }

    public void registerAddress(Users user) {
        Address add = new Address();
        add.setAddress1("-");
        add.setAddress2("-");
        add.setAddress3("-");
        add.setState("-");
        add.setCity("-");
        add.setCountry("-");
        add.setPostalcode("-");
        user.setAddress(add);
        this.userFacade.persist(user);
    }

    public void increaseLockNum(int id, int val) {
        Users p = (Users)this.userFacade.find(id);
        if (p != null) {
            p.setFalseLogin(val);
            this.userFacade.update(p);
        }
    }

    public void setOnline(int id, int val) {
        Users p = (Users)this.userFacade.find(id);
        p.setIsonline(val);
        this.userFacade.update(p);
    }

    public void resetLock(int id) {
        Users p = (Users)this.userFacade.find(id);
        p.setFalseLogin(0);
        this.userFacade.update(p);
    }

    public void changeAccountStatus(int id, String note, UserAccountStatus status) throws UserException {
        Users p = (Users)this.userFacade.find(id);
        if (p != null) {
            if (UserAccountStatus.ACTIVATED_ACCOUNT.equals((Object)status)) {
                p.setFalseLogin(0);
                if (p.getBbcGroupCollection() == null || p.getBbcGroupCollection().isEmpty()) {
                    BbcGroup group = this.bbcGroupFacade.findByGroupName("HOPS_USER");
                    ArrayList<BbcGroup> groups = new ArrayList<BbcGroup>();
                    groups.add(group);
                    p.setBbcGroupCollection(groups);
                }
            }
            p.setNotes(note);
            p.setStatus(status);
            this.userFacade.update(p);
            try {
                this.emailBean.sendEmail(p.getEmail(), Message.RecipientType.TO, "Your Hopsworks account status was changed", UserAccountsEmailMessages.accountStatusChangeMessage(status.getUserStatus()));
            }
            catch (MessagingException messagingException) {}
        } else {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
    }

    public void updateStatus(Users id, UserAccountStatus stat) {
        id.setStatus(stat);
        this.userFacade.update(id);
    }

    public void updateSecret(Users user, String sec) {
        user.setSecret(sec);
        this.userFacade.update(user);
    }

    public void increaseNumCreatedProjects(int id) {
        Users u = (Users)this.userFacade.find(id);
        u.setNumCreatedProjects(Integer.valueOf(u.getNumCreatedProjects() + 1));
        u.setNumActiveProjects(Integer.valueOf(u.getNumActiveProjects() + 1));
        this.userFacade.update(u);
    }

    public void decrementNumProjectsCreated(int id) {
        Users u = (Users)this.userFacade.find(id);
        int n = u.getNumCreatedProjects();
        if (n > 0) {
            u.setNumCreatedProjects(Integer.valueOf(n - 1));
            this.userFacade.update(u);
        }
    }

    public void decrementNumActiveProjects(int id) {
        Users u = (Users)this.userFacade.find(id);
        int n = u.getNumActiveProjects();
        if (n > 0) {
            u.setNumActiveProjects(Integer.valueOf(n - 1));
            this.userFacade.update(u);
        }
    }

    public boolean isUsernameTaken(String username) {
        return this.userFacade.findByEmail(username) != null;
    }

    public boolean isUserInRole(Users user, String groupName) {
        if (user == null || groupName == null) {
            return false;
        }
        BbcGroup group = this.bbcGroupFacade.findByGroupName(groupName);
        if (group == null) {
            return false;
        }
        return user.getBbcGroupCollection().contains(group);
    }

    public List<String> getUserRoles(Users p) {
        Collection groupList = p.getBbcGroupCollection();
        ArrayList<String> list = new ArrayList<String>();
        for (BbcGroup g : groupList) {
            list.add(g.getGroupName());
        }
        return list;
    }

    public void updateMaxNumProjs(Integer id, int maxNumProjs) {
        Users user = (Users)this.userFacade.find(id);
        user.setMaxNumProjects(Integer.valueOf(maxNumProjs));
        this.userFacade.update(user);
    }

    public void deleteUser(Users u) throws UserException {
        if (u != null) {
            List<RolesAudit> results = this.rolesAuditFacade.findByTarget(u);
            for (RolesAudit next : results) {
                this.rolesAuditFacade.remove(next);
            }
            List<AccountAudit> resultsAA = this.accountAuditFacade.findByTarget(u);
            for (AccountAudit next : resultsAA) {
                this.accountAuditFacade.remove(next);
            }
            try {
                this.userFacade.removeByEmail(u.getEmail());
            }
            catch (ConstraintViolationException cve) {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_DELETION_ERROR, Level.FINE, "User that initiated audit log on another account can not be deleted.", cve.getMessage());
            }
        }
    }

    public Users getUserById(Integer id) throws UserException {
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        Users user = (Users)this.userFacade.find(id);
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        return user;
    }

    public GenericEntity<List<BbcGroup>> getAllGroups() {
        List<BbcGroup> list = this.bbcGroupFacade.findAll();
        return new GenericEntity<List<BbcGroup>>(list){};
    }
}

