/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hdfs;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;

@Singleton
public class UserGroupInformationService {
    private static final Logger logger = Logger.getLogger(UserGroupInformationService.class.getName());
    private ConcurrentMap<String, UserGroupInformation> proxyCache = new ConcurrentHashMap<String, UserGroupInformation>();
    private ConcurrentMap<String, UserGroupInformation> remoteCache = new ConcurrentHashMap<String, UserGroupInformation>();

    @PreDestroy
    public void preDestroy() {
        for (UserGroupInformation ugi : this.proxyCache.values()) {
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
            catch (IOException ioe) {
                logger.log(Level.INFO, "Exception occurred while closing filesystems for " + ugi.getUserName(), ioe);
            }
        }
        this.proxyCache.clear();
    }

    public UserGroupInformation getProxyUser(String user) throws IOException {
        this.proxyCache.putIfAbsent(user, UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser()));
        return (UserGroupInformation)this.proxyCache.get(user);
    }

    public UserGroupInformation getRemoteUser(String user) throws IOException {
        this.remoteCache.putIfAbsent(user, UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser()));
        return (UserGroupInformation)this.remoteCache.get(user);
    }

    public UserGroupInformation remove(String username) {
        return (UserGroupInformation)this.proxyCache.remove(username);
    }
}

