/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core;

import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHelper;
import io.hops.hopsworks.common.provenance.core.elastic.ProvElasticController;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.rest.RestStatus;
import org.javatuples.Pair;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProvenanceCleanerController {
    private static final Logger LOGGER = Logger.getLogger(ProvenanceCleanerController.class.getName());
    @EJB
    private ProvElasticController client;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private InodeFacade inodeFacade;

    public Pair<Integer, String> indexCleanupRound(String nextToCheck, Integer limit) throws ProvenanceException {
        String[] indices = this.getAllIndices();
        int cleaned = 0;
        String nextToCheckAux = "";
        for (String indexName : indices) {
            Project project;
            if (cleaned > limit) {
                nextToCheckAux = indexName;
                break;
            }
            if (indexName.compareTo(nextToCheck) < 0 || (project = this.getProject(indexName)) != null) continue;
            LOGGER.log(Level.FINE, "deleting prov index:{0} with no corresponding project", indexName);
            this.deleteProvIndex(indexName);
            ++cleaned;
        }
        return Pair.with((Object)cleaned, (Object)nextToCheckAux);
    }

    private Project getProject(String indexName) throws ProvenanceException {
        Long inodeId;
        int endIndex = indexName.indexOf("__file_prov");
        String sInodeId = indexName.substring(0, endIndex);
        try {
            inodeId = Long.parseLong(sInodeId);
        }
        catch (NumberFormatException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "error extracting project from prov index name - format error", e.getMessage(), (Throwable)e);
        }
        Inode inode = this.inodeFacade.findById(inodeId);
        if (inode == null) {
            return null;
        }
        Project project = this.projectFacade.findByInodeId(inode.getInodePK().getParentId(), inode.getInodePK().getName());
        return project;
    }

    private String[] getAllIndices() throws ProvenanceException {
        try {
            String indexRegex = "*__file_prov";
            GetIndexRequest request = new GetIndexRequest(new String[]{indexRegex});
            GetIndexResponse response = this.client.mngIndexGet(request);
            return response.getIndices();
        }
        catch (ElasticException e) {
            if (ElasticHelper.indexNotFound(e.getCause())) {
                return new String[0];
            }
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "error querying elastic", e.getMessage(), (Throwable)e);
        }
    }

    private void deleteProvIndex(String indexName) {
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        try {
            AcknowledgedResponse acknowledgedResponse = this.client.mngIndexDelete(request);
        }
        catch (ElasticException e) {
            ElasticsearchException ex;
            if (e.getCause() instanceof ElasticsearchException && (ex = (ElasticsearchException)e.getCause()).status() == RestStatus.NOT_FOUND) {
                LOGGER.log(Level.INFO, "trying to delete index:{0} - does not exist", indexName);
                return;
            }
            LOGGER.log(Level.WARNING, "trying to delete index:{0}", e.getStackTrace());
        }
    }
}

