/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.query;

import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.query.FsQueryDTO;
import io.hops.hopsworks.common.featurestore.query.Join;
import io.hops.hopsworks.common.featurestore.query.JoinDTO;
import io.hops.hopsworks.common.featurestore.query.Query;
import io.hops.hopsworks.common.featurestore.query.QueryDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.dialect.SparkSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ConstructorController {
    @EJB
    private FeaturegroupFacade featuregroupFacade;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeaturegroupController featuregroupController;
    private static final String ALL_FEATURES = "*";

    public ConstructorController() {
    }

    protected ConstructorController(FeaturegroupController featuregroupController, FeaturestoreFacade featurestoreFacade, FeaturegroupFacade featuregroupFacade) {
        this.featuregroupController = featuregroupController;
        this.featurestoreFacade = featurestoreFacade;
        this.featuregroupFacade = featuregroupFacade;
    }

    public FsQueryDTO construct(QueryDTO queryDTO) throws FeaturestoreException {
        Query query = this.convertQueryDTO(queryDTO, 0);
        FsQueryDTO fsQueryDTO = new FsQueryDTO();
        fsQueryDTO.setQuery(this.generateSQL(query, false));
        fsQueryDTO.setQueryOnline(this.generateSQL(query, true));
        return fsQueryDTO;
    }

    protected Query convertQueryDTO(QueryDTO queryDTO, int fgId) throws FeaturestoreException {
        Featuregroup fg = this.validateFeaturegroupDTO(queryDTO.getLeftFeatureGroup());
        String fgAs = this.generateAs(fgId++);
        String featureStore = this.featurestoreFacade.getHiveDbName(fg.getFeaturestore().getHiveDbId());
        String projectName = fg.getFeaturestore().getProject().getName();
        List<FeatureDTO> availableFeatures = this.featuregroupController.getFeatures(fg);
        List<FeatureDTO> requestedFeatures = this.validateFeatures(fg, fgAs, queryDTO.getLeftFeatures(), availableFeatures);
        Query query = new Query(featureStore, projectName, fg, fgAs, requestedFeatures, availableFeatures);
        if (queryDTO.getJoins() != null && !queryDTO.getJoins().isEmpty()) {
            query.setJoins(this.convertJoins(query, queryDTO.getJoins(), fgId));
        }
        return query;
    }

    private String generateAs(int id) {
        return "fg" + id;
    }

    private Featuregroup validateFeaturegroupDTO(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO == null) {
            throw new IllegalArgumentException("Feature group not specified");
        }
        Featuregroup featuregroup = this.featuregroupFacade.findById(featuregroupDTO.getId());
        if (featuregroup == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.FINE, "Could not find feature group with ID" + featuregroupDTO.getId());
        }
        return featuregroup;
    }

    protected List<FeatureDTO> validateFeatures(Featuregroup fg, String as, List<FeatureDTO> requestedFeatures, List<FeatureDTO> availableFeatures) throws FeaturestoreException {
        ArrayList<FeatureDTO> featureList = new ArrayList<FeatureDTO>();
        availableFeatures.forEach(f -> f.setFeaturegroup(as));
        if (requestedFeatures == null || requestedFeatures.isEmpty()) {
            throw new IllegalArgumentException("Invalid requested features");
        }
        if (requestedFeatures.size() == 1 && requestedFeatures.get(0).getName().equals(ALL_FEATURES)) {
            featureList.addAll(availableFeatures);
        } else {
            for (FeatureDTO requestedFeature : requestedFeatures) {
                featureList.add(availableFeatures.stream().filter(af -> af.getName().equals(requestedFeature.getName())).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_DOES_NOT_EXIST, Level.FINE, "Feature: " + requestedFeature.getName() + " not found in feature group: " + fg.getName())));
            }
        }
        return featureList;
    }

    private List<Join> convertJoins(Query leftQuery, List<JoinDTO> joinDTOS, int fgId) throws FeaturestoreException {
        ArrayList<Join> joins = new ArrayList<Join>();
        for (JoinDTO joinDTO : joinDTOS) {
            if (joinDTO.getQuery() == null) {
                throw new IllegalArgumentException("Subquery not specified");
            }
            Query rightQuery = this.convertQueryDTO(joinDTO.getQuery(), fgId++);
            if (joinDTO.getOn() != null && !joinDTO.getOn().isEmpty()) {
                joins.add(this.extractOn(leftQuery, rightQuery, joinDTO.getOn(), joinDTO.getType()));
                continue;
            }
            if (joinDTO.getLeftOn() != null && !joinDTO.getLeftOn().isEmpty()) {
                joins.add(this.extractLeftRightOn(leftQuery, rightQuery, joinDTO.getLeftOn(), joinDTO.getRightOn(), joinDTO.getType()));
                continue;
            }
            joins.add(this.extractPrimaryKeysJoin(leftQuery, rightQuery, joinDTO.getType()));
        }
        return joins;
    }

    protected Join extractOn(Query leftQuery, Query rightQuery, List<FeatureDTO> on, JoinType joinType) throws FeaturestoreException {
        for (FeatureDTO joinFeature : on) {
            this.checkFeatureExists(leftQuery, joinFeature);
            this.checkFeatureExists(rightQuery, joinFeature);
        }
        return new Join(leftQuery, rightQuery, on, joinType);
    }

    protected Join extractLeftRightOn(Query leftQuery, Query rightQuery, List<FeatureDTO> leftOn, List<FeatureDTO> rightOn, JoinType joinType) throws FeaturestoreException {
        if (leftOn.size() != rightOn.size()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.LEFT_RIGHT_ON_DIFF_SIZES, Level.FINE);
        }
        for (FeatureDTO feature : leftOn) {
            this.checkFeatureExists(leftQuery, feature);
        }
        for (FeatureDTO feature : rightOn) {
            this.checkFeatureExists(rightQuery, feature);
        }
        return new Join(leftQuery, rightQuery, leftOn, rightOn, joinType);
    }

    protected Join extractPrimaryKeysJoin(Query leftQuery, Query rightQuery, JoinType joinType) throws FeaturestoreException {
        ArrayList<FeatureDTO> joinFeatures = new ArrayList<FeatureDTO>();
        leftQuery.getAvailableFeatures().stream().filter(FeatureDTO::getPrimary).forEach(lf -> joinFeatures.addAll(rightQuery.getAvailableFeatures().stream().filter(rf -> rf.getName().equals(lf.getName()) && rf.getPrimary() != false).collect(Collectors.toList())));
        if (joinFeatures.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.NO_PK_JOINING_KEYS, Level.FINE, leftQuery.getFeaturegroup().getName() + " and: " + rightQuery.getFeaturegroup().getName());
        }
        return new Join(leftQuery, rightQuery, joinFeatures, joinType);
    }

    private void checkFeatureExists(Query query, FeatureDTO feature) throws FeaturestoreException {
        if (query.getAvailableFeatures().stream().noneMatch(f -> f.getName().equals(feature.getName()))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_DOES_NOT_EXIST, Level.FINE, "Could not find Join feature " + feature.getName() + " in feature group: " + query.getFeaturegroup().getName());
        }
    }

    public void removeDuplicateColumns(Query query) {
        for (Join join : query.getJoins()) {
            if (join.getRightOn() != null && !join.getRightOn().isEmpty()) continue;
            List<FeatureDTO> rightFeatureList = join.getRightQuery().getFeatures();
            List joinFeatureNames = join.getOn().stream().map(FeatureDTO::getName).collect(Collectors.toList());
            List<FeatureDTO> filteredRightFeatures = rightFeatureList.stream().filter(f -> !joinFeatureNames.contains(f.getName())).collect(Collectors.toList());
            join.getRightQuery().setFeatures(filteredRightFeatures);
        }
    }

    public String generateSQL(Query query, boolean online) {
        if (query.getJoins() != null) {
            this.removeDuplicateColumns(query);
        }
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        for (FeatureDTO f : this.collectFeatures(query)) {
            selectList.add((SqlNode)new SqlIdentifier(Arrays.asList("`" + f.getFeaturegroup() + "`", "`" + f.getName() + "`"), SqlParserPos.ZERO));
        }
        SqlNode joinNode = null;
        joinNode = query.getJoins() == null || query.getJoins().isEmpty() ? this.generateTableNode(query, online) : this.buildJoinNode(query, query.getJoins().size() - 1, online);
        SqlSelect select = new SqlSelect(SqlParserPos.ZERO, null, selectList, joinNode, null, null, null, null, null, null, null);
        return select.toSqlString((SqlDialect)new SparkSqlDialect(SqlDialect.EMPTY_CONTEXT)).getSql();
    }

    private SqlNode buildJoinNode(Query query, int i, boolean online) {
        if (i < 0) {
            return this.generateTableNode(query, online);
        }
        return new SqlJoin(SqlParserPos.ZERO, this.buildJoinNode(query, i - 1, online), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), SqlLiteral.createSymbol((Enum)query.getJoins().get(i).getJoinType(), (SqlParserPos)SqlParserPos.ZERO), this.generateTableNode(query.getJoins().get(i).getRightQuery(), online), SqlLiteral.createSymbol((Enum)JoinConditionType.ON, (SqlParserPos)SqlParserPos.ZERO), query.getJoins().get(i).getCondition());
    }

    protected List<FeatureDTO> collectFeatures(Query query) {
        ArrayList<FeatureDTO> features = new ArrayList<FeatureDTO>(query.getFeatures());
        if (query.getJoins() != null) {
            query.getJoins().forEach(join -> features.addAll(this.collectFeatures(join.getRightQuery())));
        }
        return features;
    }

    private SqlNode generateTableNode(Query query, boolean online) {
        ArrayList<String> tableIdentifierStr = new ArrayList<String>();
        if (online) {
            tableIdentifierStr.add("`" + query.getProject() + "`");
        } else {
            tableIdentifierStr.add("`" + query.getFeatureStore() + "`");
        }
        tableIdentifierStr.add("`" + query.getFeaturegroup().getName() + "_" + query.getFeaturegroup().getVersion() + "`");
        SqlNodeList asNodeList = new SqlNodeList(Arrays.asList(new SqlIdentifier(tableIdentifierStr, SqlParserPos.ZERO), new SqlIdentifier("`" + query.getAs() + "`", SqlParserPos.ZERO)), SqlParserPos.ZERO);
        return SqlStdOperatorTable.AS.createCall(asNodeList);
    }
}

