/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.app;

import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.EnumSet;
import java.util.logging.Level;
import org.javatuples.Pair;

public class ProvAParser {
    public static Pair<ProvParser.Field, Object> extractFilter(String param) throws ProvenanceException {
        String rawVal;
        String rawFilter;
        if (param.contains(":")) {
            int aux = param.indexOf(58);
            rawFilter = param.substring(0, aux);
            rawVal = param.substring(aux + 1);
        } else {
            rawFilter = param;
            rawVal = "true";
        }
        ProvParser.Field field = ProvAParser.extractField(rawFilter);
        Object val = field.filterValParser().apply(rawVal);
        return Pair.with((Object)field, val);
    }

    public static ProvParser.Field extractField(String val) throws ProvenanceException {
        try {
            return Field.valueOf(val.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            StringBuilder supported = new StringBuilder();
            supported.append(EnumSet.allOf(Field.class));
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "sort param" + val + " not supported - supported:" + supported, "exception extracting SortBy param", (Throwable)e);
        }
    }

    public static class AppStateValParser
    implements ProvParser.ValParser<Provenance.AppState> {
        @Override
        public Provenance.AppState apply(Object o) throws ProvenanceException {
            if (o instanceof String) {
                try {
                    return Provenance.AppState.valueOf((String)o);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    String msg = "expected string-ified version of AppState - found: " + o;
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg, msg, (Throwable)e);
                }
            }
            String msg = "expected string-ified version of AppState - found " + o.getClass();
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
        }
    }

    public static enum Field implements ProvParser.Field
    {
        APP_STATE(BaseField.APP_STATE, new AppStateValParser()),
        APP_ID(BaseField.APP_ID, new ProvParser.StringValParser()),
        TIMESTAMP(BaseField.TIMESTAMP, new ProvParser.LongValParser()),
        APP_NAME(BaseField.APP_NAME, new ProvParser.StringValParser()),
        APP_USER(BaseField.APP_USER, new ProvParser.StringValParser()),
        R_TIMESTAMP(BaseField.READABLE_TIMESTAMP, new ProvParser.StringValParser());

        public final BaseField elasticField;
        public final ProvParser.ValParser valParser;

        private Field(BaseField elasticField, ProvParser.ValParser valParser) {
            this.elasticField = elasticField;
            this.valParser = valParser;
        }

        @Override
        public String elasticFieldName() {
            return this.elasticField.toString().toLowerCase();
        }

        @Override
        public String queryFieldName() {
            return this.name().toLowerCase();
        }

        @Override
        public ProvParser.FilterType filterType() {
            return ProvParser.FilterType.EXACT;
        }

        public ProvParser.ValParser filterValParser() {
            return this.valParser;
        }
    }

    public static enum BaseField implements ProvParser.ElasticField
    {
        APP_STATE,
        APP_ID,
        TIMESTAMP,
        APP_NAME,
        APP_USER,
        READABLE_TIMESTAMP;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

