/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.online;

import com.google.common.base.Strings;
import com.logicalclocks.shaded.org.apache.commons.lang3.StringUtils;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeaturegroupPreview;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreFacade;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class OnlineFeaturegroupController {
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private OnlineFeaturestoreFacade onlineFeaturestoreFacade;
    @EJB
    private Settings settings;
    private static final List<String> MYSQL_TYPES = Arrays.asList("INT", "TINYINT", "SMALLINT", "MEDIUMINT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL", "DATE", "DATETIME", "TIMESTAMP", "TIME", "YEAR", "CHAR", "BLOB", "TEXT", "TINYBLOB", "TINYTEXT", "MEDIUMBLOB", "MEDIUMTEXT", "LONGBLOB", "LONGTEXT");
    private static final String VARBINARY = "VARBINARY";

    public void dropMySQLTable(Featuregroup featuregroup, Project project, Users user) throws SQLException, FeaturestoreException {
        String query = "DROP TABLE " + featuregroup.getName() + "_" + featuregroup.getVersion() + ";";
        this.onlineFeaturestoreController.executeUpdateJDBCQuery(query, this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject()), project, user);
    }

    public void createMySQLTable(Featurestore featurestore, String tableName, List<FeatureDTO> features, Project project, Users user) throws FeaturestoreException, SQLException {
        String dbName = this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featurestore.getProject());
        String createStatement = this.buildCreateStatement(dbName, tableName, features);
        this.onlineFeaturestoreController.executeUpdateJDBCQuery(createStatement, dbName, project, user);
    }

    private String buildCreateStatement(String dbName, String tableName, List<FeatureDTO> features) {
        StringBuilder createStatement = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        createStatement.append(dbName).append(".").append(tableName).append("(");
        for (FeatureDTO feature : features) {
            createStatement.append(feature.getName()).append(" ").append(this.getOnlineType(feature)).append(",");
        }
        List pkFeatures = features.stream().filter(FeatureDTO::getPrimary).collect(Collectors.toList());
        if (!pkFeatures.isEmpty()) {
            createStatement.append("PRIMARY KEY (");
            createStatement.append(StringUtils.join((Iterable)pkFeatures.stream().map(FeatureDTO::getName).collect(Collectors.toList()), (String)","));
            createStatement.append(")");
        }
        createStatement.append(")");
        createStatement.append("ENGINE=ndbcluster ").append("COMMENT='NDB_TABLE=READ_BACKUP=1'");
        if (!Strings.isNullOrEmpty((String)this.settings.getOnlineFeatureStoreTableSpace())) {
            createStatement.append("/*!50100 TABLESPACE `").append(this.settings.getOnlineFeatureStoreTableSpace()).append("` STORAGE DISK */");
        }
        return createStatement.toString();
    }

    private String getOnlineType(FeatureDTO featureDTO) {
        if (!Strings.isNullOrEmpty((String)featureDTO.getOnlineType())) {
            return featureDTO.getOnlineType().toLowerCase();
        }
        if (MYSQL_TYPES.contains(featureDTO.getType().toUpperCase())) {
            return featureDTO.getType().toLowerCase();
        }
        if (featureDTO.getType().equalsIgnoreCase("boolean")) {
            return "tinyint";
        }
        if (featureDTO.getType().equalsIgnoreCase("string")) {
            return "varchar(1000)";
        }
        return VARBINARY;
    }

    public FeaturegroupPreview getFeaturegroupPreview(Featuregroup featuregroup, Project project, Users user, int limit) throws FeaturestoreException, SQLException {
        String tblName = featuregroup.getName() + "_" + featuregroup.getVersion();
        String query = "SELECT * FROM " + tblName + " LIMIT " + limit;
        String db = this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject());
        try {
            return this.onlineFeaturestoreController.executeReadJDBCQuery(query, db, project, user);
        }
        catch (Exception e) {
            return this.onlineFeaturestoreController.executeReadJDBCQuery(query, db, project, user);
        }
    }

    public String getFeaturegroupSchema(Featuregroup featuregroup) {
        return this.onlineFeaturestoreFacade.getMySQLSchema(this.getTblName(featuregroup), this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject()));
    }

    public List<FeatureDTO> getFeaturegroupFeatures(Featuregroup featuregroup) {
        return this.onlineFeaturestoreFacade.getMySQLFeatures(this.getTblName(featuregroup), this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject()));
    }

    public BigInteger getFeaturegroupSize(Featuregroup featuregroup) {
        return this.onlineFeaturestoreFacade.getTblSize(this.getTblName(featuregroup), this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featuregroup.getFeaturestore().getProject()));
    }

    private String getTblName(Featuregroup featuregroup) {
        return featuregroup.getName() + "_" + featuregroup.getVersion();
    }
}

