/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security.secrets;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretPlaintext;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.project.ProjectController;
import io.hops.hopsworks.common.security.CertificatesMgmService;
import io.hops.hopsworks.common.security.SymmetricEncryptionDescriptor;
import io.hops.hopsworks.common.security.SymmetricEncryptionService;
import io.hops.hopsworks.common.util.DateUtils;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.persistence.entity.user.security.secrets.SecretId;
import io.hops.hopsworks.persistence.entity.user.security.secrets.VisibilityType;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class SecretsController {
    private static final Logger LOG = Logger.getLogger(SecretsController.class.getName());
    @EJB
    private SecretsFacade secretsFacade;
    @EJB
    private SymmetricEncryptionService symmetricEncryptionService;
    @EJB
    private CertificatesMgmService certificatesMgmService;
    @EJB
    private UserFacade userFacade;
    @EJB
    private ProjectController projectController;
    @EJB
    private ProjectFacade projectFacade;

    public void add(Users user, String secretName, String secret, VisibilityType visibilityType, Integer projectIdScope) throws UserException {
        this.checkIfUserIsNull(user);
        this.checkIfNameIsNullOrEmpty(secretName);
        if (Strings.isNullOrEmpty((String)secretName) || Strings.isNullOrEmpty((String)secret)) {
            throw new UserException(RESTCodes.UserErrorCode.SECRET_EMPTY, Level.FINE, "Secret value is either null or empty", "Secret name or value is empty or null");
        }
        SecretId id = new SecretId(user.getUid(), secretName);
        Secret storedSecret = this.secretsFacade.findById(id);
        if (storedSecret != null) {
            throw new UserException(RESTCodes.UserErrorCode.SECRET_EXISTS, Level.FINE, "Secret already exists", "Secret with name " + secretName + " already exists for user " + user.getUsername());
        }
        try {
            storedSecret = new Secret(id, this.encryptSecret(secret), DateUtils.localDateTime2Date(DateUtils.getNow()));
            storedSecret.setVisibilityType(visibilityType);
            if (visibilityType.equals((Object)VisibilityType.PRIVATE)) {
                storedSecret.setProjectIdScope(null);
            } else {
                if (projectIdScope == null) {
                    throw new UserException(RESTCodes.UserErrorCode.SECRET_EMPTY, Level.FINE, "Secret visibility is PROJECT but there is not Project ID scope", "Project scope for shared secret " + secretName + " is null");
                }
                storedSecret.setProjectIdScope(projectIdScope);
            }
            this.secretsFacade.persist(storedSecret);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error encrypting secret", "Could not encrypt Secret " + secretName, (Throwable)ex);
        }
    }

    public List<SecretPlaintext> getAllForUser(Users user) throws UserException {
        this.checkIfUserIsNull(user);
        List<Secret> secrets = this.secretsFacade.findAllForUser(user);
        return secrets.stream().map(c -> this.constructSecretView(user, (Secret)c)).collect(Collectors.toList());
    }

    public void delete(Users user, String secretName) throws UserException {
        this.checkIfUserIsNull(user);
        this.checkIfNameIsNullOrEmpty(secretName);
        SecretId secretId = new SecretId(user.getUid(), secretName);
        this.secretsFacade.deleteSecret(secretId);
    }

    public void deleteAll(Users user) throws UserException {
        this.checkIfUserIsNull(user);
        this.secretsFacade.deleteSecretsForUser(user);
    }

    public List<Secret> getAllCiphered() {
        return this.secretsFacade.findAll();
    }

    public SecretPlaintext get(Users user, String secretName) throws UserException {
        this.checkIfUserIsNull(user);
        this.checkIfNameIsNullOrEmpty(secretName);
        SecretId id = new SecretId(user.getUid(), secretName);
        Secret storedSecret = this.secretsFacade.findById(id);
        this.checkIfSecretIsNull(storedSecret, secretName, user);
        try {
            return this.decrypt(user, storedSecret);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error decrypting Secret", "Could not decrypt Secret " + secretName, (Throwable)ex);
        }
    }

    public SecretPlaintext getShared(Users caller, String ownerUsername, String secretName) throws UserException, ServiceException, ProjectException {
        this.checkIfUserIsNull(caller);
        this.checkIfNameIsNullOrEmpty(secretName);
        if (Strings.isNullOrEmpty((String)ownerUsername)) {
            throw new UserException(RESTCodes.UserErrorCode.USER_DOES_NOT_EXIST, Level.FINE, "Owner of Secret is empty", caller.getUsername() + " did not provide Owner for shared secret " + secretName);
        }
        Users ownerUser = this.userFacade.findByUsername(ownerUsername);
        this.checkIfUserIsNull(ownerUser);
        Secret storedSecret = this.secretsFacade.findById(new SecretId(ownerUser.getUid(), secretName));
        this.checkIfSecretIsNull(storedSecret, secretName, ownerUser);
        if (storedSecret.getVisibilityType() == null || storedSecret.getVisibilityType().equals((Object)VisibilityType.PRIVATE)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCESS_CONTROL, Level.FINE, "Secret is Private", "User " + caller.getUsername() + " requested PRIVATE secret <" + ownerUser.getUid() + ", " + secretName + ">");
        }
        Integer projectId = storedSecret.getProjectIdScope();
        if (projectId == null) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_GENERIC_ERROR, Level.WARNING, "Visibility's Project ID is empty", "Secret " + secretName + " visibility is PROJECT but Project ID is null");
        }
        Project project = this.projectFacade.find(projectId);
        if (project == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "Project with ID " + projectId + " does not exist!", "User " + caller.getUsername() + " requested shared Secret " + secretName + " but Project with ID " + projectId + "does not exist");
        }
        for (ProjectTeam projectTeam : project.getProjectTeamCollection()) {
            if (!caller.getUid().equals(projectTeam.getUser().getUid())) continue;
            try {
                return this.decrypt(ownerUser, storedSecret);
            }
            catch (IOException | GeneralSecurityException ex) {
                throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error decrypting Secret", "Could not decrypt Secret " + secretName, (Throwable)ex);
            }
        }
        throw new UserException(RESTCodes.UserErrorCode.ACCESS_CONTROL, Level.FINE, "Not authorized to access Secret " + secretName, "User " + caller.getUsername() + " tried to access shared Secret " + secretName + " but they are not member of Project " + project.getName());
    }

    private void checkIfUserIsNull(Users user) throws UserException {
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_DOES_NOT_EXIST, Level.FINE);
        }
    }

    private void checkIfNameIsNullOrEmpty(String name) throws UserException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new UserException(RESTCodes.UserErrorCode.SECRET_EMPTY, Level.FINE, "Secret is either null or empty", "Secret name or key is empty or null");
        }
    }

    private void checkIfSecretIsNull(Secret secret, String secretName, Users user) throws UserException {
        if (secret == null) {
            throw new UserException(RESTCodes.UserErrorCode.SECRET_EMPTY, Level.FINE, "Could not find Secret for user", "Could not find Secret with name " + secretName + " for user " + user.getUsername());
        }
    }

    private SecretPlaintext constructSecretView(Users user, Secret ciphered) {
        return SecretPlaintext.newInstance(user, ciphered.getId().getName(), "", ciphered.getAddedOn(), ciphered.getVisibilityType());
    }

    private SecretPlaintext decrypt(Users user, Secret ciphered) throws IOException, GeneralSecurityException {
        String password = this.certificatesMgmService.getMasterEncryptionPassword();
        byte[][] split = this.symmetricEncryptionService.splitPayloadFromCryptoPrimitives(ciphered.getSecret());
        SymmetricEncryptionDescriptor descriptor = new SymmetricEncryptionDescriptor.Builder().setPassword(password).setSalt(split[0]).setIV(split[1]).setInput(split[2]).build();
        descriptor = this.symmetricEncryptionService.decrypt(descriptor);
        byte[] plaintext = descriptor.getOutput();
        return SecretPlaintext.newInstance(user, ciphered.getId().getName(), this.bytes2string(plaintext), ciphered.getAddedOn());
    }

    private byte[] encryptSecret(String secret) throws IOException, GeneralSecurityException {
        String password = this.certificatesMgmService.getMasterEncryptionPassword();
        SymmetricEncryptionDescriptor descriptor = new SymmetricEncryptionDescriptor.Builder().setInput(this.string2bytes(secret)).setPassword(password).build();
        descriptor = this.symmetricEncryptionService.encrypt(descriptor);
        return this.symmetricEncryptionService.mergePayloadWithCryptoPrimitives(descriptor.getSalt(), descriptor.getIv(), descriptor.getOutput());
    }

    private byte[] string2bytes(String str) {
        return str.getBytes(Charset.defaultCharset());
    }

    private String bytes2string(byte[] bytes) {
        return new String(bytes, Charset.defaultCharset());
    }
}

