/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.project;

import io.hops.hopsworks.common.project.QuotasDTO;
import io.hops.hopsworks.persistence.entity.hdfs.inode.InodeView;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ProjectDTO {
    private Integer projectId;
    private String projectName;
    private String owner;
    private String description;
    private Date retentionPeriod;
    private Date created;
    private boolean archived;
    private List<String> services;
    private List<ProjectTeam> projectTeam;
    private List<InodeView> datasets;
    private Long inodeid;
    private QuotasDTO quotas;
    private String hopsExamples;

    public ProjectDTO() {
    }

    public ProjectDTO(Integer projectId, String projectName, String owner) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.owner = owner;
    }

    public ProjectDTO(Project project, Long inodeid, List<String> services, List<ProjectTeam> projectTeam, QuotasDTO quotas, String hopsExamples) {
        this.projectId = project.getId();
        this.inodeid = inodeid;
        this.projectName = project.getName();
        this.owner = project.getOwner().getEmail();
        this.retentionPeriod = project.getRetentionPeriod();
        this.created = project.getCreated();
        this.archived = project.getArchived();
        this.description = project.getDescription();
        this.services = services;
        this.projectTeam = projectTeam;
        this.quotas = quotas;
        this.hopsExamples = hopsExamples;
    }

    public ProjectDTO(Project project, Long inodeid, List<String> services, List<ProjectTeam> projectTeam, List<InodeView> datasets) {
        this.projectId = project.getId();
        this.inodeid = inodeid;
        this.projectName = project.getName();
        this.owner = project.getOwner().getEmail();
        this.retentionPeriod = project.getRetentionPeriod();
        this.created = project.getCreated();
        this.archived = project.getArchived();
        this.description = project.getDescription();
        this.services = services;
        this.projectTeam = projectTeam;
        this.datasets = datasets;
    }

    public ProjectDTO(Integer projectId, String projectName, String owner, Date retentionPeriod, Date created, boolean archived, String description, List<String> services, List<ProjectTeam> projectTeam) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.owner = owner;
        this.retentionPeriod = retentionPeriod;
        this.created = created;
        this.archived = archived;
        this.description = description;
        this.services = services;
        this.projectTeam = projectTeam;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public Long getInodeid() {
        return this.inodeid;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public void setInodeid(Long inodeid) {
        this.inodeid = inodeid;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Date getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public void setRetentionPeriod(Date retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public List<ProjectTeam> getProjectTeam() {
        return this.projectTeam;
    }

    public void setProjectTeam(List<ProjectTeam> projectTeams) {
        this.projectTeam = projectTeams;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<InodeView> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(List<InodeView> datasets) {
        this.datasets = datasets;
    }

    public QuotasDTO getQuotas() {
        return this.quotas;
    }

    public void setQuotas(QuotasDTO quotas) {
        this.quotas = quotas;
    }

    public String getHopsExamples() {
        return this.hopsExamples;
    }

    public void setHopsExamples(String hopsExamples) {
        this.hopsExamples = hopsExamples;
    }

    public String toString() {
        return "ProjectDTO{projectName=" + this.projectName + ", owner=" + this.owner + ", description=" + this.description + ", retentionPeriod=" + this.retentionPeriod + ", created=" + this.created + ", archived=" + this.archived + ", services=" + this.services + ", projectTeam=" + this.projectTeam + '}';
    }
}

