/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jobhistory;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.jobs.history.YarnApplicationattemptstate;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class YarnApplicationAttemptStateFacade
extends AbstractFacade<YarnApplicationattemptstate> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public YarnApplicationAttemptStateFacade() {
        super(YarnApplicationattemptstate.class);
    }

    public String findTrackingUrlByAppId(String applicationid) {
        if (applicationid == null) {
            return "";
        }
        TypedQuery query = this.em.createNamedQuery("YarnApplicationattemptstate.findByApplicationid", YarnApplicationattemptstate.class).setParameter("applicationid", (Object)applicationid);
        List appAttempts = query.getResultList();
        if (appAttempts != null) {
            Integer highestAttemptId = 0;
            String trackingUrl = "";
            for (YarnApplicationattemptstate a : appAttempts) {
                try {
                    String attemptId = a.getYarnApplicationattemptstatePK().getApplicationattemptid();
                    Integer attempt = Integer.parseInt(attemptId = attemptId.substring(attemptId.lastIndexOf("_") + 1, attemptId.length()));
                    if (attempt <= highestAttemptId) continue;
                    highestAttemptId = attempt;
                    trackingUrl = a.getApplicationattempttrakingurl();
                }
                catch (NumberFormatException e) {
                    return "";
                }
            }
            return trackingUrl;
        }
        return "";
    }
}

