/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.execution;

import io.hops.hopsworks.common.jobs.AsynchronousJobExecutor;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobState;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.security.UserGroupInformation;

public abstract class HopsJob {
    private static final Logger logger = Logger.getLogger(HopsJob.class.getName());
    protected Execution execution;
    protected boolean initialized = false;
    protected final AsynchronousJobExecutor services;
    protected final Jobs jobs;
    protected final Users user;
    protected final String hadoopDir;
    protected final UserGroupInformation hdfsUser;

    protected HopsJob(Jobs jobs, AsynchronousJobExecutor services, Users user, String hadoopDir) {
        if (jobs == null) {
            throw new NullPointerException("Cannot run a null Job.");
        }
        if (services == null) {
            throw new NullPointerException("Cannot run without a service provider.");
        }
        if (user == null) {
            throw new NullPointerException("A job cannot be run by a null user!");
        }
        this.jobs = jobs;
        this.services = services;
        this.user = user;
        this.hadoopDir = hadoopDir;
        try {
            this.hdfsUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Exception while trying to retrieve hadoop User Group Information: " + ex.getMessage());
        }
        logger.log(Level.INFO, "Instantiating Hops job as user: {0}", this.hdfsUser);
    }

    protected final void updateState(JobState newState) {
        this.execution = this.services.getExecutionFacade().updateState(this.execution, newState);
    }

    public void execute(String args) {
        this.execution = this.services.getExecutionFacade().updateExecutionStart(this.execution, System.currentTimeMillis());
    }

    protected abstract boolean setupJob() throws JobException;

    protected abstract void runJob(String var1);

    protected abstract void cleanup();

    public final Execution requestExecutionId() {
        return this.requestExecutionId(null);
    }

    public final Execution requestExecutionId(String args) {
        this.execution = this.services.getExecutionFacade().create(this.jobs, this.user, null, null, null, null, 0.0f, this.hdfsUser.getUserName(), args);
        this.initialized = this.execution.getId() != null;
        return this.execution;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    protected abstract void writeToLogs(String var1, Exception var2) throws IOException;

    protected abstract void writeToLogs(String var1) throws IOException;
}

