/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.s3;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorFacade;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3Connector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3ConnectorEncryptionAlgorithm;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class FeaturestoreS3ConnectorController {
    @EJB
    private FeaturestoreS3ConnectorFacade featurestoreS3ConnectorFacade;
    @EJB
    private Settings settings;

    public FeaturestoreS3ConnectorDTO createFeaturestoreS3Connector(Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException {
        FeaturestoreS3ConnectorEncryptionAlgorithm encryptionAlgorithm = this.getEncryptionAlgorithm(featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm());
        this.verifyUserInput(featurestore, featurestoreS3ConnectorDTO);
        FeaturestoreS3Connector featurestoreS3Connector = new FeaturestoreS3Connector();
        featurestoreS3Connector.setAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
        featurestoreS3Connector.setBucket(featurestoreS3ConnectorDTO.getBucket());
        featurestoreS3Connector.setDescription(featurestoreS3ConnectorDTO.getDescription());
        featurestoreS3Connector.setName(featurestoreS3ConnectorDTO.getName());
        featurestoreS3Connector.setSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
        featurestoreS3Connector.setFeaturestore(featurestore);
        featurestoreS3Connector.setServerEncryptionAlgorithm(encryptionAlgorithm);
        featurestoreS3Connector.setServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
        this.featurestoreS3ConnectorFacade.persist(featurestoreS3Connector);
        return new FeaturestoreS3ConnectorDTO(featurestoreS3Connector);
    }

    public FeaturestoreS3ConnectorDTO updateFeaturestoreS3Connector(Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, Integer storageConnectorId) throws FeaturestoreException {
        FeaturestoreS3Connector featurestoreS3Connector = this.verifyS3ConnectorId(storageConnectorId, featurestore);
        FeaturestoreS3ConnectorEncryptionAlgorithm serverEncryptionAlgorithm = this.getEncryptionAlgorithm(featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm());
        this.verifyS3ConnectorName(featurestoreS3ConnectorDTO.getName(), featurestore, true);
        featurestoreS3Connector.setName(featurestoreS3ConnectorDTO.getName());
        this.verifyS3ConnectorName(featurestoreS3ConnectorDTO.getName(), featurestore, true);
        this.verifyS3ConnectorDescription(featurestoreS3ConnectorDTO.getDescription());
        featurestoreS3Connector.setDescription(featurestoreS3ConnectorDTO.getDescription());
        this.verifyS3ConnectorBucket(featurestoreS3ConnectorDTO.getBucket());
        featurestoreS3Connector.setBucket(featurestoreS3ConnectorDTO.getBucket());
        if (this.settings.isIAMRoleConfigured()) {
            this.verifySecretAndAccessKeysForIamRole(featurestoreS3ConnectorDTO);
        } else {
            this.verifyS3ConnectorAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
            this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
            featurestoreS3Connector.setAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
            featurestoreS3Connector.setSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
        }
        if (featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm() != null) {
            featurestoreS3Connector.setServerEncryptionAlgorithm(serverEncryptionAlgorithm);
            if (serverEncryptionAlgorithm.isRequiresKey()) {
                this.verifyS3ConnectorServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
                featurestoreS3Connector.setServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
            } else {
                featurestoreS3Connector.setServerEncryptionKey(null);
            }
        } else {
            if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getServerEncryptionKey())) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_ALGORITHM, Level.FINE, ", encryption algorithm not provided");
            }
            featurestoreS3Connector.setServerEncryptionAlgorithm(null);
            featurestoreS3Connector.setServerEncryptionKey(null);
        }
        if (featurestore != null) {
            featurestoreS3Connector.setFeaturestore(featurestore);
        }
        FeaturestoreS3Connector updatedFeaturestoreS3Connector = this.featurestoreS3ConnectorFacade.updateS3Connector(featurestoreS3Connector);
        return new FeaturestoreS3ConnectorDTO(updatedFeaturestoreS3Connector);
    }

    public FeaturestoreS3ConnectorDTO removeFeaturestoreS3Connector(Integer featurestoreS3Id) {
        FeaturestoreS3Connector featurestoreS3Connector = (FeaturestoreS3Connector)this.featurestoreS3ConnectorFacade.find(featurestoreS3Id);
        FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO = new FeaturestoreS3ConnectorDTO(featurestoreS3Connector);
        this.featurestoreS3ConnectorFacade.remove(featurestoreS3Connector);
        return featurestoreS3ConnectorDTO;
    }

    private FeaturestoreS3Connector verifyS3ConnectorId(Integer s3ConnectorId, Featurestore featurestore) throws FeaturestoreException {
        return this.featurestoreS3ConnectorFacade.findByIdAndFeaturestore(s3ConnectorId, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.S3_CONNECTOR_NOT_FOUND, Level.FINE, "S3 connector id: " + s3ConnectorId));
    }

    private void verifyFeaturestore(Featurestore featurestore) {
        if (featurestore == null) {
            throw new IllegalArgumentException("Featurestore was not found");
        }
    }

    private void verifyS3ConnectorName(String name, Featurestore featurestore, Boolean edit) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the storage connector name cannot be empty");
        }
        if (name.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the name should be less than 1000 characters.");
        }
        if (!edit.booleanValue() && featurestore.getFeaturestoreS3ConnectorConnections().stream().anyMatch(s3Con -> s3Con.getName().equalsIgnoreCase(name))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the storage connector name should be unique, there already exists a S3 connector with the same name ");
        }
    }

    private void verifyS3ConnectorDescription(String description) throws FeaturestoreException {
        if (description.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_DESCRIPTION, Level.FINE, ", the description should be less than: 1000");
        }
    }

    private void verifyS3ConnectorBucket(String bucket) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)bucket) || bucket.length() > 5000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_BUCKET, Level.FINE, ", the S3 bucket string should not be empty and not exceed: 5000 characters");
        }
    }

    private void verifyS3ConnectorAccessKey(String accessKey) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)accessKey)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_ACCESS_KEY, Level.FINE, "The S3 access key cannot be empty and must be less than 1000");
        }
        if (accessKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_ACCESS_KEY, Level.FINE, ", the S3 access key should not exceed: 1000 characters");
        }
    }

    private void verifyS3ConnectorSecretKey(String secretKey) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)secretKey)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SECRET_KEY, Level.FINE, "The S3 secret key cannot be empty and must be less than 1000");
        }
        if (secretKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SECRET_KEY, Level.FINE, ", the S3 secret key should not exceed: 1000 characters");
        }
    }

    private void verifyS3ConnectorServerEncryptionKey(String serverEncryptionKey) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)serverEncryptionKey)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_KEY, Level.FINE, "S3 server encryption key cannot be empty");
        }
        if (serverEncryptionKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_KEY, Level.FINE, ", the S3 server encryption key should not exceed: 1000 characters");
        }
    }

    private void verifyUserInput(Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException {
        if (featurestoreS3ConnectorDTO == null) {
            throw new IllegalArgumentException("Null input data");
        }
        this.verifyFeaturestore(featurestore);
        this.verifyS3ConnectorName(featurestoreS3ConnectorDTO.getName(), featurestore, false);
        this.verifyS3ConnectorDescription(featurestoreS3ConnectorDTO.getDescription());
        this.verifyS3ConnectorBucket(featurestoreS3ConnectorDTO.getBucket());
        if (this.settings.isIAMRoleConfigured()) {
            this.verifySecretAndAccessKeysForIamRole(featurestoreS3ConnectorDTO);
        } else {
            this.verifyS3ConnectorAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
            this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
        }
        FeaturestoreS3ConnectorEncryptionAlgorithm encryptionAlgorithm = this.getEncryptionAlgorithm(featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm());
        if (encryptionAlgorithm != null) {
            if (encryptionAlgorithm.isRequiresKey()) {
                this.verifyS3ConnectorServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
            } else {
                featurestoreS3ConnectorDTO.setServerEncryptionKey(null);
            }
        } else if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getServerEncryptionKey())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_ALGORITHM, Level.FINE, ", encryption algorithm not provided");
        }
    }

    private void verifySecretAndAccessKeysForIamRole(FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException {
        if (!(!this.settings.isIAMRoleConfigured() || Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getAccessKey()) && Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getSecretKey()))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.S3_KEYS_FORBIDDEN, Level.FINE, "S3 Access Keys are not allowed");
        }
    }

    private FeaturestoreS3ConnectorEncryptionAlgorithm getEncryptionAlgorithm(String s) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        FeaturestoreS3ConnectorEncryptionAlgorithm serverEncryptionAlgrithm = null;
        try {
            serverEncryptionAlgrithm = FeaturestoreS3ConnectorEncryptionAlgorithm.fromValue((String)s);
        }
        catch (IllegalArgumentException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_ALGORITHM, Level.FINE, ", " + e.getMessage());
        }
        return serverEncryptionAlgrithm;
    }

    public List<FeaturestoreStorageConnectorDTO> getS3ConnectorsForFeaturestore(Featurestore featurestore) {
        List<FeaturestoreS3Connector> s3Connectors = this.featurestoreS3ConnectorFacade.findByFeaturestore(featurestore);
        return s3Connectors.stream().map(s3Connector -> new FeaturestoreS3ConnectorDTO((FeaturestoreS3Connector)s3Connector)).collect(Collectors.toList());
    }

    public FeaturestoreS3ConnectorDTO getS3ConnectorWithIdAndFeaturestore(Featurestore featurestore, Integer id) throws FeaturestoreException {
        FeaturestoreS3Connector featurestoreS3Connector = this.verifyS3ConnectorId(id, featurestore);
        return new FeaturestoreS3ConnectorDTO(featurestoreS3Connector);
    }
}

