/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user.security.apiKey;

import io.hops.hopsworks.common.dao.user.security.apiKey.ApiKeyFacade;
import io.hops.hopsworks.common.dao.user.security.apiKey.ApiKeyScopeFacade;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountsEmailMessages;
import io.hops.hopsworks.common.security.utils.Secret;
import io.hops.hopsworks.common.security.utils.SecurityUtils;
import io.hops.hopsworks.common.util.EmailBean;
import io.hops.hopsworks.exceptions.ApiKeyException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiKey;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiKeyScope;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiScope;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.mail.Message;
import javax.mail.MessagingException;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ApiKeyController {
    private static final Logger LOGGER = Logger.getLogger(ApiKeyController.class.getName());
    private static final int RETRY_KEY_CREATION = 10;
    @EJB
    private ApiKeyFacade apiKeyFacade;
    @EJB
    private ApiKeyScopeFacade apiKeyScopeFacade;
    @EJB
    private SecurityUtils securityUtils;
    @EJB
    private EmailBean emailBean;

    public String createNewKey(Users user, String keyName, Set<ApiScope> scopes) throws UserException, ApiKeyException {
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        if (keyName == null || keyName.isEmpty()) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_NAME_NOT_SPECIFIED, Level.FINE);
        }
        if (keyName.length() > 45) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_NAME_NOT_VALID, Level.FINE);
        }
        if (scopes == null || scopes.isEmpty()) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_SCOPE_NOT_SPECIFIED, Level.FINE);
        }
        ApiKey apiKey = this.apiKeyFacade.findByUserAndName(user, keyName);
        if (apiKey != null) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_NAME_EXIST, Level.FINE);
        }
        Secret secret = this.generateApiKey();
        Date date = new Date();
        apiKey = new ApiKey(user, secret.getPrefix(), secret.getSha256HexDigest(), secret.getSalt(), date, date, keyName);
        List<ApiKeyScope> keyScopes = this.getKeyScopes(scopes, apiKey);
        apiKey.setApiKeyScopeCollection(keyScopes);
        this.apiKeyFacade.save(apiKey);
        this.sendCreatedEmail(user, keyName, date, scopes);
        return secret.getPrefixPlusSecret();
    }

    private Secret generateApiKey() throws ApiKeyException {
        int retry = 10;
        Secret secret = this.securityUtils.generateSecret();
        while (!(this.apiKeyFacade.findByPrefix(secret.getPrefix()) == null && secret.validateSize() || retry-- <= 0)) {
            secret = this.securityUtils.generateSecret();
        }
        if (retry < 1) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_NOT_CREATED, Level.SEVERE, "Failed to generate unique key prefix after 10 retries.");
        }
        return secret;
    }

    private List<ApiKeyScope> getKeyScopes(Set<ApiScope> scopes, ApiKey apiKey) {
        ArrayList<ApiKeyScope> keyScopes = new ArrayList<ApiKeyScope>();
        for (ApiScope scope : scopes) {
            keyScopes.add(new ApiKeyScope(scope, apiKey));
        }
        return keyScopes;
    }

    public Set<ApiScope> getScopes(ApiKey apiKey) {
        HashSet<ApiScope> scopes = new HashSet<ApiScope>();
        for (ApiKeyScope scope : apiKey.getApiKeyScopeCollection()) {
            scopes.add(scope.getScope());
        }
        return scopes;
    }

    public ApiKey getApiKey(String key) throws ApiKeyException {
        String[] parts = key.split("\\.");
        if (parts.length < 2) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_NOT_FOUND, Level.FINE);
        }
        ApiKey apiKey = this.apiKeyFacade.findByPrefix(parts[0]);
        if (apiKey == null) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_NOT_FOUND, Level.FINE);
        }
        Secret secret = new Secret(parts[0], parts[1], apiKey.getSalt());
        if (!secret.getSha256HexDigest().equals(apiKey.getSecret())) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_NOT_FOUND, Level.FINE);
        }
        return apiKey;
    }

    public List<ApiKey> getKeys(Users user) {
        return this.apiKeyFacade.findByUser(user);
    }

    public void deleteKey(Users user, String keyName) {
        ApiKey apiKey = this.apiKeyFacade.findByUserAndName(user, keyName);
        if (apiKey == null) {
            return;
        }
        this.apiKeyFacade.remove(apiKey);
        this.sendDeletedEmail(user, keyName);
    }

    public void deleteAll(Users user) {
        List<ApiKey> keys = this.apiKeyFacade.findByUser(user);
        for (ApiKey key : keys) {
            this.apiKeyFacade.remove(key);
        }
        this.sendDeletedAllEmail(user);
    }

    public ApiKey addScope(Users user, String keyName, Set<ApiScope> scopes) throws ApiKeyException {
        ApiKey apiKey = this.validate(user, keyName, scopes);
        Set<ApiScope> oldScopes = this.toApiScope(apiKey.getApiKeyScopeCollection());
        scopes.removeAll(oldScopes);
        if (!scopes.isEmpty()) {
            List<ApiKeyScope> newScopes = this.getKeyScopes(scopes, apiKey);
            apiKey.getApiKeyScopeCollection().addAll(newScopes);
            apiKey.setModified(new Date());
            apiKey = this.apiKeyFacade.update(apiKey);
        }
        return apiKey;
    }

    public ApiKey removeScope(Users user, String keyName, Set<ApiScope> scopes) throws ApiKeyException {
        ApiKey apiKey = this.validate(user, keyName, scopes);
        Collection oldScopes = apiKey.getApiKeyScopeCollection();
        ArrayList<ApiKeyScope> toRemove = new ArrayList<ApiKeyScope>();
        block0: for (ApiScope scope : scopes) {
            for (ApiKeyScope apiKeyScope : oldScopes) {
                if (!apiKeyScope.getScope().equals((Object)scope)) continue;
                toRemove.add(apiKeyScope);
                continue block0;
            }
        }
        boolean removed = apiKey.getApiKeyScopeCollection().removeAll(toRemove);
        if (removed && !apiKey.getApiKeyScopeCollection().isEmpty()) {
            for (ApiKeyScope apiKeyScope : toRemove) {
                this.apiKeyScopeFacade.remove(apiKeyScope);
            }
            apiKey.setModified(new Date());
            apiKey = this.apiKeyFacade.update(apiKey);
        } else if (removed && apiKey.getApiKeyScopeCollection().isEmpty()) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_SCOPE_EMPTY, Level.FINE);
        }
        return apiKey;
    }

    public ApiKey update(Users user, String keyName, Set<ApiScope> scopes) throws ApiKeyException {
        ApiKey apiKey = this.validate(user, keyName, scopes);
        Collection oldScopes = apiKey.getApiKeyScopeCollection();
        ArrayList<Object> toKeep = new ArrayList<Object>();
        ArrayList<ApiKeyScope> toAdd = new ArrayList<ApiKeyScope>();
        boolean added = false;
        for (ApiScope scope : scopes) {
            boolean exist = false;
            for (ApiKeyScope apiKeyScope : oldScopes) {
                if (!apiKeyScope.getScope().equals((Object)scope)) continue;
                toKeep.add(apiKeyScope);
                exist = true;
                break;
            }
            if (exist) continue;
            added = true;
            toAdd.add(new ApiKeyScope(scope, apiKey));
        }
        boolean update = false;
        oldScopes.removeAll(toKeep);
        if (!oldScopes.isEmpty()) {
            for (ApiKeyScope apiKeyScope : oldScopes) {
                this.apiKeyScopeFacade.remove(apiKeyScope);
            }
            update = true;
        }
        if (added) {
            toKeep.addAll(toAdd);
            update = true;
        }
        if (update) {
            apiKey.setApiKeyScopeCollection(toKeep);
            apiKey.setModified(new Date());
            apiKey = this.apiKeyFacade.update(apiKey);
        }
        return apiKey;
    }

    private Set<ApiScope> toApiScope(Collection<ApiKeyScope> scopeSet) {
        HashSet<ApiScope> scopes = new HashSet<ApiScope>();
        for (ApiKeyScope apiKeyScope : scopeSet) {
            scopes.add(apiKeyScope.getScope());
        }
        return scopes;
    }

    private ApiKey validate(Users user, String keyName, Set<ApiScope> scopes) throws ApiKeyException {
        ApiKey apiKey = this.apiKeyFacade.findByUserAndName(user, keyName);
        if (apiKey == null) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_NOT_FOUND, Level.FINE);
        }
        if (scopes == null || scopes.isEmpty()) {
            throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_SCOPE_NOT_SPECIFIED, Level.FINE);
        }
        return apiKey;
    }

    private void sendCreatedEmail(Users user, String keyName, Date createdOn, Set<ApiScope> scopes) {
        String subject = "Api key created";
        String msg = UserAccountsEmailMessages.buildApiKeyCreatedMessage(keyName, createdOn, user.getEmail(), scopes);
        this.sendEmail(user, subject, msg);
    }

    private void sendDeletedEmail(Users user, String keyName) {
        String subject = "Api key deleted";
        Date deletedOn = new Date();
        String msg = UserAccountsEmailMessages.buildApiKeyDeletedMessage(keyName, deletedOn, user.getEmail());
        this.sendEmail(user, subject, msg);
    }

    private void sendDeletedAllEmail(Users user) {
        String subject = "Api key deleted";
        Date deletedOn = new Date();
        String msg = UserAccountsEmailMessages.buildApiKeyDeletedAllMessage(deletedOn, user.getEmail());
        this.sendEmail(user, subject, msg);
    }

    private void sendEmail(Users user, String subject, String msg) {
        if (user == null) {
            throw new IllegalArgumentException("User not set.");
        }
        try {
            this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
        }
        catch (MessagingException e) {
            LOGGER.log(Level.WARNING, "Failed to send api key creation verification email. {0}", e.getMessage());
        }
    }
}

