/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.query;

import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.query.Query;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

public class Join {
    private Query leftQuery;
    private Query rightQuery;
    private List<FeatureDTO> on;
    private List<FeatureDTO> leftOn;
    private List<FeatureDTO> rightOn;
    private JoinType joinType;

    public Join(Query leftQuery) {
        this.leftQuery = leftQuery;
    }

    public Join(Query leftQuery, Query rightQuery, List<FeatureDTO> on, JoinType joinType) {
        this.leftQuery = leftQuery;
        this.rightQuery = rightQuery;
        this.on = on;
        this.joinType = joinType;
    }

    public Join(Query leftQuery, Query rightQuery, List<FeatureDTO> leftOn, List<FeatureDTO> rightOn, JoinType joinType) {
        this.leftQuery = leftQuery;
        this.rightQuery = rightQuery;
        this.leftOn = leftOn;
        this.rightOn = rightOn;
        this.joinType = joinType;
    }

    public Query getLeftQuery() {
        return this.leftQuery;
    }

    public void setLeftQuery(Query leftQuery) {
        this.leftQuery = leftQuery;
    }

    public Query getRightQuery() {
        return this.rightQuery;
    }

    public void setRightQuery(Query rightQuery) {
        this.rightQuery = rightQuery;
    }

    public void setLeftOn(List<FeatureDTO> leftOn) {
        this.leftOn = leftOn;
    }

    public void setRightOn(List<FeatureDTO> rightOn) {
        this.rightOn = rightOn;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    public List<FeatureDTO> getOn() {
        return this.on;
    }

    public void setOn(List<FeatureDTO> on) {
        this.on = on;
    }

    public List<FeatureDTO> getLeftOn() {
        return this.leftOn;
    }

    public List<FeatureDTO> getRightOn() {
        return this.rightOn;
    }

    public SqlNode getCondition() {
        if (this.on != null) {
            return this.getOnCondition();
        }
        return this.getLeftRightCondition();
    }

    private SqlNode getOnCondition() {
        if (this.on.size() > 1) {
            SqlNodeList conditionList = new SqlNodeList(SqlParserPos.ZERO);
            for (FeatureDTO f : this.on) {
                conditionList.add(this.generateEqualityCondition(this.leftQuery.getAs(), this.rightQuery.getAs(), f, f));
            }
            return SqlStdOperatorTable.AND.createCall(conditionList);
        }
        return this.generateEqualityCondition(this.leftQuery.getAs(), this.rightQuery.getAs(), this.on.get(0), this.on.get(0));
    }

    private SqlNode getLeftRightCondition() {
        if (this.leftOn.size() > 1) {
            SqlNodeList conditionList = new SqlNodeList(SqlParserPos.ZERO);
            for (int i = 0; i < this.leftOn.size(); ++i) {
                conditionList.add(this.generateEqualityCondition(this.leftQuery.getAs(), this.rightQuery.getAs(), this.leftOn.get(i), this.rightOn.get(i)));
            }
            return SqlStdOperatorTable.AND.createCall(conditionList);
        }
        return this.generateEqualityCondition(this.leftQuery.getAs(), this.rightQuery.getAs(), this.leftOn.get(0), this.rightOn.get(0));
    }

    private SqlNode generateEqualityCondition(String leftFgAs, String rightFgAs, FeatureDTO leftOn, FeatureDTO rightOn) {
        SqlIdentifier leftHandside = new SqlIdentifier(Arrays.asList("`" + leftFgAs + "`", "`" + leftOn.getName() + "`"), SqlParserPos.ZERO);
        SqlIdentifier rightHandside = new SqlIdentifier(Arrays.asList("`" + rightFgAs + "`", "`" + rightOn.getName() + "`"), SqlParserPos.ZERO);
        SqlNodeList equalityList = new SqlNodeList(SqlParserPos.ZERO);
        equalityList.add((SqlNode)leftHandside);
        equalityList.add((SqlNode)rightHandside);
        return SqlStdOperatorTable.EQUALS.createCall(equalityList);
    }
}

