/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets.external;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorType;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetFacade;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.external.ExternalTrainingDataset;
import java.nio.file.Paths;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ExternalTrainingDatasetController {
    @EJB
    private ExternalTrainingDatasetFacade externalTrainingDatasetFacade;

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeExternalTrainingDataset(ExternalTrainingDataset externalTrainingDataset) {
        this.externalTrainingDatasetFacade.remove(externalTrainingDataset);
    }

    public TrainingDatasetDTO convertExternalTrainingDatasetToDTO(TrainingDatasetDTO trainingDatasetDTO, TrainingDataset trainingDataset) {
        ExternalTrainingDataset externalTrainingDataset = trainingDataset.getExternalTrainingDataset();
        trainingDatasetDTO.setStorageConnectorId(externalTrainingDataset.getFeaturestoreS3Connector().getId());
        trainingDatasetDTO.setStorageConnectorName(externalTrainingDataset.getFeaturestoreS3Connector().getName());
        trainingDatasetDTO.setStorageConnectorType(FeaturestoreStorageConnectorType.S3);
        trainingDatasetDTO.setLocation(this.buildDatasetPath(trainingDataset));
        return trainingDatasetDTO;
    }

    private String buildDatasetPath(TrainingDataset trainingDataset) {
        String bucketFolder = "TRAINING_DATASETS";
        if (!Strings.isNullOrEmpty((String)trainingDataset.getExternalTrainingDataset().getPath())) {
            bucketFolder = trainingDataset.getExternalTrainingDataset().getPath();
        }
        return "s3://" + Paths.get(trainingDataset.getExternalTrainingDataset().getFeaturestoreS3Connector().getBucket(), bucketFolder, trainingDataset.getName() + "_" + trainingDataset.getVersion()).toString();
    }
}

