/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.library;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.environment.DockerRegistryMngr;
import io.hops.hopsworks.common.python.environment.EnvironmentController;
import io.hops.hopsworks.common.python.library.LibraryController;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.command.SystemCommand;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.apache.commons.io.FileUtils;

@Singleton
@Startup
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class LibraryInstaller {
    private static final Logger LOG = Logger.getLogger(LibraryInstaller.class.getName());
    private static final Comparator<CondaCommands> ASC_COMPARATOR = new CommandsComparator<CondaCommands>();
    private final AtomicInteger registryGCCycles = new AtomicInteger();
    private String prog;
    private String anaconda_dir;
    private String anaconda_project_dir;
    @Resource
    private TimerService timerService;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private LibraryController libraryController;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private EnvironmentController environmentController;
    @EJB
    private Settings settings;
    @Inject
    private DockerRegistryMngr registry;
    private ManagedExecutorService executorService;
    @EJB
    private DistributedFsService dfs;

    @PostConstruct
    public void init() {
        this.prog = this.settings.getSudoersDir() + "/dockerImage.sh";
        this.anaconda_dir = this.settings.getAnacondaDir();
        this.anaconda_project_dir = this.anaconda_dir + "/envs/" + this.settings.getCurrentCondaEnvironment();
        List<CondaCommands> allOngoing = this.condaCommandFacade.findByStatus(CondaStatus.ONGOING);
        allOngoing.forEach(cc -> {
            cc.setStatus(CondaStatus.FAILED);
            cc.setErrorMsg("Could not run conda command due to internal server error. Please try again.");
            this.condaCommandFacade.update(cc);
        });
        try {
            this.executorService = (ManagedExecutorService)InitialContext.doLookup("concurrent/condaExecutorService");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error looking up for the condaExecutorService", e);
        }
        this.schedule();
    }

    private void schedule() {
        this.timerService.createSingleActionTimer(1000L, new TimerConfig((Serializable)((Object)"python library installer"), false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void isAlive() {
        try {
            LOG.log(Level.FINE, "isAlive-start: " + System.currentTimeMillis());
            this.registryGCCycles.incrementAndGet();
            List<CondaCommands> allCondaCommandsOngoing = this.condaCommandFacade.findByStatus(CondaStatus.ONGOING);
            if (this.registryGCCycles.get() % 10 == 0 && allCondaCommandsOngoing.isEmpty()) {
                this.registryGCCycles.set(0);
                try {
                    LOG.log(Level.FINE, "registryGC-start: " + System.currentTimeMillis());
                    this.registry.gc();
                    LOG.log(Level.FINE, "registryGC-stop: " + System.currentTimeMillis());
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Could not run conda remove commands", ex);
                }
            } else {
                Map<Project, List<CondaCommands>> allCondaCommandsNewByProject = this.getCondaCommandsByProject(this.condaCommandFacade.findByStatus(CondaStatus.NEW));
                Map<Project, List<CondaCommands>> allCondaCommandsOngoingByProject = this.getCondaCommandsByProject(this.condaCommandFacade.findByStatus(CondaStatus.ONGOING));
                LOG.log(Level.FINE, "allCondaCommandsOngoingByProject:" + allCondaCommandsOngoingByProject);
                for (Project project : allCondaCommandsNewByProject.keySet()) {
                    if (!allCondaCommandsOngoingByProject.containsKey(project)) {
                        try {
                            this.executorService.submit(() -> this.condaCommandHandler((List)allCondaCommandsNewByProject.get(project)));
                        }
                        catch (Exception ex) {
                            LOG.log(Level.WARNING, "Could not run conda commands for project: " + project, ex);
                        }
                        continue;
                    }
                    LOG.log(Level.FINE, "Project " + project.getName() + " is already processing a conda command, skipping...");
                }
            }
        }
        finally {
            LOG.log(Level.FINE, "isAlive-stop: " + System.currentTimeMillis());
            this.schedule();
        }
    }

    private void condaCommandHandler(List<CondaCommands> projectCondaCommands) {
        projectCondaCommands.sort(ASC_COMPARATOR);
        for (CondaCommands cc : projectCondaCommands) {
            if (cc.getOp() == CondaOp.REMOVE) continue;
            try {
                try {
                    this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.ONGOING, cc.getArg(), cc.getOp());
                    switch (cc.getOp()) {
                        case CREATE: 
                        case IMPORT: {
                            this.createNewImage(cc);
                            break;
                        }
                        case INSTALL: {
                            this.installLibrary(cc);
                            break;
                        }
                        case UNINSTALL: {
                            this.uninstallLibrary(cc);
                            break;
                        }
                        case EXPORT: {
                            this.exportLibraries(cc);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("conda command unknown: " + cc.getOp());
                        }
                    }
                }
                catch (Throwable ex) {
                    LOG.log(Level.WARNING, "Could not execute command with ID: " + cc.getId(), ex);
                    this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.FAILED, cc.getArg(), cc.getOp(), ex.toString());
                    continue;
                }
                this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.SUCCESS, cc.getArg(), cc.getOp());
            }
            catch (ProjectException | ServiceException ex) {
                LOG.log(Level.WARNING, "Could not update command with ID: " + cc.getId(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewImage(CondaCommands cc) throws IOException, ServiceDiscoveryException {
        File baseDir = new File("/tmp/docker/" + cc.getProjectId().getName());
        baseDir.mkdirs();
        try {
            File dockerFile;
            block23: {
                File home = new File(System.getProperty("user.home"));
                File condarc = new File(home, ".condarc");
                File pip = new File(home, ".pip");
                FileUtils.copyFileToDirectory((File)condarc, (File)baseDir);
                FileUtils.copyDirectoryToDirectory((File)pip, (File)baseDir);
                dockerFile = new File(baseDir, "dockerFile_" + cc.getProjectId().getName());
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(dockerFile));){
                    String baseImage = this.projectUtils.getFullBaseImageName();
                    if (!Strings.isNullOrEmpty((String)cc.getEnvironmentYml()) && !cc.getInstallJupyter().booleanValue()) {
                        baseImage = baseImage.replace(this.settings.getBaseDockerImagePythonName(), this.settings.getBaseNonPythonDockerImage());
                    }
                    writer.write("# syntax=docker/dockerfile:experimental");
                    writer.newLine();
                    writer.write("FROM " + baseImage);
                    writer.newLine();
                    if (Strings.isNullOrEmpty((String)cc.getEnvironmentYml())) break block23;
                    String projectEnvYml = "environment.yml";
                    try (DistributedFileSystemOps dfso = null;){
                        dfso = this.dfs.getDfsOps();
                        dfso.copyToLocal(cc.getEnvironmentYml(), baseDir + File.separator + projectEnvYml);
                    }
                    writer.write("RUN rm -f /root/.condarc");
                    writer.newLine();
                    writer.write("COPY .condarc .pip " + projectEnvYml + " /root/");
                    writer.newLine();
                    String dockerCondaCmd = cc.getInstallJupyter() != false ? "RUN conda env update -f /root/" + projectEnvYml + " -n " + this.settings.getCurrentCondaEnvironment() : "RUN conda env create -f /root/" + projectEnvYml + " -n " + this.settings.getCurrentCondaEnvironment();
                    writer.write(dockerCondaCmd);
                }
            }
            Project project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
            String initialDockerImage = this.projectUtils.getInitialDockerImageName(project);
            LOG.log(Level.FINEST, "project-initialDockerImage:" + initialDockerImage);
            ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.prog).addCommand("create").addCommand(dockerFile.getAbsolutePath()).addCommand(this.projectUtils.getRegistryURL() + "/" + initialDockerImage).redirectErrorStream(true).setCurrentWorkingDirectory(baseDir).setWaitTimeout(30L, TimeUnit.MINUTES).build();
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new IOException(errorMsg);
            }
            project.setDockerImage(initialDockerImage);
            this.projectFacade.update(project);
            this.projectFacade.flushEm();
            Collection<PythonDep> envDeps = this.libraryController.listLibraries(this.projectUtils.getFullDockerImageName(project, false));
            project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
            this.libraryController.addPythonDepsForProject(project, envDeps);
        }
        catch (ProjectException | ServiceException e) {
            LOG.log(Level.SEVERE, "Failed to persist python deps", e);
        }
        finally {
            FileUtils.deleteDirectory((File)baseDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void installLibrary(CondaCommands cc) throws IOException, ServiceException, ServiceDiscoveryException, ProjectException {
        baseDir = new File("/tmp/docker/" + cc.getProjectId().getName());
        baseDir.mkdirs();
        project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow((Supplier<ProjectException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$installLibrary$4(io.hops.hopsworks.persistence.entity.python.CondaCommands ), ()Lio/hops/hopsworks/exceptions/ProjectException;)((CondaCommands)cc));
        try {
            home = new File(System.getProperty("user.home"));
            condarc = new File(home, ".condarc");
            pip = new File(home, ".pip");
            FileUtils.copyFileToDirectory((File)condarc, (File)baseDir);
            FileUtils.copyDirectoryToDirectory((File)pip, (File)baseDir);
            dockerFile = new File(baseDir, "dockerFile_" + cc.getProjectId().getName());
            writer = new BufferedWriter(new FileWriter(dockerFile));
            var9_9 = null;
            try {
                writer.write("# syntax=docker/dockerfile:experimental");
                writer.newLine();
                writer.write("FROM " + this.projectUtils.getFullDockerImageName(project, false));
                writer.newLine();
                writer.write("RUN --mount=type=bind,source=.condarc,target=/root/.condarc --mount=type=bind,source=.pip,target=/root/.pip ");
                switch (1.$SwitchMap$io$hops$hopsworks$persistence$entity$python$CondaInstallType[cc.getInstallType().ordinal()]) {
                    case 1: {
                        writer.write(this.anaconda_dir + "/bin/conda install -y -n " + this.settings.getCurrentCondaEnvironment() + " -c " + cc.getChannelUrl() + " " + cc.getLib() + "=" + cc.getVersion());
                        ** break;
lbl24:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        writer.write(this.anaconda_project_dir + "/bin/pip install --upgrade " + cc.getLib() + "==" + cc.getVersion());
                        ** break;
lbl28:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("install type unknown: " + cc.getInstallType());
                    }
                }
            }
            catch (Throwable var10_11) {
                var9_9 = var10_11;
                throw var10_11;
            }
            finally {
                if (writer != null) {
                    if (var9_9 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable var10_10) {
                            var9_9.addSuppressed(var10_10);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            nextDockerImageName = this.getNextDockerImageName(project);
            LibraryInstaller.LOG.log(Level.FINEST, "project-nextDockerImageName:" + nextDockerImageName);
            processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.prog).addCommand("create").addCommand(dockerFile.getAbsolutePath()).addCommand(this.projectUtils.getRegistryURL() + "/" + nextDockerImageName).redirectErrorStream(true).setCurrentWorkingDirectory(baseDir).setWaitTimeout(300L, TimeUnit.SECONDS).build();
            processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new IOException(errorMsg);
            }
            project.setDockerImage(nextDockerImageName);
            this.projectFacade.update(project);
            this.projectFacade.flushEm();
        }
        finally {
            FileUtils.deleteDirectory((File)baseDir);
        }
        project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow((Supplier<ProjectException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$installLibrary$5(io.hops.hopsworks.persistence.entity.python.CondaCommands ), ()Lio/hops/hopsworks/exceptions/ProjectException;)((CondaCommands)cc));
        envDeps = this.libraryController.listLibraries(this.projectUtils.getFullDockerImageName(project, false));
        this.libraryController.addPythonDepsForProject(project, envDeps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void uninstallLibrary(CondaCommands cc) throws IOException, ServiceDiscoveryException, ProjectException {
        baseDir = new File("/tmp/docker/" + cc.getProjectId().getName());
        baseDir.mkdirs();
        try {
            dockerFile = new File(baseDir, "dockerFile_" + cc.getProjectId().getName());
            writer = new BufferedWriter(new FileWriter(dockerFile));
            var5_5 = null;
            try {
                writer.write("FROM " + this.projectUtils.getFullDockerImageName(cc.getProjectId(), false) + "\n");
                switch (1.$SwitchMap$io$hops$hopsworks$persistence$entity$python$CondaInstallType[cc.getInstallType().ordinal()]) {
                    case 1: {
                        writer.write("RUN " + this.anaconda_dir + "/bin/conda remove -y -n " + this.settings.getCurrentCondaEnvironment() + " " + cc.getLib() + "\n");
                        ** break;
lbl14:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        writer.write("RUN " + this.anaconda_project_dir + "/bin/pip uninstall -y " + cc.getLib() + "\n");
                        ** break;
lbl18:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("install type unknown: " + cc.getInstallType());
                    }
                }
            }
            catch (Throwable var6_7) {
                var5_5 = var6_7;
                throw var6_7;
            }
            finally {
                if (writer != null) {
                    if (var5_5 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable var6_6) {
                            var5_5.addSuppressed(var6_6);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow((Supplier<ProjectException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$uninstallLibrary$6(io.hops.hopsworks.persistence.entity.python.CondaCommands ), ()Lio/hops/hopsworks/exceptions/ProjectException;)((CondaCommands)cc));
            nextDockerImageName = this.getNextDockerImageName(project);
            processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.prog).addCommand("create").addCommand(dockerFile.getAbsolutePath()).addCommand(this.projectUtils.getRegistryURL() + "/" + nextDockerImageName).redirectErrorStream(true).setCurrentWorkingDirectory(baseDir).setWaitTimeout(300L, TimeUnit.SECONDS).build();
            processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
                throw new IOException(errorMsg);
            }
            project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow((Supplier<ProjectException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$uninstallLibrary$7(io.hops.hopsworks.persistence.entity.python.CondaCommands ), ()Lio/hops/hopsworks/exceptions/ProjectException;)((CondaCommands)cc));
            project.setDockerImage(nextDockerImageName);
            this.projectFacade.update(project);
            this.projectFacade.flushEm();
        }
        finally {
            FileUtils.deleteDirectory((File)baseDir);
        }
    }

    public void exportLibraries(CondaCommands cc) throws IOException, ServiceException, ServiceDiscoveryException, ProjectException {
        Project project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(this.prog).addCommand("export").addCommand(this.projectUtils.getFullDockerImageName(project, false)).redirectErrorStream(true).setWaitTimeout(300L, TimeUnit.SECONDS).build();
        ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
        if (processResult.getExitCode() != 0) {
            String errorMsg = "Could not create the docker image. Exit code: " + processResult.getExitCode() + " out: " + processResult.getStdout() + "\n err: " + processResult.getStderr() + "||\n";
            throw new IOException(errorMsg);
        }
        this.environmentController.uploadYmlInProject(project, cc.getUserId(), processResult.getStdout(), cc.getArg());
    }

    private String getNextDockerImageName(Project project) {
        String dockerImage = ProjectUtils.getDockerImageName(project, this.settings, false);
        int indexOfLastDigit = dockerImage.lastIndexOf(".");
        int currentVersion = Integer.parseInt(dockerImage.substring(indexOfLastDigit + 1));
        int nextVersion = currentVersion + 1;
        return dockerImage.substring(0, indexOfLastDigit) + "." + nextVersion;
    }

    private Map<Project, List<CondaCommands>> getCondaCommandsByProject(List<CondaCommands> condaCommands) {
        HashMap<Project, List<CondaCommands>> condaCommandsByProject = new HashMap<Project, List<CondaCommands>>();
        for (CondaCommands condacommand : condaCommands) {
            if (!(condacommand.getOp() == CondaOp.REMOVE || condacommand.getProjectId() != null && condacommand.getProjectId().getConda().booleanValue())) {
                LOG.log(Level.FINEST, "Removing condacommand: " + condacommand);
                this.condaCommandFacade.remove(condacommand);
                continue;
            }
            Project project = condacommand.getProjectId();
            if (!condaCommandsByProject.containsKey(project)) {
                condaCommandsByProject.put(project, new ArrayList());
            }
            ((List)condaCommandsByProject.get(project)).add(condacommand);
        }
        return condaCommandsByProject;
    }

    private static /* synthetic */ ProjectException lambda$uninstallLibrary$7(CondaCommands cc) {
        return new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId());
    }

    private static /* synthetic */ ProjectException lambda$uninstallLibrary$6(CondaCommands cc) {
        return new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId());
    }

    private static /* synthetic */ ProjectException lambda$installLibrary$5(CondaCommands cc) {
        return new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId());
    }

    private static /* synthetic */ ProjectException lambda$installLibrary$4(CondaCommands cc) {
        return new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId());
    }

    private static class CommandsComparator<T>
    implements Comparator<T> {
        private CommandsComparator() {
        }

        @Override
        public int compare(T t, T t1) {
            if (t instanceof CondaCommands && t1 instanceof CondaCommands) {
                return this.condaCommandCompare((CondaCommands)t, (CondaCommands)t1);
            }
            if (t instanceof SystemCommand && t1 instanceof SystemCommand) {
                return this.systemCommandCompare((SystemCommand)t, (SystemCommand)t1);
            }
            return 0;
        }

        private int condaCommandCompare(CondaCommands t, CondaCommands t1) {
            return t.getId().compareTo(t1.getId());
        }

        private int systemCommandCompare(SystemCommand t, SystemCommand t1) {
            return t.getId().compareTo(t1.getId());
        }
    }
}

